/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.s1tbx.commons.RGBProfiles;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;

public class S1TBXSetup {
    public static void installColorPalettes(Class callingClass, String path) {
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath((Class)callingClass);
        Path auxdataDir = S1TBXSetup.getColorPalettesDir();
        Path sourcePath = moduleBasePath.resolve(path);
        ResourceInstaller resourceInstaller = new ResourceInstaller(sourcePath, auxdataDir);
        try {
            resourceInstaller.install(".*.cpd", ProgressMonitor.NULL);
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to install colour palettes " + moduleBasePath + " to " + auxdataDir + " " + e.getMessage());
        }
    }

    private static Path getColorPalettesDir() {
        return SystemUtils.getAuxDataPath().resolve("color_palettes");
    }

    static {
        RGBProfiles.registerRGBProfiles();
    }
}

