/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;
import org.esa.snap.engine_utilities.datamodel.PosVector;

public final class OrbitStateVectors {
    public OrbitStateVector[] orbitStateVectors = null;
    public PosVector[] sensorPosition = null;
    public PosVector[] sensorVelocity = null;
    private double dt = 0.0;
    private final Map<Double, PositionVelocity> timeMap = new HashMap<Double, PositionVelocity>();
    private static final int nv = 8;

    public OrbitStateVectors(OrbitStateVector[] orbitStateVectors, double firstLineUTC, double lineTimeInterval, int sourceImageHeight) {
        this.orbitStateVectors = OrbitStateVectors.removeRedundantVectors(orbitStateVectors);
        this.dt = (this.orbitStateVectors[this.orbitStateVectors.length - 1].time_mjd - this.orbitStateVectors[0].time_mjd) / (double)(this.orbitStateVectors.length - 1);
        this.sensorPosition = new PosVector[sourceImageHeight];
        this.sensorVelocity = new PosVector[sourceImageHeight];
        for (int i = 0; i < sourceImageHeight; ++i) {
            double time = firstLineUTC + (double)i * lineTimeInterval;
            PositionVelocity pv = this.getPositionVelocity(time);
            this.sensorPosition[i] = pv.position;
            this.sensorVelocity[i] = pv.velocity;
        }
    }

    public OrbitStateVectors(OrbitStateVector[] orbitStateVectors) {
        this.orbitStateVectors = OrbitStateVectors.removeRedundantVectors(orbitStateVectors);
        this.dt = (this.orbitStateVectors[orbitStateVectors.length - 1].time_mjd - this.orbitStateVectors[0].time_mjd) / (double)(this.orbitStateVectors.length - 1);
    }

    private static OrbitStateVector[] removeRedundantVectors(OrbitStateVector[] orbitStateVectors) {
        ArrayList<OrbitStateVector> vectorList = new ArrayList<OrbitStateVector>();
        double currentTime = 0.0;
        for (int i = 0; i < orbitStateVectors.length; ++i) {
            if (i == 0) {
                currentTime = orbitStateVectors[i].time_mjd;
                vectorList.add(orbitStateVectors[i]);
                continue;
            }
            if (!(orbitStateVectors[i].time_mjd > currentTime)) continue;
            currentTime = orbitStateVectors[i].time_mjd;
            vectorList.add(orbitStateVectors[i]);
        }
        return vectorList.toArray(new OrbitStateVector[0]);
    }

    public PositionVelocity getPositionVelocity(Double time) {
        int iN;
        int i0;
        PositionVelocity cachedPosVel = this.timeMap.get(time);
        if (cachedPosVel != null) {
            return cachedPosVel;
        }
        if (this.orbitStateVectors.length <= 8) {
            i0 = 0;
            iN = this.orbitStateVectors.length - 1;
        } else {
            i0 = Math.max((int)((time - this.orbitStateVectors[0].time_mjd) / this.dt) - 4 + 1, 0);
            iN = Math.min(i0 + 8 - 1, this.orbitStateVectors.length - 1);
            i0 = iN < this.orbitStateVectors.length - 1 ? i0 : iN - 8 + 1;
        }
        PositionVelocity pv = new PositionVelocity();
        for (int i = i0; i <= iN; ++i) {
            OrbitStateVector orbI = this.orbitStateVectors[i];
            double weight = 1.0;
            for (int j = i0; j <= iN; ++j) {
                if (j == i) continue;
                double time2 = this.orbitStateVectors[j].time_mjd;
                weight *= (time - time2) / (orbI.time_mjd - time2);
            }
            pv.position.x += weight * orbI.x_pos;
            pv.position.y += weight * orbI.y_pos;
            pv.position.z += weight * orbI.z_pos;
            pv.velocity.x += weight * orbI.x_vel;
            pv.velocity.y += weight * orbI.y_vel;
            pv.velocity.z += weight * orbI.z_vel;
        }
        this.timeMap.put(time, pv);
        return pv;
    }

    PosVector getPosition(double time, PosVector position) {
        int iN;
        int i0;
        if (this.orbitStateVectors.length <= 8) {
            i0 = 0;
            iN = this.orbitStateVectors.length - 1;
        } else {
            i0 = Math.max((int)((time - this.orbitStateVectors[0].time_mjd) / this.dt) - 4 + 1, 0);
            iN = Math.min(i0 + 8 - 1, this.orbitStateVectors.length - 1);
            i0 = iN < this.orbitStateVectors.length - 1 ? i0 : iN - 8 + 1;
        }
        position.x = 0.0;
        position.y = 0.0;
        position.z = 0.0;
        for (int i = i0; i <= iN; ++i) {
            OrbitStateVector orbI = this.orbitStateVectors[i];
            double weight = 1.0;
            for (int j = i0; j <= iN; ++j) {
                if (j == i) continue;
                double time2 = this.orbitStateVectors[j].time_mjd;
                weight *= (time - time2) / (orbI.time_mjd - time2);
            }
            position.x += weight * orbI.x_pos;
            position.y += weight * orbI.y_pos;
            position.z += weight * orbI.z_pos;
        }
        return position;
    }

    PosVector getVelocity(double time) {
        int iN;
        int i0;
        if (this.orbitStateVectors.length <= 8) {
            i0 = 0;
            iN = this.orbitStateVectors.length - 1;
        } else {
            i0 = Math.max((int)((time - this.orbitStateVectors[0].time_mjd) / this.dt) - 4 + 1, 0);
            iN = Math.min(i0 + 8 - 1, this.orbitStateVectors.length - 1);
            i0 = iN < this.orbitStateVectors.length - 1 ? i0 : iN - 8 + 1;
        }
        PosVector velocity = new PosVector();
        for (int i = i0; i <= iN; ++i) {
            OrbitStateVector orbI = this.orbitStateVectors[i];
            double weight = 1.0;
            for (int j = i0; j <= iN; ++j) {
                if (j == i) continue;
                double time2 = this.orbitStateVectors[j].time_mjd;
                weight *= (time - time2) / (orbI.time_mjd - time2);
            }
            velocity.x += weight * orbI.x_vel;
            velocity.y += weight * orbI.y_vel;
            velocity.z += weight * orbI.z_vel;
        }
        return velocity;
    }

    private int[] findAdjacentVectors(double time) {
        int[] vectorIndices;
        int i;
        int nv = 8;
        int totalVectors = this.orbitStateVectors.length;
        if (totalVectors <= 8) {
            int[] vectorIndices2 = new int[totalVectors];
            for (int i2 = 0; i2 < totalVectors; ++i2) {
                vectorIndices2[i2] = i2;
            }
            return vectorIndices2;
        }
        int idx = 0;
        for (i = 0; i < totalVectors; ++i) {
            if (!(time < this.orbitStateVectors[i].time_mjd)) continue;
            idx = i - 1;
            break;
        }
        if (idx == -1) {
            vectorIndices = new int[8];
            for (i = 0; i < 8; ++i) {
                vectorIndices[i] = i;
            }
        } else if (idx == 0) {
            vectorIndices = new int[8];
            for (i = 0; i < 8; ++i) {
                vectorIndices[i] = totalVectors - 8 + i;
            }
        } else {
            int stIdx = Math.max(idx - 4 + 1, 0);
            int edIdx = Math.min(idx + 4, totalVectors - 1);
            vectorIndices = new int[edIdx - stIdx + 1];
            for (int i3 = 0; i3 < vectorIndices.length; ++i3) {
                vectorIndices[i3] = stIdx + i3;
            }
        }
        return vectorIndices;
    }

    public static class PositionVelocity {
        public final PosVector position = new PosVector();
        public final PosVector velocity = new PosVector();
    }
}

