/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.commons;

import java.awt.geom.Rectangle2D;
import javax.measure.unit.NonSI;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSGeoCodingHandler {
    private final CoordinateReferenceSystem targetCRS;
    private final CrsGeoCoding geoCoding;
    private final int targetWidth;
    private final int targetHeight;

    public CRSGeoCodingHandler(Product sourceProduct, String mapProjection, double pixelSpacingInDegree, double pixelSpacingInMeter) throws Exception {
        this(sourceProduct, mapProjection, pixelSpacingInDegree, pixelSpacingInMeter, false);
    }

    public CRSGeoCodingHandler(Product sourceProduct, String mapProjection, double pixelSpacingInDegree, double pixelSpacingInMeter, boolean alignToStandardGrid) throws Exception {
        this(sourceProduct, mapProjection, pixelSpacingInDegree, pixelSpacingInMeter, alignToStandardGrid, 0.0, 0.0);
    }

    public CRSGeoCodingHandler(Product sourceProduct, String mapProjection, double pixelSpacingInDegree, double pixelSpacingInMeter, boolean alignToStandardGrid, double standardGridOriginX, double standardGridOriginY) throws Exception {
        this.targetCRS = CRSGeoCodingHandler.getCRS(sourceProduct, mapProjection);
        OperatorUtils.ImageGeoBoundary srcImageBoundary = OperatorUtils.computeImageGeoBoundary((Product)sourceProduct);
        double pixelSizeX = pixelSpacingInMeter;
        double pixelSizeY = pixelSpacingInMeter;
        if (this.targetCRS.getName().getCode().equals("WGS84(DD)") || this.targetCRS.getCoordinateSystem().getAxis(0).getUnit().equals((Object)NonSI.DEGREE_ANGLE)) {
            pixelSizeX = pixelSpacingInDegree;
            pixelSizeY = pixelSpacingInDegree;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        double lonMin = srcImageBoundary.lonMin;
        double lonMax = srcImageBoundary.lonMax;
        bounds.setFrameFromDiagonal(lonMin, srcImageBoundary.latMin, lonMax, srcImageBoundary.latMax);
        ReferencedEnvelope boundsEnvelope = new ReferencedEnvelope((Rectangle2D)bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope targetEnvelope = boundsEnvelope.transform(this.targetCRS, true, 200);
        double easting = targetEnvelope.getMinimum(0);
        double northing = targetEnvelope.getMaximum(1);
        if (alignToStandardGrid) {
            easting = Math.floor((easting - standardGridOriginX) / pixelSizeX) * pixelSizeX + standardGridOriginX;
            northing = Math.ceil((northing - standardGridOriginY) / pixelSizeY) * pixelSizeY + standardGridOriginY;
            this.targetWidth = (int)Math.ceil((targetEnvelope.getMaximum(0) - easting) / pixelSizeX);
            this.targetHeight = (int)Math.ceil((northing - targetEnvelope.getMinimum(1)) / pixelSizeY);
        } else {
            this.targetWidth = (int)Math.floor(targetEnvelope.getWidth() / pixelSizeX);
            this.targetHeight = (int)Math.floor(targetEnvelope.getHeight() / pixelSizeY);
        }
        this.geoCoding = new CrsGeoCoding(this.targetCRS, this.targetWidth, this.targetHeight, easting, northing, pixelSizeX, pixelSizeY);
    }

    public CRSGeoCodingHandler(GeoPos geoPosUL, GeoPos geoPosUR, GeoPos geoPosLL, GeoPos geoPosLR, GeoPos geoPosCT, String mapProjection, double pixelSpacingInDegree, double pixelSpacingInMeter) throws Exception {
        boolean alignToStandardGrid = false;
        double standardGridOriginX = 0.0;
        double standardGridOriginY = 0.0;
        this.targetCRS = CRSGeoCodingHandler.getCRS(geoPosCT, mapProjection);
        OperatorUtils.ImageGeoBoundary srcImageBoundary = this.getGeoBoundary(geoPosUL, geoPosUR, geoPosLL, geoPosLR);
        double pixelSizeX = pixelSpacingInMeter;
        double pixelSizeY = pixelSpacingInMeter;
        if (this.targetCRS.getName().getCode().equals("WGS84(DD)") || this.targetCRS.getCoordinateSystem().getAxis(0).getUnit().equals((Object)NonSI.DEGREE_ANGLE)) {
            pixelSizeX = pixelSpacingInDegree;
            pixelSizeY = pixelSpacingInDegree;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        double lonMin = srcImageBoundary.lonMin;
        double lonMax = srcImageBoundary.lonMax;
        bounds.setFrameFromDiagonal(lonMin, srcImageBoundary.latMin, lonMax, srcImageBoundary.latMax);
        ReferencedEnvelope boundsEnvelope = new ReferencedEnvelope((Rectangle2D)bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope targetEnvelope = boundsEnvelope.transform(this.targetCRS, true, 200);
        double easting = targetEnvelope.getMinimum(0);
        double northing = targetEnvelope.getMaximum(1);
        this.targetWidth = (int)Math.floor(targetEnvelope.getWidth() / pixelSizeX);
        this.targetHeight = (int)Math.floor(targetEnvelope.getHeight() / pixelSizeY);
        this.geoCoding = new CrsGeoCoding(this.targetCRS, this.targetWidth, this.targetHeight, easting, northing, pixelSizeX, pixelSizeY);
    }

    public static CoordinateReferenceSystem getCRS(Product sourceProduct, String crs) throws Exception {
        try {
            if (crs == null || crs.isEmpty() || crs.equals("WGS84(DD)")) {
                return DefaultGeographicCRS.WGS84;
            }
            return CRS.parseWKT((String)crs);
        }
        catch (Exception e) {
            if (crs.matches("[0-9]*")) {
                crs = "EPSG:" + crs;
            }
            if (crs.matches("AUTO:[0-9]*")) {
                GeoPos centerGeoPos = ProductUtils.getCenterGeoPos((Product)sourceProduct);
                crs = String.format("%s,%s,%s", crs, centerGeoPos.lon, centerGeoPos.lat);
            }
            return CRS.decode((String)crs, (boolean)true);
        }
    }

    public static CoordinateReferenceSystem getCRS(GeoPos centerGeoPos, String crs) throws Exception {
        try {
            if (crs == null || crs.isEmpty() || crs.equals("WGS84(DD)")) {
                return DefaultGeographicCRS.WGS84;
            }
            return CRS.parseWKT((String)crs);
        }
        catch (Exception e) {
            if (crs.matches("[0-9]*")) {
                crs = "EPSG:" + crs;
            }
            if (crs.matches("AUTO:[0-9]*")) {
                crs = String.format("%s,%s,%s", crs, centerGeoPos.lon, centerGeoPos.lat);
            }
            return CRS.decode((String)crs, (boolean)true);
        }
    }

    private OperatorUtils.ImageGeoBoundary getGeoBoundary(GeoPos geoPosUL, GeoPos geoPosUR, GeoPos geoPosLL, GeoPos geoPosLR) {
        OperatorUtils.ImageGeoBoundary geoBoundary = new OperatorUtils.ImageGeoBoundary();
        double[] lats = new double[]{geoPosUL.getLat(), geoPosUR.getLat(), geoPosLL.getLat(), geoPosLR.getLat()};
        double[] lons = new double[]{geoPosUL.getLon(), geoPosUR.getLon(), geoPosLL.getLon(), geoPosLR.getLon()};
        geoBoundary.latMin = 90.0;
        geoBoundary.latMax = -90.0;
        for (double lat : lats) {
            if (lat < geoBoundary.latMin) {
                geoBoundary.latMin = lat;
            }
            if (!(lat > geoBoundary.latMax)) continue;
            geoBoundary.latMax = lat;
        }
        geoBoundary.lonMin = 180.0;
        geoBoundary.lonMax = -180.0;
        for (double lon : lons) {
            if (lon < geoBoundary.lonMin) {
                geoBoundary.lonMin = lon;
            }
            if (!(lon > geoBoundary.lonMax)) continue;
            geoBoundary.lonMax = lon;
        }
        if (geoBoundary.lonMax - geoBoundary.lonMin >= 180.0) {
            geoBoundary.lonMin = 360.0;
            geoBoundary.lonMax = 0.0;
            for (double lon : lons) {
                if (lon < 0.0) {
                    lon += 360.0;
                }
                if (lon < geoBoundary.lonMin) {
                    geoBoundary.lonMin = lon;
                }
                if (!(lon > geoBoundary.lonMax)) continue;
                geoBoundary.lonMax = lon;
            }
        }
        return geoBoundary;
    }

    public int getTargetWidth() {
        return this.targetWidth;
    }

    public int getTargetHeight() {
        return this.targetHeight;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public CrsGeoCoding getCrsGeoCoding() {
        return this.geoCoding;
    }
}

