/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.specklefilters.covariance;

import org.csa.rstb.polarimetric.gpf.DualPolProcessor;
import org.csa.rstb.polarimetric.gpf.QuadPolProcessor;
import org.csa.rstb.polarimetric.gpf.specklefilters.covariance.Covariance;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorException;

public class CovarianceMatrix {
    private double Cr00;
    private double Cr01;
    private double Cr02;
    private double Cr11;
    private double Cr12;
    private double Cr22;
    private double Ci01;
    private double Ci02;
    private double Ci12;
    private int d;
    private double det;

    public CovarianceMatrix(int matrixSize) {
        this.d = matrixSize;
        this.det = -1.0;
        if (this.d == 2) {
            this.Cr00 = 0.0;
            this.Cr01 = 0.0;
            this.Cr11 = 0.0;
            this.Ci01 = 0.0;
        } else if (this.d == 3) {
            this.Cr00 = 0.0;
            this.Cr01 = 0.0;
            this.Cr02 = 0.0;
            this.Cr11 = 0.0;
            this.Cr12 = 0.0;
            this.Cr22 = 0.0;
            this.Ci01 = 0.0;
            this.Ci02 = 0.0;
            this.Ci12 = 0.0;
        }
    }

    public void setCovarianceMatrix(double[][] Cr, double[][] Ci) {
        if (Cr.length != this.d || Cr[0].length != this.d || Ci.length != this.d || Ci[0].length != this.d) {
            throw new OperatorException("CovarianceMatrix: invalid input matrix dimension");
        }
        if (this.d == 2) {
            this.Cr00 = Cr[0][0];
            this.Cr01 = Cr[0][1];
            this.Cr11 = Cr[1][1];
            this.Ci01 = Ci[0][1];
        } else if (this.d == 3) {
            this.Cr00 = Cr[0][0];
            this.Cr01 = Cr[0][1];
            this.Cr02 = Cr[0][2];
            this.Cr11 = Cr[1][1];
            this.Cr12 = Cr[1][2];
            this.Cr22 = Cr[2][2];
            this.Ci01 = Ci[0][1];
            this.Ci02 = Ci[0][2];
            this.Ci12 = Ci[1][2];
        }
        this.det = -1.0;
    }

    public double[][] getRealCovarianceMatrix() {
        double[][] Cr = new double[this.d][this.d];
        if (this.d == 2) {
            Cr[0][0] = this.Cr00;
            Cr[0][1] = this.Cr01;
            Cr[1][0] = this.Cr01;
            Cr[1][1] = this.Cr11;
        } else if (this.d == 3) {
            Cr[0][0] = this.Cr00;
            Cr[0][1] = this.Cr01;
            Cr[0][2] = this.Cr02;
            Cr[1][0] = this.Cr01;
            Cr[1][1] = this.Cr11;
            Cr[1][2] = this.Cr12;
            Cr[2][0] = this.Cr02;
            Cr[2][1] = this.Cr12;
            Cr[2][2] = this.Cr22;
        }
        return Cr;
    }

    public double[][] getImagCovarianceMatrix() {
        double[][] Ci = new double[this.d][this.d];
        if (this.d == 2) {
            Ci[0][0] = 0.0;
            Ci[0][1] = this.Ci01;
            Ci[1][0] = -this.Ci01;
            Ci[1][1] = 0.0;
        } else if (this.d == 3) {
            Ci[0][0] = 0.0;
            Ci[0][1] = this.Ci01;
            Ci[0][2] = this.Ci02;
            Ci[1][0] = -this.Ci01;
            Ci[1][1] = 0.0;
            Ci[1][2] = this.Ci12;
            Ci[2][0] = -this.Ci02;
            Ci[2][1] = -this.Ci12;
            Ci[2][2] = 0.0;
        }
        return Ci;
    }

    public void addCovarianceMatrix(double[][] Cr, double[][] Ci) {
        if (Cr.length != this.d || Cr[0].length != this.d || Ci.length != this.d || Ci[0].length != this.d) {
            throw new OperatorException("CovarianceMatrix: invalid input matrix dimension");
        }
        if (this.d == 2) {
            this.Cr00 += Cr[0][0];
            this.Cr01 += Cr[0][1];
            this.Cr11 += Cr[1][1];
            this.Ci01 += Ci[0][1];
        } else if (this.d == 3) {
            this.Cr00 += Cr[0][0];
            this.Cr01 += Cr[0][1];
            this.Cr02 += Cr[0][2];
            this.Cr11 += Cr[1][1];
            this.Cr12 += Cr[1][2];
            this.Cr22 += Cr[2][2];
            this.Ci01 += Ci[0][1];
            this.Ci02 += Ci[0][2];
            this.Ci12 += Ci[1][2];
        }
        this.det = -1.0;
    }

    public void addWeightedCovarianceMatrix(double w, double[][] Cr, double[][] Ci) {
        if (Cr.length != this.d || Cr[0].length != this.d || Ci.length != this.d || Ci[0].length != this.d) {
            throw new OperatorException("CovarianceMatrix: invalid input matrix dimension");
        }
        if (this.d == 2) {
            this.Cr00 += w * Cr[0][0];
            this.Cr01 += w * Cr[0][1];
            this.Cr11 += w * Cr[1][1];
            this.Ci01 += w * Ci[0][1];
        } else if (this.d == 3) {
            this.Cr00 += w * Cr[0][0];
            this.Cr01 += w * Cr[0][1];
            this.Cr02 += w * Cr[0][2];
            this.Cr11 += w * Cr[1][1];
            this.Cr12 += w * Cr[1][2];
            this.Cr22 += w * Cr[2][2];
            this.Ci01 += w * Ci[0][1];
            this.Ci02 += w * Ci[0][2];
            this.Ci12 += w * Ci[1][2];
        }
        this.det = -1.0;
    }

    public void rescaleMatrix(double gamma) {
        if (this.d == 2) {
            this.Cr01 *= gamma;
            this.Ci01 *= gamma;
        } else if (this.d == 3) {
            this.Cr01 *= gamma;
            this.Cr02 *= gamma;
            this.Cr12 *= gamma;
            this.Ci01 *= gamma;
            this.Ci02 *= gamma;
            this.Ci12 *= gamma;
        }
        this.det = -1.0;
    }

    public double getDeterminant() {
        if (this.det != -1.0) {
            return this.det;
        }
        if (this.d == 2) {
            this.det = Math.abs(this.Cr00 * this.Cr11 - this.Cr01 * this.Cr01 - this.Ci01 * this.Ci01);
        } else if (this.d == 3) {
            this.det = Math.abs(this.Cr00 * this.Cr11 * this.Cr22 - this.Cr00 * (this.Cr12 * this.Cr12 + this.Ci12 * this.Ci12) - this.Cr11 * (this.Cr02 * this.Cr02 + this.Ci02 * this.Ci02) - this.Cr22 * (this.Cr01 * this.Cr01 + this.Ci01 * this.Ci01) + 2.0 * (this.Cr12 * (this.Cr01 * this.Cr02 + this.Ci01 * this.Ci02) + this.Ci12 * (this.Cr01 * this.Ci02 - this.Ci01 * this.Cr02)));
        }
        return this.det;
    }

    public double[] getDiagonalElements() {
        double[] diagonal = new double[this.d];
        if (this.d == 2) {
            diagonal[0] = this.Cr00;
            diagonal[1] = this.Cr11;
        } else if (this.d == 3) {
            diagonal[0] = this.Cr00;
            diagonal[1] = this.Cr11;
            diagonal[2] = this.Cr22;
        }
        return diagonal;
    }

    public static class C3
    implements Covariance,
    QuadPolProcessor {
        private final int matrixSize = 3;
        private double det;
        public final double[][] Cr = new double[3][3];
        public final double[][] Ci = new double[3][3];

        @Override
        public void getCovarianceMatrix(int index, ProductData[] dataBuffers) {
            this.getCovarianceMatrixC3(index, dataBuffers, this.Cr, this.Ci);
            this.det = -1.0;
        }

        @Override
        public C3 clone() {
            C3 clone = new C3();
            clone.Cr[0][0] = this.Cr[0][0];
            clone.Ci[0][0] = this.Ci[0][0];
            clone.Cr[0][1] = this.Cr[0][1];
            clone.Ci[0][1] = this.Ci[0][1];
            clone.Cr[0][2] = this.Cr[0][2];
            clone.Ci[0][2] = this.Ci[0][2];
            clone.Cr[1][0] = this.Cr[1][0];
            clone.Ci[1][0] = this.Ci[1][0];
            clone.Cr[1][1] = this.Cr[1][1];
            clone.Ci[1][1] = this.Ci[1][1];
            clone.Cr[1][2] = this.Cr[1][2];
            clone.Ci[1][2] = this.Ci[1][2];
            clone.Cr[2][0] = this.Cr[2][0];
            clone.Ci[2][0] = this.Ci[2][0];
            clone.Cr[2][1] = this.Cr[2][1];
            clone.Ci[2][1] = this.Ci[2][1];
            clone.Cr[2][2] = this.Cr[2][2];
            clone.Ci[2][2] = this.Ci[2][2];
            return clone;
        }

        @Override
        public void rescaleMatrix(double gamma) {
            double[] dArray = this.Cr[0];
            dArray[1] = dArray[1] * gamma;
            double[] dArray2 = this.Ci[0];
            dArray2[1] = dArray2[1] * gamma;
            double[] dArray3 = this.Cr[0];
            dArray3[2] = dArray3[2] * gamma;
            double[] dArray4 = this.Ci[0];
            dArray4[2] = dArray4[2] * gamma;
            double[] dArray5 = this.Cr[1];
            dArray5[2] = dArray5[2] * gamma;
            double[] dArray6 = this.Ci[1];
            dArray6[2] = dArray6[2] * gamma;
            this.det = -1.0;
        }

        @Override
        public void addCovarianceMatrix(Covariance matrix) {
            C3 c3 = (C3)matrix;
            double[] dArray = this.Cr[0];
            dArray[0] = dArray[0] + c3.Cr[0][0];
            double[] dArray2 = this.Cr[0];
            dArray2[1] = dArray2[1] + c3.Cr[0][1];
            double[] dArray3 = this.Cr[0];
            dArray3[2] = dArray3[2] + c3.Cr[0][2];
            double[] dArray4 = this.Cr[1];
            dArray4[1] = dArray4[1] + c3.Cr[1][1];
            double[] dArray5 = this.Cr[1];
            dArray5[2] = dArray5[2] + c3.Cr[1][2];
            double[] dArray6 = this.Cr[2];
            dArray6[2] = dArray6[2] + c3.Cr[2][2];
            double[] dArray7 = this.Ci[0];
            dArray7[1] = dArray7[1] + c3.Ci[0][1];
            double[] dArray8 = this.Ci[0];
            dArray8[2] = dArray8[2] + c3.Ci[0][2];
            double[] dArray9 = this.Ci[1];
            dArray9[2] = dArray9[2] + c3.Ci[1][2];
            this.det = -1.0;
        }

        @Override
        public void addWeightedCovarianceMatrix(double w, Covariance matrix) {
            C3 c3 = (C3)matrix;
            double[] dArray = this.Cr[0];
            dArray[0] = dArray[0] + w * c3.Cr[0][0];
            double[] dArray2 = this.Cr[0];
            dArray2[1] = dArray2[1] + w * c3.Cr[0][1];
            double[] dArray3 = this.Cr[0];
            dArray3[2] = dArray3[2] + w * c3.Cr[0][2];
            double[] dArray4 = this.Cr[1];
            dArray4[1] = dArray4[1] + w * c3.Cr[1][1];
            double[] dArray5 = this.Cr[1];
            dArray5[2] = dArray5[2] + w * c3.Cr[1][2];
            double[] dArray6 = this.Cr[2];
            dArray6[2] = dArray6[2] + w * c3.Cr[2][2];
            double[] dArray7 = this.Ci[0];
            dArray7[1] = dArray7[1] + w * c3.Ci[0][1];
            double[] dArray8 = this.Ci[0];
            dArray8[2] = dArray8[2] + w * c3.Ci[0][2];
            double[] dArray9 = this.Ci[1];
            dArray9[2] = dArray9[2] + w * c3.Ci[1][2];
            this.det = -1.0;
        }

        @Override
        public double[][] getRealCovarianceMatrix() {
            return this.Cr;
        }

        @Override
        public double[][] getImagCovarianceMatrix() {
            return this.Ci;
        }

        @Override
        public double[] getDiagonalElements() {
            double[] diagonal = new double[]{this.Cr[0][0], this.Cr[1][1], this.Cr[2][2]};
            return diagonal;
        }

        @Override
        public double getDeterminant() {
            if (this.det != -1.0) {
                return this.det;
            }
            this.det = Math.abs(this.Cr[0][0] * this.Cr[1][1] * this.Cr[2][2] - this.Cr[0][0] * (this.Cr[1][2] * this.Cr[1][2] + this.Ci[1][2] * this.Ci[1][2]) - this.Cr[1][1] * (this.Cr[0][2] * this.Cr[0][2] + this.Ci[0][2] * this.Ci[0][2]) - this.Cr[2][2] * (this.Cr[0][1] * this.Cr[0][1] + this.Ci[0][1] * this.Ci[0][1]) + 2.0 * (this.Cr[1][2] * (this.Cr[0][1] * this.Cr[0][2] + this.Ci[0][1] * this.Ci[0][2]) + this.Ci[1][2] * (this.Cr[0][1] * this.Ci[0][2] - this.Ci[0][1] * this.Cr[0][2])));
            return this.det;
        }
    }

    public static class C2
    implements Covariance,
    DualPolProcessor {
        private final int matrixSize = 2;
        private double det;
        public final double[][] Cr = new double[2][2];
        public final double[][] Ci = new double[2][2];

        @Override
        public void getCovarianceMatrix(int index, ProductData[] dataBuffers) {
            this.getCovarianceMatrixC2(index, dataBuffers, this.Cr, this.Ci);
            this.det = -1.0;
        }

        @Override
        public C2 clone() {
            C2 clone = new C2();
            clone.Cr[0][0] = this.Cr[0][0];
            clone.Ci[0][0] = this.Ci[0][0];
            clone.Cr[0][1] = this.Cr[0][1];
            clone.Ci[0][1] = this.Ci[0][1];
            clone.Cr[1][0] = this.Cr[1][0];
            clone.Ci[1][0] = this.Ci[1][0];
            clone.Cr[1][1] = this.Cr[1][1];
            clone.Ci[1][1] = this.Ci[1][1];
            return clone;
        }

        @Override
        public void rescaleMatrix(double gamma) {
            double[] dArray = this.Cr[0];
            dArray[1] = dArray[1] * gamma;
            double[] dArray2 = this.Ci[0];
            dArray2[1] = dArray2[1] * gamma;
            this.det = -1.0;
        }

        @Override
        public void addCovarianceMatrix(Covariance matrix) {
            C2 c2 = (C2)matrix;
            double[] dArray = this.Cr[0];
            dArray[0] = dArray[0] + c2.Cr[0][0];
            double[] dArray2 = this.Cr[0];
            dArray2[1] = dArray2[1] + c2.Cr[0][1];
            double[] dArray3 = this.Cr[1];
            dArray3[1] = dArray3[1] + c2.Cr[1][1];
            double[] dArray4 = this.Ci[0];
            dArray4[1] = dArray4[1] + c2.Ci[0][1];
            this.det = -1.0;
        }

        @Override
        public void addWeightedCovarianceMatrix(double w, Covariance matrix) {
            C2 c2 = (C2)matrix;
            double[] dArray = this.Cr[0];
            dArray[0] = dArray[0] + w * c2.Cr[0][0];
            double[] dArray2 = this.Cr[0];
            dArray2[1] = dArray2[1] + w * c2.Cr[0][1];
            double[] dArray3 = this.Cr[1];
            dArray3[1] = dArray3[1] + w * c2.Cr[1][1];
            double[] dArray4 = this.Ci[0];
            dArray4[1] = dArray4[1] + w * c2.Ci[0][1];
            this.det = -1.0;
        }

        @Override
        public double[][] getRealCovarianceMatrix() {
            return this.Cr;
        }

        @Override
        public double[][] getImagCovarianceMatrix() {
            return this.Ci;
        }

        @Override
        public double[] getDiagonalElements() {
            double[] diagonal = new double[]{this.Cr[0][0], this.Cr[1][1]};
            return diagonal;
        }

        @Override
        public double getDeterminant() {
            if (this.det != -1.0) {
                return this.det;
            }
            this.det = Math.abs(this.Cr[0][0] * this.Cr[1][1] - this.Cr[0][1] * this.Cr[0][1] - this.Ci[0][1] * this.Ci[0][1]);
            return this.det;
        }
    }
}

