/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.specklefilters;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.DualPolProcessor;
import org.csa.rstb.polarimetric.gpf.QuadPolProcessor;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public interface SpeckleFilter
extends DualPolProcessor,
QuadPolProcessor {
    public void computeTiles(Map<Band, Tile> var1, Rectangle var2, Rectangle var3);

    default public double getMeanValue(double[] neighborValues) {
        double mean = 0.0;
        for (double neighborValue : neighborValues) {
            mean += neighborValue;
        }
        return mean /= (double)neighborValues.length;
    }

    default public double getVarianceValue(double[] neighborValues, double mean) {
        double var = 0.0;
        if (neighborValues.length > 1) {
            for (double neighborValue : neighborValues) {
                double diff = neighborValue - mean;
                var += diff * diff;
            }
            var /= (double)(neighborValues.length - 1);
        }
        return var;
    }

    default public double computeMMSEWeight(double[] dataArray, double sigmaVSqr) {
        double meanY = this.getMeanValue(dataArray);
        double varY = this.getVarianceValue(dataArray, meanY);
        if (varY == 0.0) {
            return 0.0;
        }
        double varX = (varY - meanY * meanY * sigmaVSqr) / (1.0 + sigmaVSqr);
        if (varX < 0.0) {
            varX = 0.0;
        }
        return varX / varY;
    }

    default public void createC2SpanImage(Tile srcTile, PolBandUtils.MATRIX sourceProductType, Rectangle sourceRectangle, ProductData[] dataBuffers, double[][] data11Real, double[][] data12Real, double[][] data12Imag, double[][] data22Real, double[][] span) {
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        TileIndex srcIndex = new TileIndex(srcTile);
        double[][] Cr = new double[2][2];
        double[][] Ci = new double[2][2];
        if (sourceProductType == PolBandUtils.MATRIX.LCHCP || sourceProductType == PolBandUtils.MATRIX.RCHCP || sourceProductType == PolBandUtils.MATRIX.DUAL_HH_HV || sourceProductType == PolBandUtils.MATRIX.DUAL_VH_VV || sourceProductType == PolBandUtils.MATRIX.DUAL_HH_VV) {
            double[] Kr = new double[2];
            double[] Ki = new double[2];
            for (int y = sy0; y < maxY; ++y) {
                int j = y - sy0;
                srcIndex.calculateStride(y);
                for (int x = sx0; x < maxX; ++x) {
                    int i = x - sx0;
                    int index = srcIndex.getIndex(x);
                    this.getScatterVector(index, dataBuffers, Kr, Ki);
                    this.computeCovarianceMatrixC2(Kr, Ki, Cr, Ci);
                    data11Real[j][i] = Cr[0][0];
                    data12Real[j][i] = Cr[0][1];
                    data12Imag[j][i] = Ci[0][1];
                    data22Real[j][i] = Cr[1][1];
                    span[j][i] = (Cr[0][0] + Cr[1][1]) / 2.0;
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.C2) {
            for (int y = sy0; y < maxY; ++y) {
                int j = y - sy0;
                srcIndex.calculateStride(y);
                for (int x = sx0; x < maxX; ++x) {
                    int i = x - sx0;
                    int index = srcIndex.getIndex(x);
                    this.getCovarianceMatrixC2(index, dataBuffers, Cr, Ci);
                    data11Real[j][i] = Cr[0][0];
                    data12Real[j][i] = Cr[0][1];
                    data12Imag[j][i] = Ci[0][1];
                    data22Real[j][i] = Cr[1][1];
                    span[j][i] = (Cr[0][0] + Cr[1][1]) / 2.0;
                }
            }
        } else {
            throw new OperatorException("Cp or dual pol product is expected.");
        }
    }

    default public void createT3SpanImage(Tile srcTile, PolBandUtils.MATRIX sourceProductType, Rectangle sourceRectangle, ProductData[] dataBuffers, double[][] data11Real, double[][] data12Real, double[][] data12Imag, double[][] data13Real, double[][] data13Imag, double[][] data22Real, double[][] data23Real, double[][] data23Imag, double[][] data33Real, double[][] span) {
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        TileIndex srcIndex = new TileIndex(srcTile);
        double[][] Mr = new double[3][3];
        double[][] Mi = new double[3][3];
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] Sr = new double[2][2];
            double[][] Si = new double[2][2];
            for (int y = sy0; y < maxY; ++y) {
                int j = y - sy0;
                srcIndex.calculateStride(y);
                for (int x = sx0; x < maxX; ++x) {
                    int i = x - sx0;
                    int index = srcIndex.getIndex(x);
                    this.getComplexScatterMatrix(index, dataBuffers, Sr, Si);
                    this.computeCoherencyMatrixT3(Sr, Si, Mr, Mi);
                    data11Real[j][i] = Mr[0][0];
                    data12Real[j][i] = Mr[0][1];
                    data12Imag[j][i] = Mi[0][1];
                    data13Real[j][i] = Mr[0][2];
                    data13Imag[j][i] = Mi[0][2];
                    data22Real[j][i] = Mr[1][1];
                    data23Real[j][i] = Mr[1][2];
                    data23Imag[j][i] = Mi[1][2];
                    data33Real[j][i] = Mr[2][2];
                    span[j][i] = (Mr[0][0] + Mr[1][1] + Mr[2][2]) / 4.0;
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.T3) {
            for (int y = sy0; y < maxY; ++y) {
                int j = y - sy0;
                srcIndex.calculateStride(y);
                for (int x = sx0; x < maxX; ++x) {
                    int i = x - sx0;
                    int index = srcIndex.getIndex(x);
                    this.getCoherencyMatrixT3(index, dataBuffers, Mr, Mi);
                    data11Real[j][i] = Mr[0][0];
                    data12Real[j][i] = Mr[0][1];
                    data12Imag[j][i] = Mi[0][1];
                    data13Real[j][i] = Mr[0][2];
                    data13Imag[j][i] = Mi[0][2];
                    data22Real[j][i] = Mr[1][1];
                    data23Real[j][i] = Mr[1][2];
                    data23Imag[j][i] = Mi[1][2];
                    data33Real[j][i] = Mr[2][2];
                    span[j][i] = (Mr[0][0] + Mr[1][1] + Mr[2][2]) / 4.0;
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.C3) {
            for (int y = sy0; y < maxY; ++y) {
                int j = y - sy0;
                srcIndex.calculateStride(y);
                for (int x = sx0; x < maxX; ++x) {
                    int i = x - sx0;
                    int index = srcIndex.getIndex(x);
                    this.getCovarianceMatrixC3(index, dataBuffers, Mr, Mi);
                    data11Real[j][i] = Mr[0][0];
                    data12Real[j][i] = Mr[0][1];
                    data12Imag[j][i] = Mi[0][1];
                    data13Real[j][i] = Mr[0][2];
                    data13Imag[j][i] = Mi[0][2];
                    data22Real[j][i] = Mr[1][1];
                    data23Real[j][i] = Mr[1][2];
                    data23Imag[j][i] = Mi[1][2];
                    data33Real[j][i] = Mr[2][2];
                    span[j][i] = (Mr[0][0] + Mr[1][1] + Mr[2][2]) / 4.0;
                }
            }
        } else {
            throw new OperatorException("Polarimetric Matrix not supported");
        }
    }

    public static enum T3Elem {
        T11,
        T12_real,
        T12_imag,
        T13_real,
        T13_imag,
        T22,
        T23_real,
        T23_imag,
        T33;

    }
}

