/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.specklefilters;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.DualPolProcessor;
import org.csa.rstb.polarimetric.gpf.PolarimetricSpeckleFilterOp;
import org.csa.rstb.polarimetric.gpf.QuadPolProcessor;
import org.csa.rstb.polarimetric.gpf.specklefilters.SpeckleFilter;
import org.csa.rstb.polarimetric.gpf.specklefilters.covariance.Covariance;
import org.csa.rstb.polarimetric.gpf.specklefilters.covariance.CovarianceMatrix;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class NonLocal
implements SpeckleFilter,
DualPolProcessor,
QuadPolProcessor {
    private final PolarimetricSpeckleFilterOp operator;
    private final Product sourceProduct;
    private final Product targetProduct;
    private final PolBandUtils.PolSourceBand[] srcBandList;
    private final int numLooks;
    private final int windowSize;
    private final int halfWindowSize;
    private final int patchSize;
    private final int halfPatchSize;
    private final int scaleSize;
    private final int sourceImageWidth;
    private final int sourceImageHeight;
    private final int matrixSize;
    private final double gamma;
    private final double matrixSizeTwoLog2;
    private static final double TwoLog2 = 1.3862943611198906;

    public NonLocal(PolarimetricSpeckleFilterOp op, Product srcProduct, Product trgProduct, PolBandUtils.MATRIX sourceProductType, PolBandUtils.PolSourceBand[] srcBandList, int numLooks, int searchWindowSize, int patchSize, int scaleSize) {
        this.operator = op;
        this.sourceProduct = srcProduct;
        this.targetProduct = trgProduct;
        this.srcBandList = srcBandList;
        this.numLooks = numLooks;
        this.windowSize = searchWindowSize;
        this.halfWindowSize = searchWindowSize / 2;
        this.patchSize = patchSize;
        this.halfPatchSize = patchSize / 2;
        this.scaleSize = scaleSize;
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        if (patchSize >= this.windowSize) {
            throw new OperatorException("Patch size should always be smaller than the search window size");
        }
        if (this.windowSize >= this.sourceImageWidth || this.windowSize >= this.sourceImageHeight) {
            throw new OperatorException("Image is too small. Please select larger image");
        }
        if (sourceProductType == PolBandUtils.MATRIX.C3) {
            this.matrixSize = 3;
        } else if (sourceProductType == PolBandUtils.MATRIX.C2) {
            this.matrixSize = 2;
        } else {
            throw new OperatorException("Expecting a C2 or C3 matrix");
        }
        if (numLooks >= this.matrixSize) {
            throw new OperatorException("Number of looks should always be smaller than the covariance matrix size");
        }
        this.gamma = Math.min((double)numLooks / (double)this.matrixSize, 1.0);
        this.matrixSizeTwoLog2 = (double)this.matrixSize * 1.3862943611198906;
    }

    @Override
    public void computeTiles(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int sxMax = sx0 + sw;
        int syMax = sy0 + sh;
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            double enlNLRB;
            Covariance sigmaNLBR;
            double enlNL;
            Covariance sigmaNL;
            double totalWeight;
            double[][] weight;
            int x;
            int y;
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            ProductData[] targetDataBuffers = this.getTargetDataBuffers(bandList, targetTiles);
            Covariance[][] originalMatrix = new Covariance[sh][sw];
            this.getOriginalCovarianceMatrix(sx0, sy0, sxMax, syMax, sourceTiles, dataBuffers, originalMatrix);
            Covariance[][] preEstimatedMatrix = new Covariance[sh][sw];
            this.computePreEstimatedCovarianceMatrix(sx0, sy0, sxMax, syMax, originalMatrix, preEstimatedMatrix);
            System.out.println("x0 = " + x0 + ", y0 = " + y0 + ", computeWeightedEstimate start");
            if (this.matrixSize == 3) {
                for (y = y0; y < yMax; ++y) {
                    trgIndex.calculateStride(y);
                    System.out.println(y + " of " + yMax);
                    for (x = x0; x < xMax; ++x) {
                        weight = this.computeWeights(x, y, sx0, sy0, preEstimatedMatrix);
                        totalWeight = NonLocal.getTotalWeight(weight);
                        sigmaNL = this.computeWeightedEstimate(x, y, sx0, sy0, weight, totalWeight, originalMatrix);
                        enlNL = this.computeENL(weight, totalWeight);
                        sigmaNLBR = this.matrixSize == 3 ? new CovarianceMatrix.C3() : new CovarianceMatrix.C2();
                        enlNLRB = this.performBiasReduction(x, y, sx0, sy0, weight, totalWeight, enlNL, originalMatrix, sigmaNL, sigmaNLBR);
                        NonLocal.saveC3(sigmaNLBR, trgIndex.getIndex(x), targetDataBuffers);
                    }
                }
            } else if (this.matrixSize == 2) {
                for (y = y0; y < yMax; ++y) {
                    trgIndex.calculateStride(y);
                    for (x = x0; x < xMax; ++x) {
                        weight = this.computeWeights(x, y, sx0, sy0, preEstimatedMatrix);
                        totalWeight = NonLocal.getTotalWeight(weight);
                        sigmaNL = this.computeWeightedEstimate(x, y, sx0, sy0, weight, totalWeight, originalMatrix);
                        enlNL = this.computeENL(weight, totalWeight);
                        sigmaNLBR = this.matrixSize == 3 ? new CovarianceMatrix.C3() : new CovarianceMatrix.C2();
                        enlNLRB = this.performBiasReduction(x, y, sx0, sy0, weight, totalWeight, enlNL, originalMatrix, sigmaNL, sigmaNLBR);
                        NonLocal.saveC2(sigmaNLBR, trgIndex.getIndex(x), targetDataBuffers);
                    }
                }
            }
            System.out.println("x0 = " + x0 + ", y0 = " + y0 + ", computeWeightedEstimate finished");
        }
    }

    private ProductData[] getTargetDataBuffers(PolBandUtils.PolSourceBand bandList, Map<Band, Tile> targetTiles) {
        if (this.matrixSize == 3) {
            ProductData[] targetDataBuffers = new ProductData[9];
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"11")) {
                    targetDataBuffers[0] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_real")) {
                    targetDataBuffers[1] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_imag")) {
                    targetDataBuffers[2] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_real")) {
                    targetDataBuffers[3] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_imag")) {
                    targetDataBuffers[4] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"22")) {
                    targetDataBuffers[5] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_real")) {
                    targetDataBuffers[6] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_imag")) {
                    targetDataBuffers[7] = dataBuffer;
                    continue;
                }
                if (!PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"33")) continue;
                targetDataBuffers[8] = dataBuffer;
            }
            return targetDataBuffers;
        }
        if (this.matrixSize == 2) {
            ProductData[] targetDataBuffers = new ProductData[4];
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"11")) {
                    targetDataBuffers[0] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_real")) {
                    targetDataBuffers[1] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_imag")) {
                    targetDataBuffers[2] = dataBuffer;
                    continue;
                }
                if (!PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"22")) continue;
                targetDataBuffers[3] = dataBuffer;
            }
            return targetDataBuffers;
        }
        return null;
    }

    private static void saveC3(Covariance sigmaNLRB, int idx, ProductData[] targetDataBuffers) {
        double[][] Cr = sigmaNLRB.getRealCovarianceMatrix();
        double[][] Ci = sigmaNLRB.getImagCovarianceMatrix();
        targetDataBuffers[0].setElemFloatAt(idx, (float)Cr[0][0]);
        targetDataBuffers[1].setElemFloatAt(idx, (float)Cr[0][1]);
        targetDataBuffers[2].setElemFloatAt(idx, (float)Ci[0][1]);
        targetDataBuffers[3].setElemFloatAt(idx, (float)Cr[0][2]);
        targetDataBuffers[4].setElemFloatAt(idx, (float)Ci[0][2]);
        targetDataBuffers[5].setElemFloatAt(idx, (float)Cr[1][1]);
        targetDataBuffers[6].setElemFloatAt(idx, (float)Cr[1][2]);
        targetDataBuffers[7].setElemFloatAt(idx, (float)Ci[1][2]);
        targetDataBuffers[8].setElemFloatAt(idx, (float)Cr[2][2]);
    }

    private static void saveC2(Covariance sigmaNLRB, int idx, ProductData[] targetDataBuffers) {
        double[][] Cr = sigmaNLRB.getRealCovarianceMatrix();
        double[][] Ci = sigmaNLRB.getImagCovarianceMatrix();
        targetDataBuffers[0].setElemFloatAt(idx, (float)Cr[0][0]);
        targetDataBuffers[1].setElemFloatAt(idx, (float)Cr[0][1]);
        targetDataBuffers[2].setElemFloatAt(idx, (float)Ci[0][1]);
        targetDataBuffers[3].setElemFloatAt(idx, (float)Cr[1][1]);
    }

    private void computePreEstimatedCovarianceMatrix(int sx0, int sy0, int sxMax, int syMax, Covariance[][] originalMatrix, Covariance[][] preEstimatedMatrix) {
        if (this.scaleSize > 0) {
            this.performGaussianFiltering(sx0, sy0, sxMax, syMax, originalMatrix, preEstimatedMatrix);
        } else {
            this.copyOriginalMatrix(sx0, sy0, sxMax, syMax, originalMatrix, preEstimatedMatrix);
        }
        this.rescaleCovarianceMatrix(sx0, sy0, sxMax, syMax, preEstimatedMatrix);
    }

    private void getOriginalCovarianceMatrix(int sx0, int sy0, int sxMax, int syMax, Tile[] sourceTiles, ProductData[] dataBuffers, Covariance[][] originalMatrix) {
        TileIndex srcIndex = new TileIndex(sourceTiles[0]);
        for (int y = sy0; y < syMax; ++y) {
            int yy = y - sy0;
            srcIndex.calculateStride(y);
            for (int x = sx0; x < sxMax; ++x) {
                Covariance matrix;
                int xx = x - sx0;
                if (this.matrixSize == 3) {
                    matrix = new CovarianceMatrix.C3();
                    matrix.getCovarianceMatrix(srcIndex.getIndex(x), dataBuffers);
                } else {
                    matrix = new CovarianceMatrix.C2();
                    matrix.getCovarianceMatrix(srcIndex.getIndex(x), dataBuffers);
                }
                originalMatrix[yy][xx] = matrix;
            }
        }
    }

    private void copyOriginalMatrix(int sx0, int sy0, int sxMax, int syMax, Covariance[][] originalMatrix, Covariance[][] preEstimatedMatrix) {
        for (int y = sy0; y < syMax; ++y) {
            int yy = y - sy0;
            for (int x = sx0; x < sxMax; ++x) {
                int xx = x - sx0;
                preEstimatedMatrix[yy][xx] = originalMatrix[yy][xx].clone();
            }
        }
    }

    private void performGaussianFiltering(int sx0, int sy0, int sxMax, int syMax, Covariance[][] originalMatrix, Covariance[][] preEstimatedMatrix) {
        int i;
        double[][] weight = new double[2 * this.scaleSize + 1][2 * this.scaleSize + 1];
        double sigma2 = ((double)this.scaleSize + 0.5) * ((double)this.scaleSize + 0.5);
        double totalWeight = 0.0;
        for (i = -this.scaleSize; i <= this.scaleSize; ++i) {
            int ii = i + this.scaleSize;
            int i2 = i * i;
            for (int j = -this.scaleSize; j <= this.scaleSize; ++j) {
                double w;
                weight[ii][j + this.scaleSize] = w = Math.exp(-Math.PI * (double)(i2 + j * j) / sigma2);
                totalWeight += w;
            }
        }
        for (i = -this.scaleSize; i <= this.scaleSize; ++i) {
            for (int j = -this.scaleSize; j <= this.scaleSize; ++j) {
                double[] dArray = weight[i + this.scaleSize];
                int n = j + this.scaleSize;
                dArray[n] = dArray[n] / totalWeight;
            }
        }
        int sw = sxMax - sx0;
        int sh = syMax - sy0;
        for (int y = sy0; y < syMax; ++y) {
            int yy = y - sy0;
            for (int x = sx0; x < sxMax; ++x) {
                int xx = x - sx0;
                preEstimatedMatrix[yy][xx] = this.matrixSize == 3 ? new CovarianceMatrix.C3() : new CovarianceMatrix.C2();
                for (int i2 = -this.scaleSize; i2 <= this.scaleSize; ++i2) {
                    int dyy = yy + i2;
                    if (dyy < 0 || dyy > sh - 1) continue;
                    int ii = i2 + this.scaleSize;
                    for (int j = -this.scaleSize; j <= this.scaleSize; ++j) {
                        int dxx = xx + j;
                        if (dxx < 0 || dxx > sw - 1) continue;
                        preEstimatedMatrix[yy][xx].addWeightedCovarianceMatrix(weight[ii][j + this.scaleSize], originalMatrix[dyy][dxx]);
                    }
                }
            }
        }
    }

    private void rescaleCovarianceMatrix(int sx0, int sy0, int sxMax, int syMax, Covariance[][] preEstimatedMatrix) {
        for (int y = sy0; y < syMax; ++y) {
            Covariance[] matrix = preEstimatedMatrix[y - sy0];
            for (int x = sx0; x < sxMax; ++x) {
                matrix[x - sx0].rescaleMatrix(this.gamma);
            }
        }
    }

    private double[][] computeWeights(int xc, int yc, int sx0, int sy0, Covariance[][] preEstimatedMatrix) {
        int xSt = Math.max(xc - this.halfWindowSize, 0);
        int ySt = Math.max(yc - this.halfWindowSize, 0);
        int xEd = Math.min(xc + this.halfWindowSize, this.sourceImageWidth - 1);
        int yEd = Math.min(yc + this.halfWindowSize, this.sourceImageHeight - 1);
        double h = 0.3333333333333333;
        double[][] weight = new double[yEd - ySt + 1][xEd - xSt + 1];
        for (int y = ySt; y <= yEd; ++y) {
            int yy = y - ySt;
            for (int x = xSt; x <= xEd; ++x) {
                int xx = x - xSt;
                double delta = this.computeDissimilarity(xc, yc, x, y, sx0, sy0, preEstimatedMatrix);
                weight[yy][xx] = delta < 0.0 ? 0.0 : Math.exp(-delta / 0.3333333333333333);
            }
        }
        return weight;
    }

    private double computeDissimilarity(int xc1, int yc1, int xc2, int yc2, int sx0, int sy0, Covariance[][] preEstimatedMatrix) {
        double dissimilarity = 0.0;
        boolean validPixel = false;
        for (int i = 0; i < this.patchSize; ++i) {
            int y1 = yc1 - this.halfPatchSize + i;
            int y2 = yc2 - this.halfPatchSize + i;
            if (y1 < 0 || y1 >= this.sourceImageHeight || y2 < 0 || y2 >= this.sourceImageHeight) continue;
            int dy1 = y1 - sy0;
            int dy2 = y2 - sy0;
            for (int j = 0; j < this.patchSize; ++j) {
                int x1 = xc1 - this.halfPatchSize + j;
                int x2 = xc2 - this.halfPatchSize + j;
                if (x1 < 0 || x1 >= this.sourceImageWidth || x2 < 0 || x2 >= this.sourceImageWidth) continue;
                int dx1 = x1 - sx0;
                int dx2 = x2 - sx0;
                Covariance C12 = preEstimatedMatrix[dy1][dx1].clone();
                C12.addCovarianceMatrix(preEstimatedMatrix[dy2][dx2]);
                double detC12 = C12.getDeterminant();
                double detC1 = preEstimatedMatrix[dy1][dx1].getDeterminant();
                double detC2 = preEstimatedMatrix[dy2][dx2].getDeterminant();
                if (detC12 * detC1 * detC2 <= 0.0) continue;
                dissimilarity += -Math.log(detC1 * detC2 / (detC12 * detC12)) - this.matrixSizeTwoLog2;
                validPixel = true;
            }
        }
        if (validPixel) {
            return dissimilarity;
        }
        return -1.0;
    }

    private Covariance computeWeightedEstimate(int xc, int yc, int sx0, int sy0, double[][] weight, double totalWeight, Covariance[][] originalMatrix) {
        int xSt = Math.max(xc - this.halfWindowSize, 0);
        int ySt = Math.max(yc - this.halfWindowSize, 0);
        int xEd = Math.min(xc + this.halfWindowSize, this.sourceImageWidth - 1);
        int yEd = Math.min(yc + this.halfWindowSize, this.sourceImageHeight - 1);
        Covariance avgC = this.matrixSize == 3 ? new CovarianceMatrix.C3() : new CovarianceMatrix.C2();
        for (int y = ySt; y <= yEd; ++y) {
            int yy = y - ySt;
            int i = y - sy0;
            for (int x = xSt; x <= xEd; ++x) {
                avgC.addWeightedCovarianceMatrix(weight[yy][x - xSt] / totalWeight, originalMatrix[i][x - sx0]);
            }
        }
        return avgC;
    }

    private double computeENL(double[][] weight, double totalWeight) {
        int cols = weight[0].length;
        double sum2 = 0.0;
        for (double[] aWeight : weight) {
            for (int c = 0; c < cols; ++c) {
                sum2 += aWeight[c] * aWeight[c];
            }
        }
        return totalWeight * totalWeight / sum2;
    }

    private double performBiasReduction(int xc, int yc, int sx0, int sy0, double[][] weight, double totalWeight, double enlNL, Covariance[][] originalMatrix, Covariance sigmaNL, Covariance sigmaNLBR) {
        int xSt = Math.max(xc - this.halfWindowSize, 0);
        int ySt = Math.max(yc - this.halfWindowSize, 0);
        int xEd = Math.min(xc + this.halfWindowSize, this.sourceImageWidth - 1);
        int yEd = Math.min(yc + this.halfWindowSize, this.sourceImageHeight - 1);
        double[] diagNL = sigmaNL.getDiagonalElements();
        double[] varNL = new double[this.matrixSize];
        for (int j = 0; j < this.matrixSize; ++j) {
            varNL[j] = -diagNL[j] * diagNL[j];
        }
        for (int y = ySt; y <= yEd; ++y) {
            int yy = y - ySt;
            int i = y - sy0;
            for (int x = xSt; x <= xEd; ++x) {
                int xx = x - xSt;
                double[] diagOri = originalMatrix[i][x - sx0].getDiagonalElements();
                for (int j = 0; j < this.matrixSize; ++j) {
                    int n = j;
                    varNL[n] = varNL[n] + weight[yy][xx] / totalWeight * diagOri[j] * diagOri[j];
                }
            }
        }
        double alpha = 0.0;
        for (int j = 0; j < this.matrixSize; ++j) {
            alpha = Math.max(alpha, 1.0 - diagNL[j] * diagNL[j] / (varNL[j] * (double)this.numLooks));
        }
        sigmaNLBR.addWeightedCovarianceMatrix(1.0 - alpha, sigmaNL);
        sigmaNLBR.addWeightedCovarianceMatrix(alpha, originalMatrix[yc - sy0][xc - sx0]);
        return enlNL / ((1.0 - alpha) * (1.0 - alpha) + enlNL * (alpha * alpha + 2.0 * alpha * (1.0 - alpha) / totalWeight));
    }

    private static double getTotalWeight(double[][] weight) {
        int cols = weight[0].length;
        double totalWeight = 0.0;
        for (double[] aWeight : weight) {
            for (int c = 0; c < cols; ++c) {
                totalWeight += aWeight[c];
            }
        }
        return totalWeight;
    }
}

