/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.specklefilters;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.PolarimetricSpeckleFilterOp;
import org.csa.rstb.polarimetric.gpf.specklefilters.SpeckleFilter;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.FilterWindow;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class LeeSigma
implements SpeckleFilter {
    public static final String SIGMA_50_PERCENT = "0.5";
    public static final String SIGMA_60_PERCENT = "0.6";
    public static final String SIGMA_70_PERCENT = "0.7";
    public static final String SIGMA_80_PERCENT = "0.8";
    public static final String SIGMA_90_PERCENT = "0.9";
    private final PolarimetricSpeckleFilterOp operator;
    private final Product sourceProduct;
    private final Product targetProduct;
    private final PolBandUtils.MATRIX sourceProductType;
    private final PolBandUtils.PolSourceBand[] srcBandList;
    private final int filterSize;
    private final int halfFilterSize;
    private final double sigmaV;
    private final double sigmaVSqr;
    private int numLooks;
    private double I1;
    private double I2;
    private int sigma;
    private double sigmaVP;
    private double sigmaVPSqr;
    private int targetWindowSize = 0;
    private int halfTargetWindowSize = 0;
    private int targetSize = 5;

    public LeeSigma(PolarimetricSpeckleFilterOp op, Product srcProduct, Product trgProduct, PolBandUtils.MATRIX sourceProductType, PolBandUtils.PolSourceBand[] srcBandList, int filterSize, int numLooks, String sigmaStr, String targetWindowSizeStr) {
        this.operator = op;
        this.sourceProduct = srcProduct;
        this.targetProduct = trgProduct;
        this.sourceProductType = sourceProductType;
        this.srcBandList = srcBandList;
        this.filterSize = filterSize;
        this.halfFilterSize = filterSize / 2;
        this.numLooks = numLooks;
        this.targetWindowSize = FilterWindow.parseWindowSize((String)targetWindowSizeStr);
        this.halfTargetWindowSize = this.targetWindowSize / 2;
        this.sigmaV = 1.0 / Math.sqrt(numLooks);
        this.sigmaVSqr = this.sigmaV * this.sigmaV;
        this.setSigmaRange(sigmaStr);
    }

    @Override
    public void computeTiles(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        if (this.sourceProductType == PolBandUtils.MATRIX.FULL || this.sourceProductType == PolBandUtils.MATRIX.C3 || this.sourceProductType == PolBandUtils.MATRIX.T3) {
            this.leeSigmaFilter(targetTiles, targetRectangle, sourceRectangle);
        } else if (this.sourceProductType == PolBandUtils.MATRIX.C2 || this.sourceProductType == PolBandUtils.MATRIX.DUAL_HH_HV || this.sourceProductType == PolBandUtils.MATRIX.DUAL_VH_VV || this.sourceProductType == PolBandUtils.MATRIX.DUAL_HH_VV) {
            this.leeSigmaFilterC2(targetTiles, targetRectangle, sourceRectangle);
        } else {
            throw new OperatorException("For Lee Sigma filter, only C2, C3 and T3 are supported currently");
        }
    }

    private void setSigmaRange(String sigmaStr) throws OperatorException {
        switch (sigmaStr) {
            case "0.5": {
                this.sigma = 5;
                break;
            }
            case "0.6": {
                this.sigma = 6;
                break;
            }
            case "0.7": {
                this.sigma = 7;
                break;
            }
            case "0.8": {
                this.sigma = 8;
                break;
            }
            case "0.9": {
                this.sigma = 9;
                break;
            }
            default: {
                throw new OperatorException("Unknown sigma: " + sigmaStr);
            }
        }
        if (this.numLooks == 1) {
            if (this.sigma == 5) {
                this.I1 = 0.436;
                this.I2 = 1.92;
                this.sigmaVP = 0.4057;
            } else if (this.sigma == 6) {
                this.I1 = 0.343;
                this.I2 = 2.21;
                this.sigmaVP = 0.4954;
            } else if (this.sigma == 7) {
                this.I1 = 0.254;
                this.I2 = 2.582;
                this.sigmaVP = 0.5911;
            } else if (this.sigma == 8) {
                this.I1 = 0.168;
                this.I2 = 3.094;
                this.sigmaVP = 0.6966;
            } else if (this.sigma == 9) {
                this.I1 = 0.084;
                this.I2 = 3.941;
                this.sigmaVP = 0.8191;
            }
        } else if (this.numLooks == 2) {
            if (this.sigma == 5) {
                this.I1 = 0.582;
                this.I2 = 1.584;
                this.sigmaVP = 0.2763;
            } else if (this.sigma == 6) {
                this.I1 = 0.501;
                this.I2 = 1.755;
                this.sigmaVP = 0.3388;
            } else if (this.sigma == 7) {
                this.I1 = 0.418;
                this.I2 = 1.972;
                this.sigmaVP = 0.4062;
            } else if (this.sigma == 8) {
                this.I1 = 0.327;
                this.I2 = 2.26;
                this.sigmaVP = 0.481;
            } else if (this.sigma == 9) {
                this.I1 = 0.221;
                this.I2 = 2.744;
                this.sigmaVP = 0.5699;
            }
        } else if (this.numLooks == 3) {
            if (this.sigma == 5) {
                this.I1 = 0.652;
                this.I2 = 1.458;
                this.sigmaVP = 0.2222;
            } else if (this.sigma == 6) {
                this.I1 = 0.58;
                this.I2 = 1.586;
                this.sigmaVP = 0.2736;
            } else if (this.sigma == 7) {
                this.I1 = 0.505;
                this.I2 = 1.751;
                this.sigmaVP = 0.328;
            } else if (this.sigma == 8) {
                this.I1 = 0.419;
                this.I2 = 1.965;
                this.sigmaVP = 0.3892;
            } else if (this.sigma == 9) {
                this.I1 = 0.313;
                this.I2 = 2.32;
                this.sigmaVP = 0.4624;
            }
        } else if (this.numLooks == 4) {
            if (this.sigma == 5) {
                this.I1 = 0.694;
                this.I2 = 1.385;
                this.sigmaVP = 0.1921;
            } else if (this.sigma == 6) {
                this.I1 = 0.63;
                this.I2 = 1.495;
                this.sigmaVP = 0.2348;
            } else if (this.sigma == 7) {
                this.I1 = 0.56;
                this.I2 = 1.627;
                this.sigmaVP = 0.2825;
            } else if (this.sigma == 8) {
                this.I1 = 0.48;
                this.I2 = 1.804;
                this.sigmaVP = 0.3354;
            } else if (this.sigma == 9) {
                this.I1 = 0.378;
                this.I2 = 2.094;
                this.sigmaVP = 0.3991;
            }
        }
        this.sigmaVPSqr = this.sigmaVP * this.sigmaVP;
    }

    private void leeSigmaFilterC2(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            ProductData[] targetDataBuffers = new ProductData[4];
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (targetBandName.contains("C11")) {
                    targetDataBuffers[0] = dataBuffer;
                    continue;
                }
                if (targetBandName.contains("C12_real")) {
                    targetDataBuffers[1] = dataBuffer;
                    continue;
                }
                if (targetBandName.contains("C12_imag")) {
                    targetDataBuffers[2] = dataBuffer;
                    continue;
                }
                if (!targetBandName.contains("C22")) continue;
                targetDataBuffers[3] = dataBuffer;
            }
            Z98 z98 = new Z98();
            this.computeZ98ValuesC2(sourceTiles[0], sourceRectangle, dataBuffers, z98);
            double[][] Cr = new double[2][2];
            double[][] Ci = new double[2][2];
            boolean[][] isPointTarget = new boolean[h][w];
            C2[][] filterWindowC2 = null;
            C2[][] targetWindowC2 = null;
            for (int y = y0; y < maxY; ++y) {
                int yy = y - y0;
                trgIndex.calculateStride(y);
                srcIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int xx = x - x0;
                    int trgIdx = trgIndex.getIndex(x);
                    int srcIdx = srcIndex.getIndex(x);
                    this.getCovarianceMatrixC2(srcIdx, this.sourceProductType, dataBuffers, Cr, Ci);
                    if (isPointTarget[yy][xx]) {
                        LeeSigma.saveC2(Cr, Ci, trgIdx, targetDataBuffers);
                        continue;
                    }
                    if (y - this.halfFilterSize < sy0 || y + this.halfFilterSize > sy0 + sh - 1 || x - this.halfFilterSize < sx0 || x + this.halfFilterSize > sx0 + sw - 1) {
                        filterWindowC2 = new C2[this.filterSize][this.filterSize];
                        this.getWindowPixelC2s(x, y, dataBuffers, sx0, sy0, sw, sh, sourceTiles[0], filterWindowC2);
                        int n = this.setPixelsInSigmaRange(filterWindowC2);
                        this.computeFilteredC2(filterWindowC2, n, this.sigmaVSqr, Cr, Ci);
                        LeeSigma.saveC2(Cr, Ci, trgIdx, targetDataBuffers);
                        continue;
                    }
                    targetWindowC2 = new C2[this.targetWindowSize][this.targetWindowSize];
                    this.getWindowPixelC2s(x, y, dataBuffers, sx0, sy0, sw, sh, sourceTiles[0], targetWindowC2);
                    if (this.checkPointTarget(z98, targetWindowC2, isPointTarget, x0, y0, w, h)) {
                        LeeSigma.saveC2(Cr, Ci, trgIdx, targetDataBuffers);
                        continue;
                    }
                    double[] sigmaRangeC11 = new double[2];
                    double[] sigmaRangeC22 = new double[2];
                    this.computeSigmaRange(targetWindowC2, 0, sigmaRangeC11);
                    this.computeSigmaRange(targetWindowC2, 1, sigmaRangeC22);
                    filterWindowC2 = new C2[this.filterSize][this.filterSize];
                    this.getWindowPixelC2s(x, y, dataBuffers, sx0, sy0, sw, sh, sourceTiles[0], filterWindowC2);
                    int n = this.selectPixelsInSigmaRange(sigmaRangeC11, sigmaRangeC22, filterWindowC2);
                    if (n == 0) {
                        LeeSigma.saveC2(Cr, Ci, trgIdx, targetDataBuffers);
                        continue;
                    }
                    this.computeFilteredC2(filterWindowC2, n, this.sigmaVPSqr, Cr, Ci);
                    LeeSigma.saveC2(Cr, Ci, trgIdx, targetDataBuffers);
                }
            }
        }
    }

    private void computeSigmaRange(C2[][] targetWindowC2, int elemIdx, double[] sigmaRange) {
        double[] data = new double[this.targetWindowSize * this.targetWindowSize];
        int k = 0;
        double mean = 0.0;
        for (int j = 0; j < this.targetWindowSize; ++j) {
            for (int i = 0; i < this.targetWindowSize; ++i) {
                data[k] = targetWindowC2[j][i].Cr[elemIdx][elemIdx];
                mean += data[k];
                ++k;
            }
        }
        double b = this.computeMMSEWeight(data, this.sigmaVSqr);
        double filtered = (mean /= (double)k) + b * (data[k / 2] - mean);
        sigmaRange[0] = filtered * this.I1;
        sigmaRange[1] = filtered * this.I2;
    }

    private int setPixelsInSigmaRange(C2[][] filterWindowC2) {
        int n = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (filterWindowC2[j][i] == null) continue;
                filterWindowC2[j][i].inSigmaRange = true;
                ++n;
            }
        }
        return n;
    }

    private boolean checkPointTarget(Z98 z98, C2[][] targetWindowC2, boolean[][] isPointTarget, int x0, int y0, int w, int h) {
        if (targetWindowC2[this.halfTargetWindowSize][this.halfTargetWindowSize].Cr[0][0] > z98.c11 && this.getClusterSize(z98.c11, targetWindowC2, 0) > this.targetSize) {
            this.markClusterPixels(isPointTarget, z98.c11, targetWindowC2, x0, y0, w, h, 0);
            return true;
        }
        if (targetWindowC2[this.halfTargetWindowSize][this.halfTargetWindowSize].Cr[1][1] > z98.c22 && this.getClusterSize(z98.c22, targetWindowC2, 1) > this.targetSize) {
            this.markClusterPixels(isPointTarget, z98.c22, targetWindowC2, x0, y0, w, h, 1);
            return true;
        }
        return false;
    }

    private int getClusterSize(double threshold, C2[][] targetWindowC2, int elemIdx) {
        int clusterSize = 0;
        for (int j = 0; j < this.targetWindowSize; ++j) {
            for (int i = 0; i < this.targetWindowSize; ++i) {
                if (!(targetWindowC2[j][i].Cr[elemIdx][elemIdx] > threshold)) continue;
                ++clusterSize;
            }
        }
        return clusterSize;
    }

    private void markClusterPixels(boolean[][] isPointTarget, double threshold, C2[][] targetWindowC2, int x0, int y0, int w, int h, int elemIdx) {
        for (int j = 0; j < this.targetWindowSize; ++j) {
            for (int i = 0; i < this.targetWindowSize; ++i) {
                if (!(targetWindowC2[j][i].Cr[elemIdx][elemIdx] > threshold) || targetWindowC2[j][i].y < y0 || targetWindowC2[j][i].y >= y0 + h || targetWindowC2[j][i].x < x0 || targetWindowC2[j][i].x >= x0 + w) continue;
                isPointTarget[targetWindowC2[j][i].y - y0][targetWindowC2[j][i].x - x0] = true;
            }
        }
    }

    private int selectPixelsInSigmaRange(double[] sigmaRangeC11, double[] sigmaRangeC22, C2[][] filterWindowC2) {
        int numPixelsInSigmaRange = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (filterWindowC2[j][i] == null || !(filterWindowC2[j][i].Cr[0][0] >= sigmaRangeC11[0]) || !(filterWindowC2[j][i].Cr[0][0] <= sigmaRangeC11[1]) || !(filterWindowC2[j][i].Cr[1][1] >= sigmaRangeC22[0]) || !(filterWindowC2[j][i].Cr[1][1] <= sigmaRangeC22[1])) continue;
                filterWindowC2[j][i].inSigmaRange = true;
                ++numPixelsInSigmaRange;
            }
        }
        return numPixelsInSigmaRange;
    }

    private static void saveC2(double[][] Cr, double[][] Ci, int idx, ProductData[] targetDataBuffers) {
        targetDataBuffers[0].setElemFloatAt(idx, (float)Cr[0][0]);
        targetDataBuffers[1].setElemFloatAt(idx, (float)Cr[0][1]);
        targetDataBuffers[2].setElemFloatAt(idx, (float)Ci[0][1]);
        targetDataBuffers[3].setElemFloatAt(idx, (float)Cr[1][1]);
    }

    private void getWindowPixelC2s(int x, int y, ProductData[] sourceDataBuffers, int sx0, int sy0, int sw, int sh, Tile sourceTile, C2[][] windowPixelC2) {
        TileIndex srcIndex = new TileIndex(sourceTile);
        int windowSize = windowPixelC2.length;
        int halfWindowSize = windowSize / 2;
        double[][] Cr = new double[2][2];
        double[][] Ci = new double[2][2];
        for (int j = 0; j < windowSize; ++j) {
            int yy = y - halfWindowSize + j;
            srcIndex.calculateStride(yy);
            for (int i = 0; i < windowSize; ++i) {
                int xx = x - halfWindowSize + i;
                if (yy < sy0 || yy > sy0 + sh - 1 || xx < sx0 || xx > sx0 + sw - 1) continue;
                int srcIdx = srcIndex.getIndex(xx);
                this.getCovarianceMatrixC2(srcIdx, this.sourceProductType, sourceDataBuffers, Cr, Ci);
                windowPixelC2[j][i] = new C2(xx, yy, Cr, Ci);
            }
        }
    }

    private void computeFilteredC2(C2[][] filterWindowC2, int n, double sigmaVSqr, double[][] Cr, double[][] Ci) {
        double[] span = new double[n];
        this.getSpan(filterWindowC2, span);
        double b = this.computeMMSEWeight(span, sigmaVSqr);
        this.filterC2(filterWindowC2, b, n, Cr, Ci);
    }

    private void getSpan(C2[][] filterWindowC2, double[] span) {
        int k = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (filterWindowC2[j][i] == null || !filterWindowC2[j][i].inSigmaRange) continue;
                span[k++] = filterWindowC2[j][i].Cr[0][0] + filterWindowC2[j][i].Cr[1][1];
            }
        }
    }

    private void filterC2(C2[][] filterWindowC2, double b, int numPixelsInSigmaRange, double[][] filteredTr, double[][] filteredTi) {
        int n;
        int m;
        double[][] meanCr = new double[2][2];
        double[][] meanCi = new double[2][2];
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (filterWindowC2[j][i] == null || !filterWindowC2[j][i].inSigmaRange) continue;
                for (int m2 = 0; m2 < 2; ++m2) {
                    for (int n2 = 0; n2 < 2; ++n2) {
                        double[] dArray = meanCr[m2];
                        int n3 = n2;
                        dArray[n3] = dArray[n3] + filterWindowC2[j][i].Cr[m2][n2];
                        double[] dArray2 = meanCi[m2];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + filterWindowC2[j][i].Ci[m2][n2];
                    }
                }
            }
        }
        for (m = 0; m < 2; ++m) {
            n = 0;
            while (n < 2) {
                double[] dArray = meanCr[m];
                int n5 = n;
                dArray[n5] = dArray[n5] / (double)numPixelsInSigmaRange;
                double[] dArray3 = meanCi[m];
                int n6 = n++;
                dArray3[n6] = dArray3[n6] / (double)numPixelsInSigmaRange;
            }
        }
        for (m = 0; m < 2; ++m) {
            for (n = 0; n < 2; ++n) {
                filteredTr[m][n] = (1.0 - b) * meanCr[m][n] + b * filterWindowC2[this.halfFilterSize][this.halfFilterSize].Cr[m][n];
                filteredTi[m][n] = (1.0 - b) * meanCi[m][n] + b * filterWindowC2[this.halfFilterSize][this.halfFilterSize].Ci[m][n];
            }
        }
    }

    private void leeSigmaFilter(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] sourceDataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                sourceDataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            ProductData[] targetDataBuffers = new ProductData[9];
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"11")) {
                    targetDataBuffers[0] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_real")) {
                    targetDataBuffers[1] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_imag")) {
                    targetDataBuffers[2] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_real")) {
                    targetDataBuffers[3] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_imag")) {
                    targetDataBuffers[4] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"22")) {
                    targetDataBuffers[5] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_real")) {
                    targetDataBuffers[6] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_imag")) {
                    targetDataBuffers[7] = dataBuffer;
                    continue;
                }
                if (!PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"33")) continue;
                targetDataBuffers[8] = dataBuffer;
            }
            Z98 z98 = new Z98();
            this.computeZ98Values(sourceTiles[0], sourceRectangle, sourceDataBuffers, z98);
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            boolean[][] isPointTarget = new boolean[h][w];
            T3[][] filterWindowT3 = null;
            T3[][] targetWindowT3 = null;
            for (int y = y0; y < maxY; ++y) {
                int yy = y - y0;
                trgIndex.calculateStride(y);
                srcIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int xx = x - x0;
                    int trgIdx = trgIndex.getIndex(x);
                    int srcIdx = srcIndex.getIndex(x);
                    this.getCoherencyMatrixT3(srcIdx, this.sourceProductType, sourceDataBuffers, Tr, Ti);
                    if (isPointTarget[yy][xx]) {
                        LeeSigma.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                        continue;
                    }
                    if (y - this.halfFilterSize < sy0 || y + this.halfFilterSize > sy0 + sh - 1 || x - this.halfFilterSize < sx0 || x + this.halfFilterSize > sx0 + sw - 1) {
                        filterWindowT3 = new T3[this.filterSize][this.filterSize];
                        this.getWindowPixelT3s(x, y, sourceDataBuffers, sx0, sy0, sw, sh, sourceTiles[0], filterWindowT3);
                        int n = this.setPixelsInSigmaRange(filterWindowT3);
                        this.computeFilteredT3(filterWindowT3, n, this.sigmaVSqr, Tr, Ti);
                        LeeSigma.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                        continue;
                    }
                    targetWindowT3 = new T3[this.targetWindowSize][this.targetWindowSize];
                    this.getWindowPixelT3s(x, y, sourceDataBuffers, sx0, sy0, sw, sh, sourceTiles[0], targetWindowT3);
                    if (this.checkPointTarget(z98, targetWindowT3, isPointTarget, x0, y0, w, h)) {
                        LeeSigma.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                        continue;
                    }
                    double[] sigmaRangeT11 = new double[2];
                    double[] sigmaRangeT22 = new double[2];
                    double[] sigmaRangeT33 = new double[2];
                    this.computeSigmaRange(targetWindowT3, 0, sigmaRangeT11);
                    this.computeSigmaRange(targetWindowT3, 1, sigmaRangeT22);
                    this.computeSigmaRange(targetWindowT3, 2, sigmaRangeT33);
                    filterWindowT3 = new T3[this.filterSize][this.filterSize];
                    this.getWindowPixelT3s(x, y, sourceDataBuffers, sx0, sy0, sw, sh, sourceTiles[0], filterWindowT3);
                    int n = this.selectPixelsInSigmaRange(sigmaRangeT11, sigmaRangeT22, sigmaRangeT33, filterWindowT3);
                    if (n == 0) {
                        LeeSigma.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                        continue;
                    }
                    this.computeFilteredT3(filterWindowT3, n, this.sigmaVPSqr, Tr, Ti);
                    LeeSigma.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                }
            }
        }
    }

    private void computeZ98ValuesC2(Tile sourceTile, Rectangle sourceRectangle, ProductData[] sourceDataBuffers, Z98 z98) {
        TileIndex srcIndex = new TileIndex(sourceTile);
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        int z98Index = (int)((double)(sw * sh) * 0.98) - 1;
        double[] c11 = new double[sw * sh];
        double[] c22 = new double[sw * sh];
        double[][] Cr = new double[2][2];
        double[][] Ci = new double[2][2];
        int k = 0;
        for (int y = sy0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            for (int x = sx0; x < maxX; ++x) {
                int index = srcIndex.getIndex(x);
                this.getCovarianceMatrixC2(index, this.sourceProductType, sourceDataBuffers, Cr, Ci);
                c11[k] = Cr[0][0];
                c22[k] = Cr[1][1];
                ++k;
            }
        }
        Arrays.sort(c11);
        Arrays.sort(c22);
        z98.c11 = c11[z98Index];
        z98.c22 = c22[z98Index];
    }

    private void computeZ98Values(Tile sourceTile, Rectangle sourceRectangle, ProductData[] sourceDataBuffers, Z98 z98) {
        TileIndex srcIndex = new TileIndex(sourceTile);
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        int z98Index = (int)((double)(sw * sh) * 0.98) - 1;
        double[] t11 = new double[sw * sh];
        double[] t22 = new double[sw * sh];
        double[] t33 = new double[sw * sh];
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        int k = 0;
        for (int y = sy0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            for (int x = sx0; x < maxX; ++x) {
                int index = srcIndex.getIndex(x);
                this.getCoherencyMatrixT3(index, this.sourceProductType, sourceDataBuffers, Tr, Ti);
                t11[k] = Tr[0][0];
                t22[k] = Tr[1][1];
                t33[k] = Tr[2][2];
                ++k;
            }
        }
        Arrays.sort(t11);
        Arrays.sort(t22);
        Arrays.sort(t33);
        z98.t11 = t11[z98Index];
        z98.t22 = t22[z98Index];
        z98.t33 = t33[z98Index];
    }

    private static void saveT3(double[][] Tr, double[][] Ti, int idx, ProductData[] targetDataBuffers) {
        targetDataBuffers[0].setElemFloatAt(idx, (float)Tr[0][0]);
        targetDataBuffers[1].setElemFloatAt(idx, (float)Tr[0][1]);
        targetDataBuffers[2].setElemFloatAt(idx, (float)Ti[0][1]);
        targetDataBuffers[3].setElemFloatAt(idx, (float)Tr[0][2]);
        targetDataBuffers[4].setElemFloatAt(idx, (float)Ti[0][2]);
        targetDataBuffers[5].setElemFloatAt(idx, (float)Tr[1][1]);
        targetDataBuffers[6].setElemFloatAt(idx, (float)Tr[1][2]);
        targetDataBuffers[7].setElemFloatAt(idx, (float)Ti[1][2]);
        targetDataBuffers[8].setElemFloatAt(idx, (float)Tr[2][2]);
    }

    private void getWindowPixelT3s(int x, int y, ProductData[] sourceDataBuffers, int sx0, int sy0, int sw, int sh, Tile sourceTile, T3[][] windowPixelT3) {
        TileIndex srcIndex = new TileIndex(sourceTile);
        int windowSize = windowPixelT3.length;
        int halfWindowSize = windowSize / 2;
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        for (int j = 0; j < windowSize; ++j) {
            int yy = y - halfWindowSize + j;
            srcIndex.calculateStride(yy);
            for (int i = 0; i < windowSize; ++i) {
                int xx = x - halfWindowSize + i;
                if (yy < sy0 || yy > sy0 + sh - 1 || xx < sx0 || xx > sx0 + sw - 1) continue;
                int srcIdx = srcIndex.getIndex(xx);
                this.getCoherencyMatrixT3(srcIdx, this.sourceProductType, sourceDataBuffers, Tr, Ti);
                windowPixelT3[j][i] = new T3(xx, yy, Tr, Ti);
            }
        }
    }

    private boolean checkPointTarget(Z98 z98, T3[][] targetWindowT3, boolean[][] isPointTarget, int x0, int y0, int w, int h) {
        if (targetWindowT3[this.halfTargetWindowSize][this.halfTargetWindowSize].Tr[0][0] > z98.t11 && this.getClusterSize(z98.t11, targetWindowT3, 0) > this.targetSize) {
            this.markClusterPixels(isPointTarget, z98.t11, targetWindowT3, x0, y0, w, h, 0);
            return true;
        }
        if (targetWindowT3[this.halfTargetWindowSize][this.halfTargetWindowSize].Tr[1][1] > z98.t22 && this.getClusterSize(z98.t22, targetWindowT3, 1) > this.targetSize) {
            this.markClusterPixels(isPointTarget, z98.t22, targetWindowT3, x0, y0, w, h, 1);
            return true;
        }
        if (targetWindowT3[this.halfTargetWindowSize][this.halfTargetWindowSize].Tr[2][2] > z98.t33 && this.getClusterSize(z98.t33, targetWindowT3, 2) > this.targetSize) {
            this.markClusterPixels(isPointTarget, z98.t33, targetWindowT3, x0, y0, w, h, 2);
            return true;
        }
        return false;
    }

    private int getClusterSize(double threshold, T3[][] targetWindowT3, int elemIdx) {
        int clusterSize = 0;
        for (int j = 0; j < this.targetWindowSize; ++j) {
            for (int i = 0; i < this.targetWindowSize; ++i) {
                if (!(targetWindowT3[j][i].Tr[elemIdx][elemIdx] > threshold)) continue;
                ++clusterSize;
            }
        }
        return clusterSize;
    }

    private void markClusterPixels(boolean[][] isPointTarget, double threshold, T3[][] targetWindowT3, int x0, int y0, int w, int h, int elemIdx) {
        for (int j = 0; j < this.targetWindowSize; ++j) {
            for (int i = 0; i < this.targetWindowSize; ++i) {
                if (!(targetWindowT3[j][i].Tr[elemIdx][elemIdx] > threshold) || targetWindowT3[j][i].y < y0 || targetWindowT3[j][i].y >= y0 + h || targetWindowT3[j][i].x < x0 || targetWindowT3[j][i].x >= x0 + w) continue;
                isPointTarget[targetWindowT3[j][i].y - y0][targetWindowT3[j][i].x - x0] = true;
            }
        }
    }

    private void computeSigmaRange(T3[][] targetWindowT3, int elemIdx, double[] sigmaRange) {
        double[] data = new double[this.targetWindowSize * this.targetWindowSize];
        int k = 0;
        double mean = 0.0;
        for (int j = 0; j < this.targetWindowSize; ++j) {
            for (int i = 0; i < this.targetWindowSize; ++i) {
                data[k] = targetWindowT3[j][i].Tr[elemIdx][elemIdx];
                mean += data[k];
                ++k;
            }
        }
        double b = this.computeMMSEWeight(data, this.sigmaVSqr);
        double filtered = (mean /= (double)k) + b * (data[k / 2] - mean);
        sigmaRange[0] = filtered * this.I1;
        sigmaRange[1] = filtered * this.I2;
    }

    private int setPixelsInSigmaRange(T3[][] filterWindowT3) {
        int n = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (filterWindowT3[j][i] == null) continue;
                filterWindowT3[j][i].inSigmaRange = true;
                ++n;
            }
        }
        return n;
    }

    private int selectPixelsInSigmaRange(double[] sigmaRangeT11, double[] sigmaRangeT22, double[] sigmaRangeT33, T3[][] filterWindowT3) {
        int numPixelsInSigmaRange = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (filterWindowT3[j][i] == null || !(filterWindowT3[j][i].Tr[0][0] >= sigmaRangeT11[0]) || !(filterWindowT3[j][i].Tr[0][0] <= sigmaRangeT11[1]) || !(filterWindowT3[j][i].Tr[1][1] >= sigmaRangeT22[0]) || !(filterWindowT3[j][i].Tr[1][1] <= sigmaRangeT22[1]) || !(filterWindowT3[j][i].Tr[2][2] >= sigmaRangeT33[0]) || !(filterWindowT3[j][i].Tr[2][2] <= sigmaRangeT33[1])) continue;
                filterWindowT3[j][i].inSigmaRange = true;
                ++numPixelsInSigmaRange;
            }
        }
        return numPixelsInSigmaRange;
    }

    private void computeFilteredT3(T3[][] filterWindowT3, int n, double sigmaVSqr, double[][] Tr, double[][] Ti) {
        double[] span = new double[n];
        this.getSpan(filterWindowT3, span);
        double b = this.computeMMSEWeight(span, sigmaVSqr);
        this.filterT3(filterWindowT3, b, n, Tr, Ti);
    }

    private void getSpan(T3[][] filterWindowT3, double[] span) {
        int k = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (filterWindowT3[j][i] == null || !filterWindowT3[j][i].inSigmaRange) continue;
                span[k++] = filterWindowT3[j][i].Tr[0][0] + filterWindowT3[j][i].Tr[1][1] + filterWindowT3[j][i].Tr[2][2];
            }
        }
    }

    private void filterT3(T3[][] filterWindowT3, double b, int numPixelsInSigmaRange, double[][] filteredTr, double[][] filteredTi) {
        int n;
        int m;
        double[][] meanTr = new double[3][3];
        double[][] meanTi = new double[3][3];
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (filterWindowT3[j][i] == null || !filterWindowT3[j][i].inSigmaRange) continue;
                for (int m2 = 0; m2 < 3; ++m2) {
                    for (int n2 = 0; n2 < 3; ++n2) {
                        double[] dArray = meanTr[m2];
                        int n3 = n2;
                        dArray[n3] = dArray[n3] + filterWindowT3[j][i].Tr[m2][n2];
                        double[] dArray2 = meanTi[m2];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + filterWindowT3[j][i].Ti[m2][n2];
                    }
                }
            }
        }
        for (m = 0; m < 3; ++m) {
            n = 0;
            while (n < 3) {
                double[] dArray = meanTr[m];
                int n5 = n;
                dArray[n5] = dArray[n5] / (double)numPixelsInSigmaRange;
                double[] dArray3 = meanTi[m];
                int n6 = n++;
                dArray3[n6] = dArray3[n6] / (double)numPixelsInSigmaRange;
            }
        }
        for (m = 0; m < 3; ++m) {
            for (n = 0; n < 3; ++n) {
                filteredTr[m][n] = (1.0 - b) * meanTr[m][n] + b * filterWindowT3[this.halfFilterSize][this.halfFilterSize].Tr[m][n];
                filteredTi[m][n] = (1.0 - b) * meanTi[m][n] + b * filterWindowT3[this.halfFilterSize][this.halfFilterSize].Ti[m][n];
            }
        }
    }

    public static final class T3 {
        public int x = -1;
        public int y = -1;
        public final double[][] Tr = new double[3][3];
        public final double[][] Ti = new double[3][3];
        public boolean inSigmaRange = false;

        public T3(int x, int y, double[][] Tr, double[][] Ti) {
            this.x = x;
            this.y = y;
            for (int a = 0; a < Tr.length; ++a) {
                System.arraycopy(Tr[a], 0, this.Tr[a], 0, Tr[a].length);
                System.arraycopy(Ti[a], 0, this.Ti[a], 0, Ti[a].length);
            }
        }

        public T3() {
        }
    }

    public static final class Z98 {
        public double c11;
        public double c22;
        public double t11;
        public double t22;
        public double t33;
    }

    public static final class C2 {
        public int x = -1;
        public int y = -1;
        public final double[][] Cr = new double[2][2];
        public final double[][] Ci = new double[2][2];
        public boolean inSigmaRange = false;

        public C2(int x, int y, double[][] Cr, double[][] Ci) {
            this.x = x;
            this.y = y;
            for (int a = 0; a < Cr.length; ++a) {
                System.arraycopy(Cr[a], 0, this.Cr[a], 0, Cr[a].length);
                System.arraycopy(Ci[a], 0, this.Ci[a], 0, Ci[a].length);
            }
        }

        public C2() {
        }
    }
}

