/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.specklefilters;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.DualPolProcessor;
import org.csa.rstb.polarimetric.gpf.PolarimetricSpeckleFilterOp;
import org.csa.rstb.polarimetric.gpf.QuadPolProcessor;
import org.csa.rstb.polarimetric.gpf.specklefilters.SpeckleFilter;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class BoxCar
implements SpeckleFilter,
DualPolProcessor,
QuadPolProcessor {
    private final PolarimetricSpeckleFilterOp operator;
    private final Product sourceProduct;
    private final Product targetProduct;
    private final PolBandUtils.MATRIX sourceProductType;
    private final PolBandUtils.PolSourceBand[] srcBandList;
    private final int filterSize;
    private final int halfFilterSize;

    public BoxCar(PolarimetricSpeckleFilterOp op, Product srcProduct, Product trgProduct, PolBandUtils.MATRIX sourceProductType, PolBandUtils.PolSourceBand[] srcBandList, int filterSize) {
        this.operator = op;
        this.sourceProduct = srcProduct;
        this.targetProduct = trgProduct;
        this.sourceProductType = sourceProductType;
        this.srcBandList = srcBandList;
        this.filterSize = filterSize;
        this.halfFilterSize = filterSize / 2;
    }

    @Override
    public void computeTiles(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        if (PolBandUtils.isFullPol((PolBandUtils.MATRIX)this.sourceProductType)) {
            this.boxcarFilterFullPol(targetTiles, targetRectangle, sourceRectangle);
        } else if (PolBandUtils.isQuadPol((PolBandUtils.MATRIX)this.sourceProductType)) {
            this.boxcarFilterC3T3C4T4(targetTiles, targetRectangle, sourceRectangle);
        } else if (PolBandUtils.isDualPol((PolBandUtils.MATRIX)this.sourceProductType)) {
            this.boxcarFilterC2(targetTiles, targetRectangle, sourceRectangle);
        } else {
            throw new OperatorException("For Boxcar filtering, only C2, C3, T3, C4 and T4 are supported");
        }
    }

    private void boxcarFilterC2(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        int sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            double[][] Cr = new double[2][2];
            double[][] Ci = new double[2][2];
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int idx = trgIndex.getIndex(x);
                    this.getMeanCovarianceMatrixC2(x, y, this.halfFilterSize, this.halfFilterSize, sourceImageWidth, sourceImageHeight, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                    for (Band targetBand : bandList.targetBands) {
                        String targetBandName = targetBand.getName();
                        ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                        if (targetBandName.equals("C11")) {
                            dataBuffer.setElemFloatAt(idx, (float)Cr[0][0]);
                            continue;
                        }
                        if (targetBandName.contains("C12_real")) {
                            dataBuffer.setElemFloatAt(idx, (float)Cr[0][1]);
                            continue;
                        }
                        if (targetBandName.contains("C12_imag")) {
                            dataBuffer.setElemFloatAt(idx, (float)Ci[0][1]);
                            continue;
                        }
                        if (!targetBandName.equals("C22")) continue;
                        dataBuffer.setElemFloatAt(idx, (float)Cr[1][1]);
                    }
                }
            }
        }
    }

    private void boxcarFilterFullPol(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        int sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int idx = trgIndex.getIndex(x);
                    this.getMeanCoherencyMatrix(x, y, this.halfFilterSize, this.halfFilterSize, sourceImageWidth, sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                    for (Band targetBand : bandList.targetBands) {
                        String targetBandName = targetBand.getName();
                        ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                        if (targetBandName.equals("T11") || targetBandName.contains("T11_")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[0][0]);
                            continue;
                        }
                        if (targetBandName.contains("T12_real")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[0][1]);
                            continue;
                        }
                        if (targetBandName.contains("T12_imag")) {
                            dataBuffer.setElemFloatAt(idx, (float)Ti[0][1]);
                            continue;
                        }
                        if (targetBandName.contains("T13_real")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[0][2]);
                            continue;
                        }
                        if (targetBandName.contains("T13_imag")) {
                            dataBuffer.setElemFloatAt(idx, (float)Ti[0][2]);
                            continue;
                        }
                        if (targetBandName.equals("T22") || targetBandName.contains("T22_")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[1][1]);
                            continue;
                        }
                        if (targetBandName.contains("T23_real")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[1][2]);
                            continue;
                        }
                        if (targetBandName.contains("T23_imag")) {
                            dataBuffer.setElemFloatAt(idx, (float)Ti[1][2]);
                            continue;
                        }
                        if (!targetBandName.equals("T33") && !targetBandName.contains("T33_")) continue;
                        dataBuffer.setElemFloatAt(idx, (float)Tr[2][2]);
                    }
                }
            }
        }
    }

    private void boxcarFilterC3T3C4T4(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        double[] neighborValues = new double[this.filterSize * this.filterSize];
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            for (Band targetBand : bandList.targetBands) {
                Tile targetTile = targetTiles.get(targetBand);
                ProductData dataBuffer = targetTile.getDataBuffer();
                Tile sourceTile = this.operator.getSourceTile((RasterDataNode)this.sourceProduct.getBand(targetBand.getName()), sourceRectangle);
                for (int y = y0; y < maxY; ++y) {
                    for (int x = x0; x < maxX; ++x) {
                        int idx = targetTile.getDataBufferIndex(x, y);
                        this.getNeighborValues(x, y, sx0, sy0, sw, sh, sourceTile, neighborValues);
                        dataBuffer.setElemFloatAt(idx, (float)this.getMeanValue(neighborValues));
                    }
                }
            }
        }
    }

    private void getNeighborValues(int x, int y, int sx0, int sy0, int sw, int sh, Tile sourceTile, double[] neighborValues) {
        ProductData sourceData = sourceTile.getDataBuffer();
        for (int i = 0; i < this.filterSize; ++i) {
            int xi = x - this.halfFilterSize + i;
            if (xi < sx0) {
                xi = sx0;
            } else if (xi >= sx0 + sw) {
                xi = sx0 + sw - 1;
            }
            int stride = i * this.filterSize;
            for (int j = 0; j < this.filterSize; ++j) {
                int yj = y - this.halfFilterSize + j;
                if (yj < sy0) {
                    yj = sy0;
                } else if (yj >= sy0 + sh) {
                    yj = sy0 + sh - 1;
                }
                neighborValues[j + stride] = sourceData.getElemDoubleAt(sourceTile.getDataBufferIndex(xi, yj));
            }
        }
    }
}

