/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions_cp;

import java.awt.Rectangle;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.csa.rstb.polarimetric.gpf.CompactPolProcessor;
import org.csa.rstb.polarimetric.gpf.StokesParameters;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class CP_RVOG
extends DecompositionBase
implements Decomposition,
CompactPolProcessor {
    private final String compactMode;
    private final boolean useRCMConvention;
    private final boolean outputRVOG;
    private static final String RED = "RVOG_dbl_r";
    private static final String GREEN = "RVOG_vol_g";
    private static final String BLUE = "RVOG_surf_b";
    private static final String ALPHAS = "alphaS";
    private static final String MV = "mv";
    private static final String MS = "ms";
    private static final String PHI = "phi";

    public CP_RVOG(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, String compactMode, int windowSizeX, int windowSizeY, boolean outputRVOG, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSizeX, windowSizeY, srcImageWidth, srcImageHeight);
        this.compactMode = compactMode;
        this.useRCMConvention = PolBandUtils.useRCMConvention();
        this.outputRVOG = outputRVOG;
    }

    @Override
    public String getSuffix() {
        return "_RVOG";
    }

    @Override
    public String[] getTargetBandNames() {
        if (this.outputRVOG) {
            return new String[]{ALPHAS, MV, MS, PHI};
        }
        return new String[]{RED, GREEN, BLUE};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        if (this.outputRVOG) {
            this.computeTileRVOG(targetTiles, targetRectangle, op);
        } else {
            this.computeTile3Comp(targetTiles, targetRectangle, op);
        }
    }

    private void computeTileRVOG(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            ProductData[] tgtDataBuffer = new ProductData[bandList.targetBands.length];
            for (int i = 0; i < bandList.targetBands.length; ++i) {
                tgtDataBuffer[i] = targetTiles.get(bandList.targetBands[i]).getDataBuffer();
            }
            TileIndex trgIndex = new TileIndex(targetTiles.get(bandList.targetBands[0]));
            double[][] Cr = new double[2][2];
            double[][] Ci = new double[2][2];
            double[] g = new double[4];
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            double v = 0.0;
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int index = trgIndex.getIndex(x);
                    this.getMeanCovarianceMatrixC2(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                    StokesParameters.computeCompactPolStokesVector(Cr, Ci, g);
                    StokesParameters sp = StokesParameters.computeStokesParameters(g, this.compactMode, this.useRCMConvention);
                    for (int i = 0; i < bandList.targetBands.length; ++i) {
                        String targetBandName = bandList.targetBands[i].getName();
                        if (targetBandName.contains(ALPHAS)) {
                            v = sp.Alphas;
                        } else if (targetBandName.contains(MV)) {
                            v = 0.5 * g[0] * sp.DegreeOfDepolarization;
                        } else if (targetBandName.contains(MS)) {
                            v = 2.0 * g[0] * sp.DegreeOfPolarization;
                        } else if (targetBandName.contains(PHI)) {
                            v = sp.PhasePhi;
                        }
                        tgtDataBuffer[i].setElemFloatAt(index, (float)v);
                    }
                }
            }
        }
    }

    private void computeTile3Comp(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains(RED)) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains(GREEN)) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains(BLUE)) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Cr = new double[2][2];
            double[][] Ci = new double[2][2];
            double[] g = new double[4];
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            double v = 0.0;
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int index = trgIndex.getIndex(x);
                    this.getMeanCovarianceMatrixC2(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                    StokesParameters.computeCompactPolStokesVector(Cr, Ci, g);
                    StokesParameters sp = StokesParameters.computeStokesParameters(g, this.compactMode, this.useRCMConvention);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            v = sp.DegreeOfPolarization * g[0] * (1.0 - FastMath.cos((double)(2.0 * sp.Alphas))) / 2.0;
                        } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                            v = sp.DegreeOfDepolarization * g[0];
                        } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                            v = sp.DegreeOfPolarization * g[0] * (1.0 + FastMath.cos((double)(2.0 * sp.Alphas))) / 2.0;
                        }
                        target.dataBuffer.setElemFloatAt(index, (float)v);
                    }
                }
            }
        }
    }
}

