/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions_cp;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.CompactPolProcessor;
import org.csa.rstb.polarimetric.gpf.StokesParameters;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.csa.rstb.polarimetric.gpf.decompositions.EigenDecomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.HAlphaC2;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class CP_HAlpha
extends HAlphaC2
implements CompactPolProcessor {
    private final String compactMode;
    private final boolean computeAlphaByT3;
    private final boolean useRCMConvention;

    public CP_HAlpha(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, String compactMode, int windowSizeX, int windowSizeY, boolean computeAlphaByT3, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSizeX, windowSizeY, srcImageWidth, srcImageHeight);
        this.compactMode = compactMode;
        this.computeAlphaByT3 = computeAlphaByT3;
        this.useRCMConvention = PolBandUtils.useRCMConvention();
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("Entropy")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("Anisotropy")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("Alpha")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Cr = new double[2][2];
            double[][] Ci = new double[2][2];
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            double v = 0.0;
            if (this.computeAlphaByT3) {
                double[] g = new double[4];
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        int index = trgIndex.getIndex(x);
                        this.getMeanCovarianceMatrixC2(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                        StokesParameters.computeCompactPolStokesVector(Cr, Ci, g);
                        HAlphaC2.HAAlpha data = CP_HAlpha.computeHAAlphaByT3(Cr, Ci, g, this.compactMode, this.useRCMConvention);
                        DecompositionBase.TargetInfo[] targetInfoArray = targetInfo;
                        int n = targetInfoArray.length;
                        for (int i = 0; i < n; ++i) {
                            DecompositionBase.TargetInfo target = targetInfoArray[i];
                            if (target.colour == DecompositionBase.TargetBandColour.R) {
                                v = data.entropy;
                            } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                                v = data.anisotropy;
                            } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                                v = data.alpha;
                            }
                            target.dataBuffer.setElemFloatAt(index, (float)v);
                        }
                    }
                }
                continue;
            }
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int index = trgIndex.getIndex(x);
                    this.getMeanCovarianceMatrixC2(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                    HAlphaC2.HAAlpha data = CP_HAlpha.computeHAAlphaByC2(Cr, Ci);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            v = data.entropy;
                        } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                            v = data.anisotropy;
                        } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                            v = data.alpha;
                        }
                        target.dataBuffer.setElemFloatAt(index, (float)v);
                    }
                }
            }
        }
    }

    public static HAlphaC2.HAAlpha computeHAAlphaByT3(double[][] Cr, double[][] Ci, double[] g, String compactMode, boolean useRCMConvention) {
        HAlphaC2.HAAlpha data = new HAlphaC2.HAAlpha();
        double[][] EigenVectRe = new double[2][2];
        double[][] EigenVectIm = new double[2][2];
        double[] EigenVal = new double[2];
        EigenDecomposition.eigenDecomposition(2, Cr, Ci, EigenVectRe, EigenVectIm, EigenVal);
        double sum = EigenVal[0] + EigenVal[1];
        double[] p = new double[]{EigenVal[0] / sum, EigenVal[1] / sum};
        data.entropy = -(p[0] * Math.log(p[0] + 1.0E-15) + p[1] * Math.log(p[1] + 1.0E-15)) / Math.log(2.0);
        data.anisotropy = (p[0] - p[1]) / (p[0] + p[1] + 1.0E-15);
        data.alpha = compactMode.equals("Left Circular Hybrid Mode") && !useRCMConvention || compactMode.equals("Right Circular Hybrid Mode") && useRCMConvention ? 0.5 * Math.atan2(Math.sqrt(g[1] * g[1] + g[2] * g[2]), g[3]) * 57.29577951308232 : 0.5 * Math.atan2(Math.sqrt(g[1] * g[1] + g[2] * g[2]), -g[3]) * 57.29577951308232;
        return data;
    }
}

