/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.QuadPolProcessor;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class vanZyl
extends DecompositionBase
implements Decomposition,
QuadPolProcessor {
    public vanZyl(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, windowSize, srcImageWidth, srcImageHeight);
    }

    @Override
    public String getSuffix() {
        return "_VanZyl";
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"VanZyl_dbl_r", "VanZyl_vol_g", "VanZyl_surf_b"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity_db");
    }

    private synchronized void setSpanMinMax(Operator op, PolBandUtils.PolSourceBand bandList) throws OperatorException {
        if (bandList.spanMinMaxSet) {
            return;
        }
        DecompositionBase.MinMax span = this.computeSpanMinMax(op, this.sourceProductType, this.halfWindowSizeX, this.halfWindowSizeY, bandList);
        bandList.spanMin = span.min;
        bandList.spanMax = span.max;
        bandList.spanMinMaxSet = true;
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("VanZyl_dbl_r")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("VanZyl_vol_g")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("VanZyl_surf_b")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Cr = new double[3][3];
            double[][] Ci = new double[3][3];
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            if (!bandList.spanMinMaxSet) {
                this.setSpanMinMax(op, bandList);
            }
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
            this.getQuadPolDataBuffer(op, bandList.srcBands, sourceRectangle, this.sourceProductType, sourceTiles, dataBuffers);
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            double nodatavalue = bandList.srcBands[0].getNoDataValue();
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                srcIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    boolean isNoData = this.isNoData(dataBuffers, srcIndex.getIndex(x), nodatavalue);
                    if (isNoData) {
                        for (DecompositionBase.TargetInfo target : targetInfo) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)nodatavalue);
                        }
                        continue;
                    }
                    if (this.sourceProductType == PolBandUtils.MATRIX.FULL || this.sourceProductType == PolBandUtils.MATRIX.C3) {
                        this.getMeanCovarianceMatrix(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                    } else if (this.sourceProductType == PolBandUtils.MATRIX.T3) {
                        this.getMeanCoherencyMatrix(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                        this.t3ToC3(Tr, Ti, Cr, Ci);
                    }
                    VDD data = vanZyl.getVanZylDecomposition(Cr, Ci);
                    double Ps = vanZyl.scaleDb(data.ps, bandList.spanMin, bandList.spanMax);
                    double Pd = vanZyl.scaleDb(data.pd, bandList.spanMin, bandList.spanMax);
                    double Pv = vanZyl.scaleDb(data.pv, bandList.spanMin, bandList.spanMax);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)Pd);
                            continue;
                        }
                        if (target.colour == DecompositionBase.TargetBandColour.G) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)Pv);
                            continue;
                        }
                        if (target.colour != DecompositionBase.TargetBandColour.B) continue;
                        target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)Ps);
                    }
                }
            }
        }
    }

    public static VDD getVanZylDecomposition(double[][] Cr, double[][] Ci) {
        double Pd;
        double Ps;
        double FV;
        double HHVVvre;
        double HVHVv;
        double VVVVv;
        double HHHHv;
        double C11 = Cr[0][0];
        double C22 = Cr[1][1];
        double C33 = Cr[2][2];
        double C13_re = Cr[0][2];
        double C13_im = Ci[0][2];
        double ratio = 10.0 * Math.log10(C33 / C11);
        if (ratio <= -2.0) {
            HHHHv = 8.0;
            VVVVv = 3.0;
            HVHVv = 4.0;
            HHVVvre = 2.0;
        } else if (ratio > 2.0) {
            HHHHv = 3.0;
            VVVVv = 8.0;
            HVHVv = 4.0;
            HHVVvre = 2.0;
        } else {
            HHHHv = 3.0;
            VVVVv = 3.0;
            HVHVv = 2.0;
            HHVVvre = 1.0;
        }
        double sq_rt = C11 * VVVVv + C33 * HHHHv - 2.0 * C13_re * HHVVvre;
        sq_rt = sq_rt * sq_rt - 4.0 * (HHVVvre * HHVVvre - HHHHv * VVVVv) * (C13_re * C13_re + C13_im * C13_im - C11 * C33);
        sq_rt = Math.sqrt(sq_rt + 1.0E-15);
        double alp1 = 2.0 * C13_re * HHVVvre - (C11 * VVVVv + C33 * HHHHv) + sq_rt;
        alp1 = alp1 / 2.0 / (HHVVvre - HHHHv * VVVVv + 1.0E-15);
        double alp2 = 2.0 * C13_re * HHVVvre - (C11 * VVVVv + C33 * HHHHv) - sq_rt;
        alp2 = alp2 / 2.0 / (HHVVvre - HHHHv * VVVVv + 1.0E-15);
        double alp3 = C22 / HVHVv;
        double alpmin = Math.min(Math.min(alp1, alp2), alp3);
        if (ratio <= -2.0) {
            FV = 15.0 * alpmin;
            C11 -= 8.0 * alpmin;
            C33 -= 3.0 * alpmin;
            C13_re -= 2.0 * alpmin;
        } else if (ratio > 2.0) {
            FV = 15.0 * alpmin;
            C11 -= 3.0 * alpmin;
            C33 -= 8.0 * alpmin;
            C13_re -= 2.0 * alpmin;
        } else {
            FV = 8.0 * alpmin;
            C11 -= 3.0 * alpmin;
            C33 -= 3.0 * alpmin;
            C13_re -= 1.0 * alpmin;
        }
        double alpha = C11;
        double mu = C33 / C11;
        double eta = C22 / C11;
        double rhoRe = C13_re / C11;
        double rhoIm = C13_im / C11;
        double rho2 = rhoRe * rhoRe + rhoIm * rhoIm;
        double delta = Math.sqrt((1.0 - mu) * (1.0 - mu) + 4.0 * rho2);
        double lambda1 = 0.5 * alpha * (1.0 + mu + delta);
        double lambda2 = 0.5 * alpha * (1.0 + mu - delta);
        double tmp1 = (mu - 1.0 + delta) * (mu - 1.0 + delta);
        double tmp2 = tmp1 + 4.0 * rho2;
        double Lambda1 = lambda1 * tmp1 / tmp2;
        tmp1 = (mu - 1.0 - delta) * (mu - 1.0 - delta);
        tmp2 = tmp1 + 4.0 * rho2;
        double Lambda2 = lambda2 * tmp1 / tmp2;
        double AlphaRe = 2.0 * rhoRe / (mu - 1.0 + delta);
        double AlphaIm = 2.0 * rhoIm / (mu - 1.0 + delta);
        double BetaRe = 2.0 * rhoRe / (mu - 1.0 - delta);
        double BetaIm = 2.0 * rhoIm / (mu - 1.0 - delta);
        tmp1 = Lambda1 * ((1.0 + AlphaRe) * (1.0 + AlphaRe) + AlphaIm * AlphaIm);
        tmp2 = Lambda2 * ((1.0 - AlphaRe) * (1.0 - AlphaRe) + AlphaIm * AlphaIm);
        if (tmp1 > tmp2) {
            Ps = Lambda1 * (1.0 + AlphaRe * AlphaRe + AlphaIm * AlphaIm);
            Pd = Lambda2 * (1.0 + BetaRe * BetaRe + BetaIm * BetaIm);
        } else {
            Pd = Lambda1 * (1.0 + AlphaRe * AlphaRe + AlphaIm * AlphaIm);
            Ps = Lambda2 * (1.0 + BetaRe * BetaRe + BetaIm * BetaIm);
        }
        double Pv = FV;
        return new VDD(Pv, Pd, Ps);
    }

    public static class VDD {
        public final double pv;
        public final double pd;
        public final double ps;

        public VDD(double pv, double pd, double ps) {
            this.pd = pd;
            this.ps = ps;
            this.pv = pv;
        }
    }
}

