/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.csa.rstb.polarimetric.gpf.QuadPolProcessor;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.csa.rstb.polarimetric.gpf.decompositions.EigenDecomposition;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class Touzi
extends DecompositionBase
implements Decomposition,
QuadPolProcessor {
    private final boolean outputTouziParamSet0;
    private final boolean outputTouziParamSet1;
    private final boolean outputTouziParamSet2;
    private final boolean outputTouziParamSet3;

    public Touzi(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight, boolean outputTouziParamSet0, boolean outputTouziParamSet1, boolean outputTouziParamSet2, boolean outputTouziParamSet3) {
        super(srcBandList, sourceProductType, windowSize, windowSize, srcImageWidth, srcImageHeight);
        this.outputTouziParamSet0 = outputTouziParamSet0;
        this.outputTouziParamSet1 = outputTouziParamSet1;
        this.outputTouziParamSet2 = outputTouziParamSet2;
        this.outputTouziParamSet3 = outputTouziParamSet3;
    }

    @Override
    public String getSuffix() {
        return "_Touzi";
    }

    @Override
    public String[] getTargetBandNames() {
        ArrayList<String> targetBandNameList = new ArrayList<String>(4);
        if (!(this.outputTouziParamSet0 || this.outputTouziParamSet1 || this.outputTouziParamSet2 || this.outputTouziParamSet3)) {
            throw new OperatorException("Please select decomposition parameters to output");
        }
        if (this.outputTouziParamSet0) {
            targetBandNameList.add("Psi");
            targetBandNameList.add("Tau");
            targetBandNameList.add("Alpha");
            targetBandNameList.add("Phi");
        }
        if (this.outputTouziParamSet1) {
            targetBandNameList.add("Psi1");
            targetBandNameList.add("Tau1");
            targetBandNameList.add("Alpha1");
            targetBandNameList.add("Phi1");
        }
        if (this.outputTouziParamSet2) {
            targetBandNameList.add("Psi2");
            targetBandNameList.add("Tau2");
            targetBandNameList.add("Alpha2");
            targetBandNameList.add("Phi2");
        }
        if (this.outputTouziParamSet3) {
            targetBandNameList.add("Psi3");
            targetBandNameList.add("Tau3");
            targetBandNameList.add("Alpha3");
            targetBandNameList.add("Phi3");
        }
        return targetBandNameList.toArray(new String[targetBandNameList.size()]);
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("rad");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        TileIndex trgIndex = new TileIndex(targetTiles.get(op.getTargetProduct().getBandAt(0)));
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
            this.getQuadPolDataBuffer(op, bandList.srcBands, sourceRectangle, this.sourceProductType, sourceTiles, dataBuffers);
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            double nodatavalue = bandList.srcBands[0].getNoDataValue();
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                srcIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    boolean isNoData = this.isNoData(dataBuffers, srcIndex.getIndex(x), nodatavalue);
                    if (isNoData) {
                        for (Band band : bandList.targetBands) {
                            targetTiles.get(band).getDataBuffer().setElemFloatAt(trgIndex.getIndex(x), (float)nodatavalue);
                        }
                        continue;
                    }
                    int idx = trgIndex.getIndex(x);
                    this.getMeanCoherencyMatrix(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                    TDD data = Touzi.getTouziDecomposition(Tr, Ti);
                    for (Band band : bandList.targetBands) {
                        String targetBandName = band.getName();
                        ProductData dataBuffer = targetTiles.get(band).getDataBuffer();
                        if (this.outputTouziParamSet0) {
                            if (targetBandName.equals("Psi") || targetBandName.contains("Psi_")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.psiMean);
                            } else if (targetBandName.equals("Tau") || targetBandName.contains("Tau_")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.tauMean);
                            } else if (targetBandName.equals("Alpha") || targetBandName.contains("Alpha_")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.alphaMean);
                            } else if (targetBandName.equals("Phi") || targetBandName.contains("Phi_")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.phiMean);
                            }
                        }
                        if (this.outputTouziParamSet1) {
                            if (targetBandName.contains("Psi1")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.psi1);
                            } else if (targetBandName.contains("Tau1")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.tau1);
                            } else if (targetBandName.contains("Alpha1")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.alpha1);
                            } else if (targetBandName.contains("Phi1")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.phi1);
                            }
                        }
                        if (this.outputTouziParamSet2) {
                            if (targetBandName.contains("Psi2")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.psi2);
                            } else if (targetBandName.contains("Tau2")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.tau2);
                            } else if (targetBandName.contains("Alpha2")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.alpha2);
                            } else if (targetBandName.contains("Phi2")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.phi2);
                            }
                        }
                        if (!this.outputTouziParamSet3) continue;
                        if (targetBandName.contains("Psi3")) {
                            dataBuffer.setElemFloatAt(idx, (float)data.psi3);
                            continue;
                        }
                        if (targetBandName.contains("Tau3")) {
                            dataBuffer.setElemFloatAt(idx, (float)data.tau3);
                            continue;
                        }
                        if (targetBandName.contains("Alpha3")) {
                            dataBuffer.setElemFloatAt(idx, (float)data.alpha3);
                            continue;
                        }
                        if (!targetBandName.contains("Phi3")) continue;
                        dataBuffer.setElemFloatAt(idx, (float)data.phi3);
                    }
                }
            }
        }
    }

    public static TDD getTouziDecomposition(double[][] Tr, double[][] Ti) {
        double[][] EigenVectRe = new double[3][3];
        double[][] EigenVectIm = new double[3][3];
        double[] EigenVal = new double[3];
        double[] psi = new double[3];
        double[] tau = new double[3];
        double[] alpha = new double[3];
        double[] phi = new double[3];
        double[] vr = new double[3];
        double[] vi = new double[3];
        EigenDecomposition.eigenDecomposition(3, Tr, Ti, EigenVectRe, EigenVectIm, EigenVal);
        for (int k = 0; k < 3; ++k) {
            double tmp1i;
            double tmp1r;
            int l;
            for (l = 0; l < 3; ++l) {
                vr[l] = EigenVectRe[l][k];
                vi[l] = EigenVectIm[l][k];
            }
            double phase = Math.atan2(vi[0], vr[0] + 1.0E-15);
            double c = FastMath.cos((double)phase);
            double s = FastMath.sin((double)phase);
            for (l = 0; l < 3; ++l) {
                tmp1r = vr[l];
                tmp1i = vi[l];
                vr[l] = tmp1r * c + tmp1i * s;
                vi[l] = tmp1i * c - tmp1r * s;
            }
            psi[k] = 0.5 * Math.atan2(vr[2], vr[1] + 1.0E-15);
            tmp1r = vr[1];
            tmp1i = vi[1];
            double tmp2r = vr[2];
            double tmp2i = vi[2];
            c = FastMath.cos((double)(2.0 * psi[k]));
            s = FastMath.sin((double)(2.0 * psi[k]));
            vr[1] = tmp1r * c + tmp2r * s;
            vi[1] = tmp1i * c + tmp2i * s;
            vr[2] = -tmp1r * s + tmp2r * c;
            vi[2] = -tmp1i * s + tmp2i * c;
            tau[k] = 0.5 * Math.atan2(-vi[2], vr[0] + 1.0E-15);
            phi[k] = Math.atan2(vi[1], vr[1] + 1.0E-15);
            alpha[k] = Math.atan(Math.sqrt((vr[1] * vr[1] + vi[1] * vi[1]) / (vr[0] * vr[0] + vi[2] * vi[2])));
            if (!(psi[k] < -0.7853981633974483) && !(psi[k] > 0.7853981633974483)) continue;
            tau[k] = -tau[k];
            phi[k] = -phi[k];
        }
        double sum = EigenVal[0] + EigenVal[1] + EigenVal[2];
        double p1 = EigenVal[0] / sum;
        double p2 = EigenVal[1] / sum;
        double p3 = EigenVal[2] / sum;
        double psiMean = p1 * psi[0] + p2 * psi[1] + p3 * psi[2];
        double tauMean = p1 * tau[0] + p2 * tau[1] + p3 * tau[2];
        double alphaMean = p1 * alpha[0] + p2 * alpha[1] + p3 * alpha[2];
        double phiMean = p1 * phi[0] + p2 * phi[1] + p3 * phi[2];
        return new TDD(psiMean, tauMean, alphaMean, phiMean, psi, tau, alpha, phi);
    }

    public static class TDD {
        public final double psiMean;
        public final double tauMean;
        public final double alphaMean;
        public final double phiMean;
        public final double psi1;
        public final double tau1;
        public final double alpha1;
        public final double phi1;
        public final double psi2;
        public final double tau2;
        public final double alpha2;
        public final double phi2;
        public final double psi3;
        public final double tau3;
        public final double alpha3;
        public final double phi3;

        public TDD(double psiMean, double tauMean, double alphaMean, double phiMean, double[] psi, double[] tau, double[] alpha, double[] phi) {
            this.psiMean = psiMean;
            this.tauMean = tauMean;
            this.alphaMean = alphaMean;
            this.phiMean = phiMean;
            this.psi1 = psi[0];
            this.psi2 = psi[1];
            this.psi3 = psi[2];
            this.tau1 = tau[0];
            this.tau2 = tau[1];
            this.tau3 = tau[2];
            this.alpha1 = alpha[0];
            this.alpha2 = alpha[1];
            this.alpha3 = alpha[2];
            this.phi1 = phi[0];
            this.phi2 = phi[1];
            this.phi3 = phi[2];
        }
    }
}

