/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.QuadPolProcessor;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class Pauli
extends DecompositionBase
implements Decomposition,
QuadPolProcessor {
    public Pauli(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, windowSize, srcImageWidth, srcImageHeight);
    }

    @Override
    public String getSuffix() {
        return "_Pauli";
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"Pauli_r", "Pauli_g", "Pauli_b"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity_db");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("Pauli_r")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("Pauli_g")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("Pauli_b")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Sr = new double[2][2];
            double[][] Si = new double[2][2];
            double[][] Cr = new double[3][3];
            double[][] Ci = new double[3][3];
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            this.getQuadPolDataBuffer(op, bandList.srcBands, targetRectangle, this.sourceProductType, sourceTiles, dataBuffers);
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            double nodatavalue = bandList.srcBands[0].getNoDataValue();
            double re = 0.0;
            double im = 0.0;
            double v = 0.0;
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                srcIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    boolean isNoData;
                    if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
                        this.getComplexScatterMatrix(srcIndex.getIndex(x), dataBuffers, Sr, Si);
                        isNoData = this.isNoData(Sr, Si, nodatavalue);
                        for (DecompositionBase.TargetInfo target : targetInfo) {
                            if (isNoData) {
                                target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)nodatavalue);
                                continue;
                            }
                            if (target.colour == DecompositionBase.TargetBandColour.R) {
                                re = Sr[0][0] - Sr[1][1];
                                im = Si[0][0] - Si[1][1];
                            } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                                re = Sr[0][1] + Sr[1][0];
                                im = Si[0][1] + Si[1][0];
                            } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                                re = Sr[0][0] + Sr[1][1];
                                im = Si[0][0] + Si[1][1];
                            }
                            v = (re * re + im * im) / 2.0;
                            if (v < 1.0E-15) {
                                v = 1.0E-15;
                            }
                            v = 10.0 * Math.log10(v);
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)v);
                        }
                        continue;
                    }
                    if (this.sourceProductType == PolBandUtils.MATRIX.C3) {
                        this.getCovarianceMatrixC3(srcIndex.getIndex(x), dataBuffers, Cr, Ci);
                        isNoData = this.isNoData(Cr, Ci, nodatavalue);
                        for (DecompositionBase.TargetInfo target : targetInfo) {
                            if (isNoData) {
                                target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)nodatavalue);
                                continue;
                            }
                            if (target.colour == DecompositionBase.TargetBandColour.R) {
                                v = 0.5 * (Cr[0][0] - 2.0 * Cr[0][2] + Cr[2][2]);
                            } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                                v = Cr[1][1];
                            } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                                v = 0.5 * (Cr[0][0] + 2.0 * Cr[0][2] + Cr[2][2]);
                            }
                            if (v < 1.0E-15) {
                                v = 1.0E-15;
                            }
                            v = 10.0 * Math.log10(v);
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)v);
                        }
                        continue;
                    }
                    if (this.sourceProductType != PolBandUtils.MATRIX.T3) continue;
                    this.getCoherencyMatrixT3(srcIndex.getIndex(x), dataBuffers, Tr, Ti);
                    isNoData = this.isNoData(Tr, Ti, nodatavalue);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (isNoData) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)nodatavalue);
                            continue;
                        }
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            v = Tr[1][1];
                        } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                            v = Tr[2][2];
                        } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                            v = Tr[0][0];
                        }
                        if (v < 1.0E-15) {
                            v = 1.0E-15;
                        }
                        v = 10.0 * Math.log10(v);
                        target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)v);
                    }
                }
            }
        }
    }

    public static RGB getPauliDecomposition(double[][] Cr, double[][] Ci) {
        double r = 0.5 * (Cr[0][0] - 2.0 * Cr[0][2] + Cr[2][2]);
        double g = Cr[1][1];
        double b = 0.5 * (Cr[0][0] + 2.0 * Cr[0][2] + Cr[2][2]);
        return new RGB(r, g, b);
    }

    public static class RGB {
        public final double r;
        public final double g;
        public final double b;

        public RGB(double r, double g, double b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

