/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions;

import java.awt.Rectangle;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Tile;

public class DecompositionBase {
    protected PolBandUtils.PolSourceBand[] srcBandList;
    protected final PolBandUtils.MATRIX sourceProductType;
    protected final int sourceImageWidth;
    protected final int sourceImageHeight;
    protected final int windowSizeX;
    protected final int windowSizeY;
    protected final int halfWindowSizeX;
    protected final int halfWindowSizeY;

    public DecompositionBase(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSizeX, int windowSizeY, int srcImageWidth, int srcImageHeight) {
        this.srcBandList = srcBandList;
        this.sourceProductType = sourceProductType;
        this.windowSizeX = windowSizeX;
        this.windowSizeY = windowSizeY;
        this.sourceImageWidth = srcImageWidth;
        this.sourceImageHeight = srcImageHeight;
        this.halfWindowSizeX = windowSizeX / 2;
        this.halfWindowSizeY = windowSizeY / 2;
    }

    protected Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th) {
        int x0 = Math.max(0, tx0 - this.halfWindowSizeX);
        int y0 = Math.max(0, ty0 - this.halfWindowSizeY);
        int xMax = Math.min(tx0 + tw - 1 + this.halfWindowSizeX, this.sourceImageWidth - 1);
        int yMax = Math.min(ty0 + th - 1 + this.halfWindowSizeY, this.sourceImageHeight - 1);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    protected static double scaleDb(double p, double spanMin, double spanMax) {
        if (p < spanMin) {
            p = spanMin;
        }
        if (p > spanMax) {
            p = spanMax;
        }
        return 10.0 * Math.log10(p);
    }

    public static class TargetInfo {
        public final Tile tile;
        public final ProductData dataBuffer;
        public final TargetBandColour colour;

        public TargetInfo(Tile tile, TargetBandColour col) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            this.colour = col;
        }
    }

    public static class MinMax {
        public double min = 1.0E30;
        public double max = -this.min;
    }

    public static enum TargetBandColour {
        R,
        G,
        B;

    }
}

