/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.QuadPolProcessor;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.csa.rstb.polarimetric.gpf.decompositions.EigenDecomposition;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class Cloude
extends DecompositionBase
implements Decomposition,
QuadPolProcessor {
    public Cloude(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, windowSize, srcImageWidth, srcImageHeight);
    }

    @Override
    public String getSuffix() {
        return "_Cloude";
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"Cloude_dbl_r", "Cloude_vol_g", "Cloude_surf_b"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity_db");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("Cloude_dbl_r")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("Cloude_vol_g")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("Cloude_surf_b")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
            this.getQuadPolDataBuffer(op, bandList.srcBands, sourceRectangle, this.sourceProductType, sourceTiles, dataBuffers);
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            double nodatavalue = bandList.srcBands[0].getNoDataValue();
            double[][] EigenVectRe = new double[3][3];
            double[][] EigenVectIm = new double[3][3];
            double[] EigenVal = new double[3];
            double v = 0.0;
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                srcIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    boolean isNoData = this.isNoData(dataBuffers, srcIndex.getIndex(x), nodatavalue);
                    if (isNoData) {
                        for (DecompositionBase.TargetInfo target : targetInfo) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)nodatavalue);
                        }
                        continue;
                    }
                    this.getMeanCoherencyMatrix(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                    EigenDecomposition.eigenDecomposition(3, Tr, Ti, EigenVectRe, EigenVectIm, EigenVal);
                    double t11 = EigenVal[0] * (EigenVectRe[0][0] * EigenVectRe[0][0] + EigenVectIm[0][0] * EigenVectIm[0][0]);
                    double t22 = EigenVal[0] * (EigenVectRe[1][0] * EigenVectRe[1][0] + EigenVectIm[1][0] * EigenVectIm[1][0]);
                    double t33 = EigenVal[0] * (EigenVectRe[2][0] * EigenVectRe[2][0] + EigenVectIm[2][0] * EigenVectIm[2][0]);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            v = t22;
                        } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                            v = t33;
                        } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                            v = t11;
                        }
                        if (v < 1.0E-15) {
                            v = 1.0E-15;
                        }
                        v = 10.0 * Math.log10(v);
                        target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)v);
                    }
                }
            }
        }
    }

    public static RGB getCloudeDecomposition(double[][] Tr, double[][] Ti) {
        double[][] EigenVectRe = new double[3][3];
        double[][] EigenVectIm = new double[3][3];
        double[] EigenVal = new double[3];
        EigenDecomposition.eigenDecomposition(3, Tr, Ti, EigenVectRe, EigenVectIm, EigenVal);
        double b = EigenVal[0] * (EigenVectRe[0][0] * EigenVectRe[0][0] + EigenVectIm[0][0] * EigenVectIm[0][0]);
        double r = EigenVal[0] * (EigenVectRe[1][0] * EigenVectRe[1][0] + EigenVectIm[1][0] * EigenVectIm[1][0]);
        double g = EigenVal[0] * (EigenVectRe[2][0] * EigenVectRe[2][0] + EigenVectIm[2][0] * EigenVectIm[2][0]);
        return new RGB(r, g, b);
    }

    public static class RGB {
        public final double r;
        public final double g;
        public final double b;

        public RGB(double r, double g, double b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

