/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import org.apache.commons.math3.util.FastMath;

public class StokesParameters {
    public double DegreeOfPolarization;
    public double DegreeOfDepolarization;
    public double DegreeOfCircularity;
    public double DegreeOfEllipticity;
    public double circularPolarizationRatio;
    public double linearPolarizationRatio;
    public double RelativePhase;
    public double Alphas;
    public double Conformity;
    public double PhasePhi;

    public static StokesParameters computeStokesParameters(double[] g, String compactMode, boolean useRCMConvention) {
        StokesParameters parameters = new StokesParameters();
        parameters.DegreeOfPolarization = Math.sqrt(g[1] * g[1] + g[2] * g[2] + g[3] * g[3]) / g[0];
        parameters.DegreeOfDepolarization = 1.0 - parameters.DegreeOfPolarization;
        if (compactMode.equals("Left Circular Hybrid Mode") && !useRCMConvention || compactMode.equals("Right Circular Hybrid Mode") && useRCMConvention) {
            parameters.DegreeOfCircularity = -g[3] / (g[0] * parameters.DegreeOfPolarization);
            parameters.circularPolarizationRatio = (g[0] - g[3]) / (g[0] + g[3]);
            parameters.RelativePhase = Math.atan2(-g[3], g[2]);
            parameters.Alphas = 0.5 * Math.atan2(Math.sqrt(g[1] * g[1] + g[2] * g[2]), g[3]);
            parameters.Conformity = g[3] / g[0];
            parameters.PhasePhi = Math.atan2(g[2], g[1]);
        } else {
            parameters.DegreeOfCircularity = g[3] / (g[0] * parameters.DegreeOfPolarization);
            parameters.circularPolarizationRatio = (g[0] + g[3]) / (g[0] - g[3]);
            parameters.RelativePhase = Math.atan2(g[3], g[2]);
            parameters.Alphas = 0.5 * Math.atan2(Math.sqrt(g[1] * g[1] + g[2] * g[2]), -g[3]);
            parameters.Conformity = -g[3] / g[0];
            parameters.PhasePhi = Math.atan2(-g[2], g[1]);
        }
        parameters.DegreeOfEllipticity = FastMath.tan((double)(0.5 * FastMath.asin((double)parameters.DegreeOfCircularity)));
        parameters.linearPolarizationRatio = (g[0] - g[1]) / (g[0] + g[1]);
        return parameters;
    }

    public static void computeCompactPolStokesVector(double[][] Cr, double[][] Ci, double[] g) {
        g[0] = Cr[0][0] + Cr[1][1];
        g[1] = Cr[0][0] - Cr[1][1];
        g[2] = 2.0 * Cr[0][1];
        g[3] = -2.0 * Ci[0][1];
    }

    public static void computeCompactPolStokesVector(double[] kr, double[] ki, double[] g) {
        g[0] = kr[0] * kr[0] + ki[0] * ki[0] + kr[1] * kr[1] + ki[1] * ki[1];
        g[1] = kr[0] * kr[0] + ki[0] * ki[0] - kr[1] * kr[1] - ki[1] * ki[1];
        g[2] = 2.0 * (kr[0] * kr[1] + ki[0] * ki[1]);
        g[3] = -2.0 * (ki[0] * kr[0] - kr[0] * ki[1]);
    }

    public static double computeDegreeOfPolarization(double[] g) {
        if (g[0] == 0.0) {
            return -1.0;
        }
        return Math.sqrt(g[1] * g[1] + g[2] * g[2] + g[3] * g[3]) / g[0];
    }
}

