/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import Jama.Matrix;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.apache.commons.math3.util.FastMath;
import org.csa.rstb.polarimetric.gpf.PolarimetricProcessor;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.eo.Constants;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public interface QuadPolProcessor
extends PolarimetricProcessor {
    default public void getQuadPolDataBuffer(Operator op, Band[] srcBands, Rectangle sourceRectangle, PolBandUtils.MATRIX sourceProductType, Tile[] sourceTiles, ProductData[] dataBuffers) {
        for (Band band : srcBands) {
            String bandName = band.getName();
            if (sourceProductType == PolBandUtils.MATRIX.FULL) {
                if (bandName.contains("i_HH")) {
                    sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[0] = sourceTiles[0].getDataBuffer();
                    continue;
                }
                if (bandName.contains("q_HH")) {
                    sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[1] = sourceTiles[1].getDataBuffer();
                    continue;
                }
                if (bandName.contains("i_HV")) {
                    sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[2] = sourceTiles[2].getDataBuffer();
                    continue;
                }
                if (bandName.contains("q_HV")) {
                    sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[3] = sourceTiles[3].getDataBuffer();
                    continue;
                }
                if (bandName.contains("i_VH")) {
                    sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[4] = sourceTiles[4].getDataBuffer();
                    continue;
                }
                if (bandName.contains("q_VH")) {
                    sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[5] = sourceTiles[5].getDataBuffer();
                    continue;
                }
                if (bandName.contains("i_VV")) {
                    sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[6] = sourceTiles[6].getDataBuffer();
                    continue;
                }
                if (!bandName.contains("q_VV")) continue;
                sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[7] = sourceTiles[7].getDataBuffer();
                continue;
            }
            if (sourceProductType == PolBandUtils.MATRIX.C3) {
                if (bandName.contains("C11")) {
                    sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[0] = sourceTiles[0].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C12_real")) {
                    sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[1] = sourceTiles[1].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C12_imag")) {
                    sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[2] = sourceTiles[2].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C13_real")) {
                    sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[3] = sourceTiles[3].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C13_imag")) {
                    sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[4] = sourceTiles[4].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C22")) {
                    sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[5] = sourceTiles[5].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C23_real")) {
                    sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[6] = sourceTiles[6].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C23_imag")) {
                    sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[7] = sourceTiles[7].getDataBuffer();
                    continue;
                }
                if (!bandName.contains("C33")) continue;
                sourceTiles[8] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[8] = sourceTiles[8].getDataBuffer();
                continue;
            }
            if (sourceProductType == PolBandUtils.MATRIX.T3) {
                if (bandName.contains("T11")) {
                    sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[0] = sourceTiles[0].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T12_real")) {
                    sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[1] = sourceTiles[1].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T12_imag")) {
                    sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[2] = sourceTiles[2].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T13_real")) {
                    sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[3] = sourceTiles[3].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T13_imag")) {
                    sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[4] = sourceTiles[4].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T22")) {
                    sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[5] = sourceTiles[5].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T23_real")) {
                    sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[6] = sourceTiles[6].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T23_imag")) {
                    sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[7] = sourceTiles[7].getDataBuffer();
                    continue;
                }
                if (!bandName.contains("T33")) continue;
                sourceTiles[8] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[8] = sourceTiles[8].getDataBuffer();
                continue;
            }
            if (sourceProductType == PolBandUtils.MATRIX.C4) {
                if (bandName.contains("C11")) {
                    sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[0] = sourceTiles[0].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C12_real")) {
                    sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[1] = sourceTiles[1].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C12_imag")) {
                    sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[2] = sourceTiles[2].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C13_real")) {
                    sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[3] = sourceTiles[3].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C13_imag")) {
                    sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[4] = sourceTiles[4].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C14_real")) {
                    sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[5] = sourceTiles[5].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C14_imag")) {
                    sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[6] = sourceTiles[6].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C22")) {
                    sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[7] = sourceTiles[7].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C23_real")) {
                    sourceTiles[8] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[8] = sourceTiles[8].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C23_imag")) {
                    sourceTiles[9] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[9] = sourceTiles[9].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C24_real")) {
                    sourceTiles[10] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[10] = sourceTiles[10].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C24_imag")) {
                    sourceTiles[11] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[11] = sourceTiles[11].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C33")) {
                    sourceTiles[12] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[12] = sourceTiles[12].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C34_real")) {
                    sourceTiles[13] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[13] = sourceTiles[13].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C34_imag")) {
                    sourceTiles[14] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[14] = sourceTiles[14].getDataBuffer();
                    continue;
                }
                if (!bandName.contains("C44")) continue;
                sourceTiles[15] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[15] = sourceTiles[15].getDataBuffer();
                continue;
            }
            if (sourceProductType != PolBandUtils.MATRIX.T4) continue;
            if (bandName.contains("T11")) {
                sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[0] = sourceTiles[0].getDataBuffer();
                continue;
            }
            if (bandName.contains("T12_real")) {
                sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[1] = sourceTiles[1].getDataBuffer();
                continue;
            }
            if (bandName.contains("T12_imag")) {
                sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[2] = sourceTiles[2].getDataBuffer();
                continue;
            }
            if (bandName.contains("T13_real")) {
                sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[3] = sourceTiles[3].getDataBuffer();
                continue;
            }
            if (bandName.contains("T13_imag")) {
                sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[4] = sourceTiles[4].getDataBuffer();
                continue;
            }
            if (bandName.contains("T14_real")) {
                sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[5] = sourceTiles[5].getDataBuffer();
                continue;
            }
            if (bandName.contains("T14_imag")) {
                sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[6] = sourceTiles[6].getDataBuffer();
                continue;
            }
            if (bandName.contains("T22")) {
                sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[7] = sourceTiles[7].getDataBuffer();
                continue;
            }
            if (bandName.contains("T23_real")) {
                sourceTiles[8] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[8] = sourceTiles[8].getDataBuffer();
                continue;
            }
            if (bandName.contains("T23_imag")) {
                sourceTiles[9] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[9] = sourceTiles[9].getDataBuffer();
                continue;
            }
            if (bandName.contains("T24_real")) {
                sourceTiles[10] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[10] = sourceTiles[10].getDataBuffer();
                continue;
            }
            if (bandName.contains("T24_imag")) {
                sourceTiles[11] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[11] = sourceTiles[11].getDataBuffer();
                continue;
            }
            if (bandName.contains("T33")) {
                sourceTiles[12] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[12] = sourceTiles[12].getDataBuffer();
                continue;
            }
            if (bandName.contains("T34_real")) {
                sourceTiles[13] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[13] = sourceTiles[13].getDataBuffer();
                continue;
            }
            if (bandName.contains("T34_imag")) {
                sourceTiles[14] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[14] = sourceTiles[14].getDataBuffer();
                continue;
            }
            if (!bandName.contains("T44")) continue;
            sourceTiles[15] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
            dataBuffers[15] = sourceTiles[15].getDataBuffer();
        }
    }

    default public void getComplexScatterMatrix(int index, ProductData[] dataBuffers, double[][] scatterMatrix_i, double[][] scatterMatrix_q) {
        scatterMatrix_i[0][0] = dataBuffers[0].getElemDoubleAt(index);
        scatterMatrix_q[0][0] = dataBuffers[1].getElemDoubleAt(index);
        scatterMatrix_i[0][1] = dataBuffers[2].getElemDoubleAt(index);
        scatterMatrix_q[0][1] = dataBuffers[3].getElemDoubleAt(index);
        scatterMatrix_i[1][0] = dataBuffers[4].getElemDoubleAt(index);
        scatterMatrix_q[1][0] = dataBuffers[5].getElemDoubleAt(index);
        scatterMatrix_i[1][1] = dataBuffers[6].getElemDoubleAt(index);
        scatterMatrix_q[1][1] = dataBuffers[7].getElemDoubleAt(index);
    }

    default public void getCovarianceMatrixC3(int index, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        Cr[0][0] = dataBuffers[0].getElemDoubleAt(index);
        Ci[0][0] = 0.0;
        Cr[0][1] = dataBuffers[1].getElemDoubleAt(index);
        Ci[0][1] = dataBuffers[2].getElemDoubleAt(index);
        Cr[0][2] = dataBuffers[3].getElemDoubleAt(index);
        Ci[0][2] = dataBuffers[4].getElemDoubleAt(index);
        Cr[1][1] = dataBuffers[5].getElemDoubleAt(index);
        Ci[1][1] = 0.0;
        Cr[1][2] = dataBuffers[6].getElemDoubleAt(index);
        Ci[1][2] = dataBuffers[7].getElemDoubleAt(index);
        Cr[2][2] = dataBuffers[8].getElemDoubleAt(index);
        Ci[2][2] = 0.0;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
        Cr[2][0] = Cr[0][2];
        Ci[2][0] = -Ci[0][2];
        Cr[2][1] = Cr[1][2];
        Ci[2][1] = -Ci[1][2];
    }

    default public void getCovarianceMatrixC4(int index, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        Cr[0][0] = dataBuffers[0].getElemDoubleAt(index);
        Ci[0][0] = 0.0;
        Cr[0][1] = dataBuffers[1].getElemDoubleAt(index);
        Ci[0][1] = dataBuffers[2].getElemDoubleAt(index);
        Cr[0][2] = dataBuffers[3].getElemDoubleAt(index);
        Ci[0][2] = dataBuffers[4].getElemDoubleAt(index);
        Cr[0][3] = dataBuffers[5].getElemDoubleAt(index);
        Ci[0][3] = dataBuffers[6].getElemDoubleAt(index);
        Cr[1][1] = dataBuffers[7].getElemDoubleAt(index);
        Ci[1][1] = 0.0;
        Cr[1][2] = dataBuffers[8].getElemDoubleAt(index);
        Ci[1][2] = dataBuffers[9].getElemDoubleAt(index);
        Cr[1][3] = dataBuffers[10].getElemDoubleAt(index);
        Ci[1][3] = dataBuffers[11].getElemDoubleAt(index);
        Cr[2][2] = dataBuffers[12].getElemDoubleAt(index);
        Ci[2][2] = 0.0;
        Cr[2][3] = dataBuffers[13].getElemDoubleAt(index);
        Ci[2][3] = dataBuffers[14].getElemDoubleAt(index);
        Cr[3][3] = dataBuffers[15].getElemDoubleAt(index);
        Ci[3][3] = 0.0;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
        Cr[2][0] = Cr[0][2];
        Ci[2][0] = -Ci[0][2];
        Cr[2][1] = Cr[1][2];
        Ci[2][1] = -Ci[1][2];
        Cr[3][0] = Cr[0][3];
        Ci[3][0] = -Ci[0][3];
        Cr[3][1] = Cr[1][3];
        Ci[3][1] = -Ci[1][3];
        Cr[3][2] = Cr[2][3];
        Ci[3][2] = -Ci[2][3];
    }

    default public void getCoherencyMatrixT3(int index, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        Tr[0][0] = dataBuffers[0].getElemDoubleAt(index);
        Ti[0][0] = 0.0;
        Tr[0][1] = dataBuffers[1].getElemDoubleAt(index);
        Ti[0][1] = dataBuffers[2].getElemDoubleAt(index);
        Tr[0][2] = dataBuffers[3].getElemDoubleAt(index);
        Ti[0][2] = dataBuffers[4].getElemDoubleAt(index);
        Tr[1][1] = dataBuffers[5].getElemDoubleAt(index);
        Ti[1][1] = 0.0;
        Tr[1][2] = dataBuffers[6].getElemDoubleAt(index);
        Ti[1][2] = dataBuffers[7].getElemDoubleAt(index);
        Tr[2][2] = dataBuffers[8].getElemDoubleAt(index);
        Ti[2][2] = 0.0;
        Tr[1][0] = Tr[0][1];
        Ti[1][0] = -Ti[0][1];
        Tr[2][0] = Tr[0][2];
        Ti[2][0] = -Ti[0][2];
        Tr[2][1] = Tr[1][2];
        Ti[2][1] = -Ti[1][2];
    }

    default public void getCoherencyMatrixT4(int index, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        Tr[0][0] = dataBuffers[0].getElemDoubleAt(index);
        Ti[0][0] = 0.0;
        Tr[0][1] = dataBuffers[1].getElemDoubleAt(index);
        Ti[0][1] = dataBuffers[2].getElemDoubleAt(index);
        Tr[0][2] = dataBuffers[3].getElemDoubleAt(index);
        Ti[0][2] = dataBuffers[4].getElemDoubleAt(index);
        Tr[0][3] = dataBuffers[5].getElemDoubleAt(index);
        Ti[0][3] = dataBuffers[6].getElemDoubleAt(index);
        Tr[1][1] = dataBuffers[7].getElemDoubleAt(index);
        Ti[1][1] = 0.0;
        Tr[1][2] = dataBuffers[8].getElemDoubleAt(index);
        Ti[1][2] = dataBuffers[9].getElemDoubleAt(index);
        Tr[1][3] = dataBuffers[10].getElemDoubleAt(index);
        Ti[1][3] = dataBuffers[11].getElemDoubleAt(index);
        Tr[2][2] = dataBuffers[12].getElemDoubleAt(index);
        Ti[2][2] = 0.0;
        Tr[2][3] = dataBuffers[13].getElemDoubleAt(index);
        Ti[2][3] = dataBuffers[14].getElemDoubleAt(index);
        Tr[3][3] = dataBuffers[15].getElemDoubleAt(index);
        Ti[3][3] = 0.0;
        Tr[1][0] = Tr[0][1];
        Ti[1][0] = -Ti[0][1];
        Tr[2][0] = Tr[0][2];
        Ti[2][0] = -Ti[0][2];
        Tr[2][1] = Tr[1][2];
        Ti[2][1] = -Ti[1][2];
        Tr[3][0] = Tr[0][3];
        Ti[3][0] = -Ti[0][3];
        Tr[3][1] = Tr[1][3];
        Ti[3][1] = -Ti[1][3];
        Tr[3][2] = Tr[2][3];
        Ti[3][2] = -Ti[2][3];
    }

    default public void computeCovarianceMatrixC3(double[][] scatterRe, double[][] scatterIm, double[][] Cr, double[][] Ci) {
        double k1r = scatterRe[0][0];
        double k1i = scatterIm[0][0];
        double sHVr = scatterRe[0][1];
        double sHVi = scatterIm[0][1];
        double sVHr = scatterRe[1][0];
        double sVHi = scatterIm[1][0];
        double k3r = scatterRe[1][1];
        double k3i = scatterIm[1][1];
        double k2r = (sHVr + sVHr) / Constants.sqrt2;
        double k2i = (sHVi + sVHi) / Constants.sqrt2;
        Cr[0][0] = k1r * k1r + k1i * k1i;
        Cr[0][1] = k1r * k2r + k1i * k2i;
        Ci[0][1] = k1i * k2r - k1r * k2i;
        Cr[0][2] = k1r * k3r + k1i * k3i;
        Ci[0][2] = k1i * k3r - k1r * k3i;
        Cr[1][1] = k2r * k2r + k2i * k2i;
        Cr[1][2] = k2r * k3r + k2i * k3i;
        Ci[1][2] = k2i * k3r - k2r * k3i;
        Cr[2][2] = k3r * k3r + k3i * k3i;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
        Cr[2][0] = Cr[0][2];
        Ci[2][0] = -Ci[0][2];
        Cr[2][1] = Cr[1][2];
        Ci[2][1] = -Ci[1][2];
    }

    default public void computeCovarianceMatrixC4(double[][] scatterRe, double[][] scatterIm, double[][] Cr, double[][] Ci) {
        double k1r = scatterRe[0][0];
        double k1i = scatterIm[0][0];
        double k2r = scatterRe[0][1];
        double k2i = scatterIm[0][1];
        double k3r = scatterRe[1][0];
        double k3i = scatterIm[1][0];
        double k4r = scatterRe[1][1];
        double k4i = scatterIm[1][1];
        Cr[0][0] = k1r * k1r + k1i * k1i;
        Ci[0][0] = 0.0;
        Cr[0][1] = k1r * k2r + k1i * k2i;
        Ci[0][1] = k1i * k2r - k1r * k2i;
        Cr[0][2] = k1r * k3r + k1i * k3i;
        Ci[0][2] = k1i * k3r - k1r * k3i;
        Cr[0][3] = k1r * k4r + k1i * k4i;
        Ci[0][3] = k1i * k4r - k1r * k4i;
        Cr[1][1] = k2r * k2r + k2i * k2i;
        Ci[1][1] = 0.0;
        Cr[1][2] = k2r * k3r + k2i * k3i;
        Ci[1][2] = k2i * k3r - k2r * k3i;
        Cr[1][3] = k2r * k4r + k2i * k4i;
        Ci[1][3] = k2i * k4r - k2r * k4i;
        Cr[2][2] = k3r * k3r + k3i * k3i;
        Ci[2][2] = 0.0;
        Cr[2][3] = k3r * k4r + k3i * k4i;
        Ci[2][3] = k3i * k4r - k3r * k4i;
        Cr[3][3] = k4r * k4r + k4i * k4i;
        Ci[3][3] = 0.0;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
        Cr[2][0] = Cr[0][2];
        Ci[2][0] = -Ci[0][2];
        Cr[2][1] = Cr[1][2];
        Ci[2][1] = -Ci[1][2];
        Cr[3][0] = Cr[0][3];
        Ci[3][0] = -Ci[0][3];
        Cr[3][1] = Cr[1][3];
        Ci[3][1] = -Ci[1][3];
        Cr[3][2] = Cr[2][3];
        Ci[3][2] = -Ci[2][3];
    }

    default public void computeCoherencyMatrixT3(double[][] scatterRe, double[][] scatterIm, double[][] Tr, double[][] Ti) {
        double sHHr = scatterRe[0][0];
        double sHHi = scatterIm[0][0];
        double sHVr = scatterRe[0][1];
        double sHVi = scatterIm[0][1];
        double sVHr = scatterRe[1][0];
        double sVHi = scatterIm[1][0];
        double sVVr = scatterRe[1][1];
        double sVVi = scatterIm[1][1];
        double k1r = (sHHr + sVVr) / Constants.sqrt2;
        double k1i = (sHHi + sVVi) / Constants.sqrt2;
        double k2r = (sHHr - sVVr) / Constants.sqrt2;
        double k2i = (sHHi - sVVi) / Constants.sqrt2;
        double k3r = (sHVr + sVHr) / Constants.sqrt2;
        double k3i = (sHVi + sVHi) / Constants.sqrt2;
        Tr[0][0] = k1r * k1r + k1i * k1i;
        Ti[0][0] = 0.0;
        Tr[0][1] = k1r * k2r + k1i * k2i;
        Ti[0][1] = k1i * k2r - k1r * k2i;
        Tr[0][2] = k1r * k3r + k1i * k3i;
        Ti[0][2] = k1i * k3r - k1r * k3i;
        Tr[1][1] = k2r * k2r + k2i * k2i;
        Ti[1][1] = 0.0;
        Tr[1][2] = k2r * k3r + k2i * k3i;
        Ti[1][2] = k2i * k3r - k2r * k3i;
        Tr[2][2] = k3r * k3r + k3i * k3i;
        Ti[2][2] = 0.0;
        Tr[1][0] = Tr[0][1];
        Ti[1][0] = -Ti[0][1];
        Tr[2][0] = Tr[0][2];
        Ti[2][0] = -Ti[0][2];
        Tr[2][1] = Tr[1][2];
        Ti[2][1] = -Ti[1][2];
    }

    default public void computeCoherencyMatrixT4(double[][] scatterRe, double[][] scatterIm, double[][] Tr, double[][] Ti) {
        double sHHr = scatterRe[0][0];
        double sHHi = scatterIm[0][0];
        double sHVr = scatterRe[0][1];
        double sHVi = scatterIm[0][1];
        double sVHr = scatterRe[1][0];
        double sVHi = scatterIm[1][0];
        double sVVr = scatterRe[1][1];
        double sVVi = scatterIm[1][1];
        double k1r = (sHHr + sVVr) / Constants.sqrt2;
        double k1i = (sHHi + sVVi) / Constants.sqrt2;
        double k2r = (sHHr - sVVr) / Constants.sqrt2;
        double k2i = (sHHi - sVVi) / Constants.sqrt2;
        double k3r = (sHVr + sVHr) / Constants.sqrt2;
        double k3i = (sHVi + sVHi) / Constants.sqrt2;
        double k4r = (sVHi - sHVi) / Constants.sqrt2;
        double k4i = (sHVr - sVHr) / Constants.sqrt2;
        Tr[0][0] = k1r * k1r + k1i * k1i;
        Ti[0][0] = 0.0;
        Tr[0][1] = k1r * k2r + k1i * k2i;
        Ti[0][1] = k1i * k2r - k1r * k2i;
        Tr[0][2] = k1r * k3r + k1i * k3i;
        Ti[0][2] = k1i * k3r - k1r * k3i;
        Tr[0][3] = k1r * k4r + k1i * k4i;
        Ti[0][3] = k1i * k4r - k1r * k4i;
        Tr[1][1] = k2r * k2r + k2i * k2i;
        Ti[1][1] = 0.0;
        Tr[1][2] = k2r * k3r + k2i * k3i;
        Ti[1][2] = k2i * k3r - k2r * k3i;
        Tr[1][3] = k2r * k4r + k2i * k4i;
        Ti[1][3] = k2i * k4r - k2r * k4i;
        Tr[2][2] = k3r * k3r + k3i * k3i;
        Ti[2][2] = 0.0;
        Tr[2][3] = k3r * k4r + k3i * k4i;
        Ti[2][3] = k3i * k4r - k3r * k4i;
        Tr[3][3] = k4r * k4r + k4i * k4i;
        Ti[3][3] = 0.0;
        Tr[1][0] = Tr[0][1];
        Ti[1][0] = -Ti[0][1];
        Tr[2][0] = Tr[0][2];
        Ti[2][0] = -Ti[0][2];
        Tr[2][1] = Tr[1][2];
        Ti[2][1] = -Ti[1][2];
        Tr[3][0] = Tr[0][3];
        Ti[3][0] = -Ti[0][3];
        Tr[3][1] = Tr[1][3];
        Ti[3][1] = -Ti[1][3];
        Tr[3][2] = Tr[2][3];
        Ti[3][2] = -Ti[2][3];
    }

    default public void c4ToT4(double[][] c4Re, double[][] c4Im, double[][] t4Re, double[][] t4Im) {
        t4Re[0][0] = 0.5 * (c4Re[0][0] + 2.0 * c4Re[0][3] + c4Re[3][3]);
        t4Im[0][0] = 0.5 * (c4Im[0][0] + c4Im[3][3]);
        t4Re[0][1] = 0.5 * (c4Re[0][0] - c4Re[3][3]);
        t4Im[0][1] = 0.5 * (c4Im[0][0] - 2.0 * c4Im[0][3] - c4Im[3][3]);
        t4Re[0][2] = 0.5 * (c4Re[0][1] + c4Re[1][3] + c4Re[0][2] + c4Re[2][3]);
        t4Im[0][2] = 0.5 * (c4Im[0][1] - c4Im[1][3] + c4Im[0][2] - c4Im[2][3]);
        t4Re[0][3] = 0.5 * (c4Im[0][1] - c4Im[1][3] - c4Im[0][2] + c4Im[2][3]);
        t4Im[0][3] = 0.5 * (-c4Re[0][1] - c4Re[1][3] + c4Re[0][2] + c4Re[2][3]);
        t4Re[1][0] = t4Re[0][1];
        t4Im[1][0] = -t4Im[0][1];
        t4Re[1][1] = 0.5 * (c4Re[0][0] - 2.0 * c4Re[0][3] + c4Re[3][3]);
        t4Im[1][1] = 0.5 * (c4Im[0][0] + c4Im[3][3]);
        t4Re[1][2] = 0.5 * (c4Re[0][1] - c4Re[1][3] + c4Re[0][2] - c4Re[2][3]);
        t4Im[1][2] = 0.5 * (c4Im[0][1] + c4Im[1][3] + c4Im[0][2] + c4Im[2][3]);
        t4Re[1][3] = 0.5 * (c4Im[0][1] + c4Im[1][3] - c4Im[0][2] - c4Im[2][3]);
        t4Im[1][3] = 0.5 * (-c4Re[0][1] + c4Re[1][3] + c4Re[0][2] - c4Re[2][3]);
        t4Re[2][0] = t4Re[0][2];
        t4Im[2][0] = -t4Im[0][2];
        t4Re[2][1] = t4Re[1][2];
        t4Im[2][1] = -t4Im[1][2];
        t4Re[2][2] = 0.5 * (c4Re[1][1] + 2.0 * c4Re[1][2] + c4Re[2][2]);
        t4Im[2][2] = 0.5 * (c4Im[1][1] + c4Im[2][2]);
        t4Re[2][3] = 0.5 * (c4Im[1][1] - 2.0 * c4Im[1][2] - c4Im[2][2]);
        t4Im[2][3] = 0.5 * (-c4Re[1][1] + c4Re[2][2]);
        t4Re[3][0] = t4Re[0][3];
        t4Im[3][0] = -t4Im[0][3];
        t4Re[3][1] = t4Re[1][3];
        t4Im[3][1] = -t4Im[1][3];
        t4Re[3][2] = t4Re[2][3];
        t4Im[3][2] = -t4Im[2][3];
        t4Re[3][3] = 0.5 * (c4Re[1][1] - 2.0 * c4Re[1][2] + c4Re[2][2]);
        t4Im[3][3] = 0.5 * (c4Im[1][1] + c4Im[2][2]);
    }

    default public void t4ToC4(double[][] t4Re, double[][] t4Im, double[][] c4Re, double[][] c4Im) {
        c4Re[0][0] = 0.5 * (t4Re[0][0] + t4Re[0][1] + t4Re[1][0] + t4Re[1][1]);
        c4Im[0][0] = 0.0;
        c4Re[0][1] = 0.5 * (t4Re[0][2] - t4Im[0][3] + t4Re[1][2] - t4Im[1][3]);
        c4Im[0][1] = 0.5 * (t4Im[0][2] + t4Re[0][3] + t4Im[1][2] + t4Re[1][3]);
        c4Re[0][2] = 0.5 * (t4Re[0][2] + t4Im[0][3] + t4Re[1][2] + t4Im[1][3]);
        c4Im[0][2] = 0.5 * (t4Im[0][2] - t4Re[0][3] + t4Im[1][2] - t4Re[1][3]);
        c4Re[0][3] = 0.5 * (t4Re[0][0] - t4Re[0][1] + t4Re[1][0] - t4Re[1][1]);
        c4Im[0][3] = 0.5 * (t4Im[0][0] - t4Im[0][1] + t4Im[1][0] - t4Im[1][1]);
        c4Re[1][0] = c4Re[0][1];
        c4Im[1][0] = -c4Im[0][1];
        c4Re[1][1] = 0.5 * (t4Re[2][2] - t4Im[2][3] + t4Im[3][2] + t4Re[3][3]);
        c4Im[1][1] = 0.0;
        c4Re[1][2] = 0.5 * (t4Re[2][2] + t4Im[2][3] + t4Im[3][2] - t4Re[3][3]);
        c4Im[1][2] = 0.5 * (t4Im[2][2] - t4Re[2][3] - t4Re[3][2] - t4Im[3][3]);
        c4Re[1][3] = 0.5 * (t4Re[2][0] - t4Re[2][1] + t4Im[3][0] - t4Im[3][1]);
        c4Im[1][3] = 0.5 * (t4Im[2][0] - t4Im[2][1] - t4Re[3][0] + t4Re[3][1]);
        c4Re[2][0] = c4Re[0][2];
        c4Im[2][0] = -c4Im[0][2];
        c4Re[2][1] = c4Re[1][2];
        c4Im[2][1] = -c4Im[1][2];
        c4Re[2][2] = 0.5 * (t4Re[2][2] + t4Im[2][3] - t4Im[3][2] + t4Re[3][3]);
        c4Im[2][2] = 0.0;
        c4Re[2][3] = 0.5 * (t4Re[2][0] - t4Re[2][1] - t4Im[3][0] + t4Im[3][1]);
        c4Im[2][3] = 0.5 * (t4Im[2][0] - t4Im[2][1] + t4Re[3][0] - t4Re[3][1]);
        c4Re[3][0] = c4Re[0][3];
        c4Im[3][0] = -c4Im[0][3];
        c4Re[3][1] = c4Re[1][3];
        c4Im[3][1] = -c4Im[1][3];
        c4Re[3][2] = c4Re[2][3];
        c4Im[3][2] = -c4Im[2][3];
        c4Re[3][3] = 0.5 * (t4Re[0][0] - t4Re[0][1] - t4Re[1][0] + t4Re[1][1]);
        c4Im[3][3] = 0.0;
    }

    default public void c3ToT3(double[][] c3Re, double[][] c3Im, double[][] t3Re, double[][] t3Im) {
        t3Re[0][0] = (c3Re[0][0] + 2.0 * c3Re[0][2] + c3Re[2][2]) / 2.0;
        t3Im[0][0] = 0.0;
        t3Re[0][1] = (c3Re[0][0] - c3Re[2][2]) / 2.0;
        t3Im[0][1] = -c3Im[0][2];
        t3Re[0][2] = (c3Re[0][1] + c3Re[1][2]) / Constants.sqrt2;
        t3Im[0][2] = (c3Im[0][1] - c3Im[1][2]) / Constants.sqrt2;
        t3Re[1][0] = t3Re[0][1];
        t3Im[1][0] = -t3Im[0][1];
        t3Re[1][1] = (c3Re[0][0] - 2.0 * c3Re[0][2] + c3Re[2][2]) / 2.0;
        t3Im[1][1] = 0.0;
        t3Re[1][2] = (c3Re[0][1] - c3Re[1][2]) / Constants.sqrt2;
        t3Im[1][2] = (c3Im[0][1] + c3Im[1][2]) / Constants.sqrt2;
        t3Re[2][0] = t3Re[0][2];
        t3Im[2][0] = -t3Im[0][2];
        t3Re[2][1] = t3Re[1][2];
        t3Im[2][1] = -t3Im[1][2];
        t3Re[2][2] = c3Re[1][1];
        t3Im[2][2] = 0.0;
    }

    default public void t3ToC3(double[][] t3Re, double[][] t3Im, double[][] c3Re, double[][] c3Im) {
        c3Re[0][0] = 0.5 * (t3Re[0][0] + t3Re[0][1] + t3Re[1][0] + t3Re[1][1]);
        c3Im[0][0] = 0.0;
        c3Re[0][1] = (t3Re[0][2] + t3Re[1][2]) / Constants.sqrt2;
        c3Im[0][1] = (t3Im[0][2] + t3Im[1][2]) / Constants.sqrt2;
        c3Re[0][2] = 0.5 * (t3Re[0][0] - t3Re[0][1] + t3Re[1][0] - t3Re[1][1]);
        c3Im[0][2] = 0.5 * (t3Im[0][0] - t3Im[0][1] + t3Im[1][0] - t3Im[1][1]);
        c3Re[1][0] = c3Re[0][1];
        c3Im[1][0] = -c3Im[0][1];
        c3Re[1][1] = t3Re[2][2];
        c3Im[1][1] = 0.0;
        c3Re[1][2] = (t3Re[2][0] - t3Re[2][1]) / Constants.sqrt2;
        c3Im[1][2] = (t3Im[2][0] - t3Im[2][1]) / Constants.sqrt2;
        c3Re[2][0] = c3Re[0][2];
        c3Im[2][0] = -c3Im[0][2];
        c3Re[2][1] = c3Re[1][2];
        c3Im[2][1] = -c3Im[1][2];
        c3Re[2][2] = 0.5 * (t3Re[0][0] - t3Re[0][1] - t3Re[1][0] + t3Re[1][1]);
        c3Im[2][2] = 0.0;
    }

    default public void t4ToT3(double[][] t4Re, double[][] t4Im, double[][] t3Re, double[][] t3Im) {
        System.arraycopy(t4Re[0], 0, t3Re[0], 0, t3Re[0].length);
        System.arraycopy(t4Im[0], 0, t3Im[0], 0, t3Im[0].length);
        System.arraycopy(t4Re[1], 0, t3Re[1], 0, t3Re[1].length);
        System.arraycopy(t4Im[1], 0, t3Im[1], 0, t3Im[1].length);
        System.arraycopy(t4Re[2], 0, t3Re[2], 0, t3Re[2].length);
        System.arraycopy(t4Im[2], 0, t3Im[2], 0, t3Im[2].length);
    }

    default public void c4ToC3(double[][] c4Re, double[][] c4Im, double[][] c3Re, double[][] c3Im) {
        c3Re[0][0] = c4Re[0][0];
        c3Im[0][0] = c4Im[0][0];
        c3Re[0][1] = (c4Re[0][1] + c4Re[0][2]) / Constants.sqrt2;
        c3Im[0][1] = (c4Im[0][1] + c4Im[0][2]) / Constants.sqrt2;
        c3Re[0][2] = c4Re[0][3];
        c3Im[0][2] = c4Im[0][3];
        c3Re[1][0] = (c4Re[1][0] + c4Re[2][0]) / Constants.sqrt2;
        c3Im[1][0] = (c4Im[1][0] + c4Im[2][0]) / Constants.sqrt2;
        c3Re[1][1] = (c4Re[1][1] + c4Re[2][1] + c4Re[1][2] + c4Re[2][2]) / 2.0;
        c3Im[1][1] = (c4Im[1][1] + c4Im[2][1] + c4Im[1][2] + c4Im[2][2]) / 2.0;
        c3Re[1][2] = (c4Re[1][3] + c4Re[2][3]) / Constants.sqrt2;
        c3Im[1][2] = (c4Im[1][3] + c4Im[2][3]) / Constants.sqrt2;
        c3Re[2][0] = c4Re[3][0];
        c3Im[2][0] = c4Im[3][0];
        c3Re[2][1] = (c4Re[3][1] + c4Re[3][2]) / Constants.sqrt2;
        c3Im[2][1] = (c4Im[3][1] + c4Im[3][2]) / Constants.sqrt2;
        c3Re[2][2] = c4Re[3][3];
        c3Im[2][2] = c4Im[3][3];
    }

    default public void getMeanCoherencyMatrix(int x, int y, int halfWindowSizeX, int halfWindowSizeY, int sourceImageWidth, int sourceImageHeight, PolBandUtils.MATRIX sourceProductType, TileIndex srcIndex, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        int xx;
        int yy;
        double[][] tempSr = new double[2][2];
        double[][] tempSi = new double[2][2];
        double[][] tempCr = new double[3][3];
        double[][] tempCi = new double[3][3];
        double[][] tempTr = new double[3][3];
        double[][] tempTi = new double[3][3];
        int xSt = FastMath.max((int)(x - halfWindowSizeX), (int)0);
        int xEd = FastMath.min((int)(x + halfWindowSizeX), (int)(sourceImageWidth - 1));
        int ySt = FastMath.max((int)(y - halfWindowSizeY), (int)0);
        int yEd = FastMath.min((int)(y + halfWindowSizeY), (int)(sourceImageHeight - 1));
        int num = (yEd - ySt + 1) * (xEd - xSt + 1);
        Matrix TrMat = new Matrix(3, 3);
        Matrix TiMat = new Matrix(3, 3);
        if (sourceProductType == PolBandUtils.MATRIX.T3) {
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    this.getCoherencyMatrixT3(srcIndex.getIndex(xx), dataBuffers, tempTr, tempTi);
                    TrMat.plusEquals(new Matrix(tempTr));
                    TiMat.plusEquals(new Matrix(tempTi));
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.C3) {
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    this.getCovarianceMatrixC3(srcIndex.getIndex(xx), dataBuffers, tempCr, tempCi);
                    this.c3ToT3(tempCr, tempCi, tempTr, tempTi);
                    TrMat.plusEquals(new Matrix(tempTr));
                    TiMat.plusEquals(new Matrix(tempTi));
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    this.getComplexScatterMatrix(srcIndex.getIndex(xx), dataBuffers, tempSr, tempSi);
                    this.computeCoherencyMatrixT3(tempSr, tempSi, tempTr, tempTi);
                    TrMat.plusEquals(new Matrix(tempTr));
                    TiMat.plusEquals(new Matrix(tempTi));
                }
            }
        }
        TrMat.timesEquals(1.0 / (double)num);
        TiMat.timesEquals(1.0 / (double)num);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Tr[i][j] = TrMat.get(i, j);
                Ti[i][j] = TiMat.get(i, j);
            }
        }
    }

    default public void getMeanCovarianceMatrix(int x, int y, int halfWindowSizeX, int halfWindowSizeY, PolBandUtils.MATRIX sourceProductType, Tile[] sourceTiles, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        int xx;
        int yy;
        double[][] tempCr = new double[3][3];
        double[][] tempCi = new double[3][3];
        int xSt = Math.max(x - halfWindowSizeX, sourceTiles[0].getMinX());
        int xEd = Math.min(x + halfWindowSizeX, sourceTiles[0].getMaxX());
        int ySt = Math.max(y - halfWindowSizeY, sourceTiles[0].getMinY());
        int yEd = Math.min(y + halfWindowSizeY, sourceTiles[0].getMaxY());
        int num = (yEd - ySt + 1) * (xEd - xSt + 1);
        TileIndex srcIndex = new TileIndex(sourceTiles[0]);
        Matrix CrMat = new Matrix(3, 3);
        Matrix CiMat = new Matrix(3, 3);
        if (sourceProductType == PolBandUtils.MATRIX.C3) {
            for (int yy2 = ySt; yy2 <= yEd; ++yy2) {
                srcIndex.calculateStride(yy2);
                for (int xx2 = xSt; xx2 <= xEd; ++xx2) {
                    this.getCovarianceMatrixC3(srcIndex.getIndex(xx2), dataBuffers, tempCr, tempCi);
                    CrMat.plusEquals(new Matrix(tempCr));
                    CiMat.plusEquals(new Matrix(tempCi));
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.T3) {
            double[][] tempTr = new double[3][3];
            double[][] tempTi = new double[3][3];
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    this.getCoherencyMatrixT3(srcIndex.getIndex(xx), dataBuffers, tempTr, tempTi);
                    this.t3ToC3(tempTr, tempTi, tempCr, tempCi);
                    CrMat.plusEquals(new Matrix(tempCr));
                    CiMat.plusEquals(new Matrix(tempCi));
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    this.getComplexScatterMatrix(srcIndex.getIndex(xx), dataBuffers, tempSr, tempSi);
                    this.computeCovarianceMatrixC3(tempSr, tempSi, tempCr, tempCi);
                    CrMat.plusEquals(new Matrix(tempCr));
                    CiMat.plusEquals(new Matrix(tempCi));
                }
            }
        }
        CrMat.timesEquals(1.0 / (double)num);
        CiMat.timesEquals(1.0 / (double)num);
        for (int i = 0; i < 3; ++i) {
            Cr[i][0] = CrMat.get(i, 0);
            Ci[i][0] = CiMat.get(i, 0);
            Cr[i][1] = CrMat.get(i, 1);
            Ci[i][1] = CiMat.get(i, 1);
            Cr[i][2] = CrMat.get(i, 2);
            Ci[i][2] = CiMat.get(i, 2);
        }
    }

    default public void getMeanCovarianceMatrixC4(int x, int y, int halfWindowSizeX, int halfWindowSizeY, PolBandUtils.MATRIX sourceProductType, Tile[] sourceTiles, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        double[][] tempCr = new double[4][4];
        double[][] tempCi = new double[4][4];
        int xSt = Math.max(x - halfWindowSizeX, sourceTiles[0].getMinX());
        int xEd = Math.min(x + halfWindowSizeX, sourceTiles[0].getMaxX());
        int ySt = Math.max(y - halfWindowSizeY, sourceTiles[0].getMinY());
        int yEd = Math.min(y + halfWindowSizeY, sourceTiles[0].getMaxY());
        int num = (yEd - ySt + 1) * (xEd - xSt + 1);
        TileIndex srcIndex = new TileIndex(sourceTiles[0]);
        Matrix CrMat = new Matrix(4, 4);
        Matrix CiMat = new Matrix(4, 4);
        for (int yy = ySt; yy <= yEd; ++yy) {
            srcIndex.calculateStride(yy);
            for (int xx = xSt; xx <= xEd; ++xx) {
                this.getCovarianceMatrixC4(srcIndex.getIndex(xx), sourceProductType, dataBuffers, tempCr, tempCi);
                CrMat.plusEquals(new Matrix(tempCr));
                CiMat.plusEquals(new Matrix(tempCi));
            }
        }
        CrMat.timesEquals(1.0 / (double)num);
        CiMat.timesEquals(1.0 / (double)num);
        for (int i = 0; i < 4; ++i) {
            Cr[i][0] = CrMat.get(i, 0);
            Ci[i][0] = CiMat.get(i, 0);
            Cr[i][1] = CrMat.get(i, 1);
            Ci[i][1] = CiMat.get(i, 1);
            Cr[i][2] = CrMat.get(i, 2);
            Ci[i][2] = CiMat.get(i, 2);
            Cr[i][3] = CrMat.get(i, 3);
            Ci[i][3] = CiMat.get(i, 3);
        }
    }

    default public void getCovarianceMatrixC4(int index, PolBandUtils.MATRIX sourceProductType, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            this.getComplexScatterMatrix(index, dataBuffers, tempSr, tempSi);
            this.computeCovarianceMatrixC4(tempSr, tempSi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.T4) {
            double[][] tempTr = new double[4][4];
            double[][] tempTi = new double[4][4];
            this.getCoherencyMatrixT4(index, dataBuffers, tempTr, tempTi);
            this.t4ToC4(tempTr, tempTi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.C4) {
            this.getCovarianceMatrixC4(index, dataBuffers, Cr, Ci);
        }
    }

    default public void getCoherencyMatrixT4(int index, PolBandUtils.MATRIX sourceProductType, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            this.getComplexScatterMatrix(index, dataBuffers, tempSr, tempSi);
            this.computeCoherencyMatrixT4(tempSr, tempSi, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.T4) {
            this.getCoherencyMatrixT4(index, dataBuffers, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.C4) {
            double[][] tempCr = new double[4][4];
            double[][] tempCi = new double[4][4];
            this.getCovarianceMatrixC4(index, dataBuffers, tempCr, tempCi);
            this.c4ToT4(tempCr, tempCi, Tr, Ti);
        }
    }

    default public void getCovarianceMatrixC3(int index, PolBandUtils.MATRIX sourceProductType, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            this.getComplexScatterMatrix(index, dataBuffers, tempSr, tempSi);
            this.computeCovarianceMatrixC3(tempSr, tempSi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.T4) {
            double[][] tempTr = new double[4][4];
            double[][] tempTi = new double[4][4];
            double[][] tempCr = new double[4][4];
            double[][] tempCi = new double[4][4];
            this.getCoherencyMatrixT4(index, dataBuffers, tempTr, tempTi);
            this.t4ToC4(tempTr, tempTi, tempCr, tempCi);
            this.c4ToC3(tempCr, tempCi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.C4) {
            double[][] tempCr = new double[4][4];
            double[][] tempCi = new double[4][4];
            this.getCovarianceMatrixC4(index, dataBuffers, tempCr, tempCi);
            this.c4ToC3(tempCr, tempCi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.T3) {
            double[][] tempTr = new double[3][3];
            double[][] tempTi = new double[3][3];
            this.getCoherencyMatrixT3(index, dataBuffers, tempTr, tempTi);
            this.t3ToC3(tempTr, tempTi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.C3) {
            this.getCovarianceMatrixC3(index, dataBuffers, Cr, Ci);
        }
    }

    default public void getCoherencyMatrixT3(int index, PolBandUtils.MATRIX sourceProductType, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            this.getComplexScatterMatrix(index, dataBuffers, tempSr, tempSi);
            this.computeCoherencyMatrixT3(tempSr, tempSi, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.T4) {
            double[][] tempTr = new double[4][4];
            double[][] tempTi = new double[4][4];
            this.getCoherencyMatrixT4(index, dataBuffers, tempTr, tempTi);
            this.t4ToT3(tempTr, tempTi, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.C4) {
            double[][] tempCr = new double[4][4];
            double[][] tempCi = new double[4][4];
            double[][] tempTr = new double[4][4];
            double[][] tempTi = new double[4][4];
            this.getCovarianceMatrixC4(index, dataBuffers, tempCr, tempCi);
            this.c4ToT4(tempCr, tempCi, tempTr, tempTi);
            this.t4ToT3(tempTr, tempTi, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.T3) {
            this.getCoherencyMatrixT3(index, dataBuffers, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.C3) {
            double[][] tempCr = new double[3][3];
            double[][] tempCi = new double[3][3];
            this.getCovarianceMatrixC3(index, dataBuffers, tempCr, tempCi);
            this.c3ToT3(tempCr, tempCi, Tr, Ti);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public DecompositionBase.MinMax computeSpanMinMax(final Operator op, final PolBandUtils.MATRIX sourceProductType, final int halfWindowSizeX, int halfWindowSizeY, final PolBandUtils.PolSourceBand bandList) throws OperatorException {
        final DecompositionBase.MinMax minMaxValue = new DecompositionBase.MinMax();
        Dimension tileSize = new Dimension(256, 256);
        Rectangle[] tileRectangles = OperatorUtils.getAllTileRectangles((Product)op.getSourceProduct(), (Dimension)tileSize, (int)25);
        final double[][] Cr = new double[3][3];
        final double[][] Ci = new double[3][3];
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Computing min max span... ", tileRectangles.length);
        try {
            ThreadManager threadManager = new ThreadManager();
            for (final Rectangle rectangle : tileRectangles) {
                Thread worker = new Thread(){
                    double span = 0.0;
                    final int xMax;
                    final int yMax;
                    final Tile[] sourceTiles;
                    final ProductData[] dataBuffers;
                    {
                        this.xMax = rectangle.x + rectangle.width;
                        this.yMax = rectangle.y + rectangle.height;
                        this.sourceTiles = new Tile[bandList.srcBands.length];
                        this.dataBuffers = new ProductData[bandList.srcBands.length];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            QuadPolProcessor.this.getQuadPolDataBuffer(op, bandList.srcBands, rectangle, sourceProductType, this.sourceTiles, this.dataBuffers);
                            for (int y = rectangle.y; y < this.yMax; ++y) {
                                for (int x = rectangle.x; x < this.xMax; ++x) {
                                    DecompositionBase.MinMax minMax;
                                    QuadPolProcessor.this.getMeanCovarianceMatrix(x, y, halfWindowSizeX, halfWindowSizeX, sourceProductType, this.sourceTiles, this.dataBuffers, Cr, Ci);
                                    this.span = Cr[0][0] + Cr[1][1] + Cr[2][2];
                                    if (minMaxValue.min > this.span) {
                                        minMax = minMaxValue;
                                        synchronized (minMax) {
                                            minMaxValue.min = this.span;
                                        }
                                    }
                                    if (!(minMaxValue.max < this.span)) continue;
                                    minMax = minMaxValue;
                                    synchronized (minMax) {
                                        minMaxValue.max = this.span;
                                        continue;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            threadManager.finish();
            if (minMaxValue.min < 1.0E-15) {
                minMaxValue.min = 1.0E-15;
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(op.getId() + " computeMinMaxSpan "), (Throwable)e);
        }
        finally {
            status.done();
        }
        return minMaxValue;
    }
}

