/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.decompositions.Cloude;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.FreemanDurden;
import org.csa.rstb.polarimetric.gpf.decompositions.GeneralizedFreemanDurden;
import org.csa.rstb.polarimetric.gpf.decompositions.HAlphaC2;
import org.csa.rstb.polarimetric.gpf.decompositions.Pauli;
import org.csa.rstb.polarimetric.gpf.decompositions.Sinclair;
import org.csa.rstb.polarimetric.gpf.decompositions.Touzi;
import org.csa.rstb.polarimetric.gpf.decompositions.Yamaguchi;
import org.csa.rstb.polarimetric.gpf.decompositions.hAAlpha;
import org.csa.rstb.polarimetric.gpf.decompositions.vanZyl;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="Polarimetric-Decomposition", category="Radar/Polarimetric", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Perform Polarimetric decomposition of a given product")
public final class PolarimetricDecompositionOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"Sinclair Decomposition", "Pauli Decomposition", "Freeman-Durden Decomposition", "Generalized Freeman-Durden Decomposition", "Yamaguchi Decomposition", "van Zyl Decomposition", "H-A-Alpha Quad Pol Decomposition", "H-Alpha Dual Pol Decomposition", "Cloude Decomposition", "Touzi Decomposition"}, defaultValue="Sinclair Decomposition", label="Decomposition")
    private String decomposition = "Sinclair Decomposition";
    @Parameter(description="The sliding window size", interval="[1, 100]", defaultValue="5", label="Window Size")
    private int windowSize = 5;
    @Parameter(description="Output entropy, anisotropy, alpha", defaultValue="false", label="Entropy (H), Anisotropy (A), Alpha")
    private boolean outputHAAlpha = false;
    @Parameter(description="Output beta, delta, gamma, lambda", defaultValue="false", label="Beta, Delta, Gamma, Lambda")
    private boolean outputBetaDeltaGammaLambda = false;
    @Parameter(description="Output alpha 1, 2, 3", defaultValue="false", label="Alpha 1, Alpha 2, Alpha 3")
    private boolean outputAlpha123 = false;
    @Parameter(description="Output lambda 1, 2, 3", defaultValue="false", label="Lambda 1, Lambda 2, Lambda 3")
    private boolean outputLambda123 = false;
    @Parameter(description="Output psi, tau, alpha, phi", defaultValue="false", label="Psi, Tau, Alpha, Phi")
    private boolean outputTouziParamSet0 = false;
    @Parameter(description="Output psi1, tau1, alpha1, phi1", defaultValue="false", label="Psi 1, Tau 1, Alpha 1, Phi 1")
    private boolean outputTouziParamSet1 = false;
    @Parameter(description="Output psi2, tau2, alpha2, phi2", defaultValue="false", label="Psi 2, Tau 2, Alpha 2, Phi 2")
    private boolean outputTouziParamSet2 = false;
    @Parameter(description="Output psi3, tau3, alpha3, phi3", defaultValue="false", label="Psi 3, Tau 3, Alpha 3, Phi 3")
    private boolean outputTouziParamSet3 = false;
    public static final String SINCLAIR_DECOMPOSITION = "Sinclair Decomposition";
    public static final String PAULI_DECOMPOSITION = "Pauli Decomposition";
    public static final String FREEMAN_DURDEN_DECOMPOSITION = "Freeman-Durden Decomposition";
    public static final String GENERALIZED_FREEMAN_DURDEN_DECOMPOSITION = "Generalized Freeman-Durden Decomposition";
    public static final String YAMAGUCHI_DECOMPOSITION = "Yamaguchi Decomposition";
    public static final String VANZYL_DECOMPOSITION = "van Zyl Decomposition";
    public static final String H_A_ALPHA_DECOMPOSITION = "H-A-Alpha Quad Pol Decomposition";
    public static final String H_ALPHA_DECOMPOSITION = "H-Alpha Dual Pol Decomposition";
    public static final String CLOUDE_DECOMPOSITION = "Cloude Decomposition";
    public static final String TOUZI_DECOMPOSITION = "Touzi Decomposition";
    private PolBandUtils.PolSourceBand[] srcBandList;
    private PolBandUtils.MATRIX sourceProductType = null;
    private Decomposition polDecomp;

    protected void SetDecomposition(String s) {
        if (!(s.equals(SINCLAIR_DECOMPOSITION) || s.equals(PAULI_DECOMPOSITION) || s.equals(FREEMAN_DURDEN_DECOMPOSITION) || s.equals(YAMAGUCHI_DECOMPOSITION) || s.equals(VANZYL_DECOMPOSITION) || s.equals(H_A_ALPHA_DECOMPOSITION) || s.equals(H_ALPHA_DECOMPOSITION) || s.equals(CLOUDE_DECOMPOSITION) || s.equals(TOUZI_DECOMPOSITION) || s.equals(GENERALIZED_FREEMAN_DURDEN_DECOMPOSITION))) {
            throw new OperatorException(s + " is an invalid decomposition name.");
        }
        this.decomposition = s;
    }

    protected void setTouziParameters(boolean set0, boolean set1, boolean set2, boolean set3) {
        this.outputTouziParamSet0 = set0;
        this.outputTouziParamSet1 = set1;
        this.outputTouziParamSet2 = set2;
        this.outputTouziParamSet3 = set3;
    }

    protected void setHAAlphaParameters(boolean HAAlpha2, boolean BetaDeltaGammaLambda, boolean Alpha123, boolean Lambda123) {
        this.outputHAAlpha = HAAlpha2;
        this.outputBetaDeltaGammaLambda = BetaDeltaGammaLambda;
        this.outputAlpha123 = Alpha123;
        this.outputLambda123 = Lambda123;
    }

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfTOPSARBurstProduct(false);
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.polDecomp = this.createDecomposition();
            this.checkSourceProductType(this.sourceProductType);
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkSourceProductType(PolBandUtils.MATRIX sourceProductType) {
        if (sourceProductType == PolBandUtils.MATRIX.UNKNOWN) {
            throw new OperatorException("Input should be a polarimetric product");
        }
        if (this.polDecomp instanceof HAlphaC2 && !PolBandUtils.isDualPol((PolBandUtils.MATRIX)sourceProductType)) {
            throw new OperatorException("Input should be a dual polarimetric product");
        }
        if (!(this.polDecomp instanceof HAlphaC2 || PolBandUtils.isQuadPol((PolBandUtils.MATRIX)sourceProductType) || PolBandUtils.isFullPol((PolBandUtils.MATRIX)sourceProductType))) {
            throw new OperatorException("Input should be a full polarimetric product");
        }
    }

    private Decomposition createDecomposition() throws OperatorException {
        int sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        int sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        if (this.sourceProductType == null) {
            throw new OperatorException("Source product type is unknown");
        }
        if (sourceImageWidth == 0 || sourceImageHeight == 0) {
            throw new OperatorException("Source image dimensions unknown");
        }
        switch (this.decomposition) {
            case "Sinclair Decomposition": {
                return new Sinclair(this.srcBandList, this.sourceProductType, this.windowSize, sourceImageWidth, sourceImageHeight);
            }
            case "Pauli Decomposition": {
                return new Pauli(this.srcBandList, this.sourceProductType, this.windowSize, sourceImageWidth, sourceImageHeight);
            }
            case "Freeman-Durden Decomposition": {
                return new FreemanDurden(this.srcBandList, this.sourceProductType, this.windowSize, sourceImageWidth, sourceImageHeight);
            }
            case "Generalized Freeman-Durden Decomposition": {
                return new GeneralizedFreemanDurden(this.srcBandList, this.sourceProductType, this.windowSize, sourceImageWidth, sourceImageHeight);
            }
            case "Yamaguchi Decomposition": {
                return new Yamaguchi(this.srcBandList, this.sourceProductType, this.windowSize, sourceImageWidth, sourceImageHeight);
            }
            case "van Zyl Decomposition": {
                return new vanZyl(this.srcBandList, this.sourceProductType, this.windowSize, sourceImageWidth, sourceImageHeight);
            }
            case "Cloude Decomposition": {
                return new Cloude(this.srcBandList, this.sourceProductType, this.windowSize, sourceImageWidth, sourceImageHeight);
            }
            case "H-A-Alpha Quad Pol Decomposition": {
                return new hAAlpha(this.srcBandList, this.sourceProductType, this.windowSize, sourceImageWidth, sourceImageHeight, this.outputHAAlpha, this.outputBetaDeltaGammaLambda, this.outputAlpha123, this.outputLambda123);
            }
            case "H-Alpha Dual Pol Decomposition": {
                return new HAlphaC2(this.srcBandList, this.sourceProductType, this.windowSize, this.windowSize, sourceImageWidth, sourceImageHeight);
            }
            case "Touzi Decomposition": {
                return new Touzi(this.srcBandList, this.sourceProductType, this.windowSize, sourceImageWidth, sourceImageHeight, this.outputTouziParamSet0, this.outputTouziParamSet1, this.outputTouziParamSet2, this.outputTouziParamSet3);
            }
        }
        return null;
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + this.polDecomp.getSuffix(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absRoot.setAttributeInt("polsar_data", 1);
        PolBandUtils.saveNewBandNames((Product)this.targetProduct, (PolBandUtils.PolSourceBand[])this.srcBandList);
    }

    private void addSelectedBands() throws OperatorException {
        String[] targetBandNames = this.polDecomp.getTargetBandNames();
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Band[] targetBands = new Band[targetBandNames.length];
            int i = 0;
            for (String targetBandName : targetBandNames) {
                Band targetBand = new Band(targetBandName + bandList.suffix, 30, this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
                this.polDecomp.setBandUnit(targetBandName + bandList.suffix, targetBand);
                targetBand.setNoDataValueUsed(true);
                targetBand.setNoDataValue(0.0);
                this.targetProduct.addBand(targetBand);
                targetBands[i++] = targetBand;
            }
            bandList.addTargetBands(targetBands);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            this.polDecomp.computeTile(targetTiles, targetRectangle, this);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PolarimetricDecompositionOp.class);
        }
    }
}

