/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.CompactPolProcessor;
import org.csa.rstb.polarimetric.gpf.StokesParameters;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="CP-Stokes-Parameters", category="Radar/Polarimetric/Compact Polarimetry", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2018 SkyWatch Space Applications Inc.", description="Generates compact polarimetric Stokes child parameters")
public final class CompactPolStokesParametersOp
extends Operator
implements CompactPolProcessor {
    private static final String PRODUCT_SUFFIX = "_Stokes";
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"3", "5", "7", "9", "11", "13", "15", "17", "19"}, defaultValue="5", label="Window Size X")
    private String windowSizeXStr = "5";
    @Parameter(valueSet={"3", "5", "7", "9", "11", "13", "15", "17", "19"}, defaultValue="5", label="Window Size Y")
    private String windowSizeYStr = "5";
    @Parameter(description="Output Stokes vector", defaultValue="false", label="Stokes vector")
    private boolean outputStokesVector = false;
    @Parameter(description="Output degree of polarization", defaultValue="true", label="Degree of polarization")
    private boolean outputDegreeOfPolarization = true;
    @Parameter(description="Output degree of depolarization", defaultValue="true", label="Degree of depolarization")
    private boolean outputDegreeOfDepolarization = true;
    @Parameter(description="Output degree of circularity", defaultValue="true", label="Degree of circularity")
    private boolean outputDegreeOfCircularity = true;
    @Parameter(description="Output degree of ellipticity", defaultValue="true", label="Degree of ellipticity")
    private boolean outputDegreeOfEllipticity = true;
    @Parameter(description="Output circular polarization ratio", defaultValue="true", label="Circular polarization ratio")
    private boolean outputCPR = true;
    @Parameter(description="Output linear polarization ratio", defaultValue="true", label="Linear polarization ratio")
    private boolean outputLPR = true;
    @Parameter(description="Output relative phase", defaultValue="true", label="Linear relative phase")
    private boolean outputRelativePhase = true;
    @Parameter(description="Output alphas", defaultValue="true", label="Alphas")
    private boolean outputAlphas = true;
    @Parameter(description="Output conformity coefficient", defaultValue="true", label="Conformity coefficient")
    private boolean outputConformity = true;
    @Parameter(description="Output phase phi", defaultValue="true", label="Phase Phi")
    private boolean outputPhasePhi = true;
    private int windowSizeX = 0;
    private int windowSizeY = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private String compactMode = null;
    private boolean useRCMConvention = false;
    private PolBandUtils.MATRIX sourceProductType = null;
    private PolBandUtils.PolSourceBand[] srcBandList;

    public void SetOutputParameter(String s) {
        switch (s) {
            case "Stokes Vector": {
                this.outputStokesVector = true;
                break;
            }
            case "Degree Of Polarization": {
                this.outputDegreeOfPolarization = true;
                break;
            }
            case "Degree Of Depolarization": {
                this.outputDegreeOfDepolarization = true;
                break;
            }
            case "Degree Of Circularity": {
                this.outputDegreeOfCircularity = true;
                break;
            }
            case "Degree Of Ellipticity": {
                this.outputDegreeOfEllipticity = true;
                break;
            }
            case "Circular Polarization Ratio": {
                this.outputCPR = true;
                break;
            }
            case "Linear Polarization Ratio": {
                this.outputLPR = true;
                break;
            }
            case "Relative Phase": {
                this.outputRelativePhase = true;
                break;
            }
            case "Alphas": {
                this.outputAlphas = true;
                break;
            }
            case "Conformity Coefficient": {
                this.outputConformity = true;
                break;
            }
            default: {
                throw new OperatorException(s + " is an invalid parameter name.");
            }
        }
    }

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSLC();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            if (this.sourceProductType != PolBandUtils.MATRIX.LCHCP && this.sourceProductType != PolBandUtils.MATRIX.RCHCP && this.sourceProductType != PolBandUtils.MATRIX.C2) {
                throw new OperatorException("Compact pol source product or C2 covariance matrix product is expected.");
            }
            if (!(this.outputDegreeOfPolarization || this.outputDegreeOfDepolarization || this.outputDegreeOfCircularity || this.outputDegreeOfEllipticity || this.outputCPR || this.outputLPR || this.outputRelativePhase || this.outputAlphas || this.outputConformity || this.outputPhasePhi || this.outputStokesVector)) {
                throw new OperatorException("Please select output parameters.");
            }
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.windowSizeX = Integer.parseInt(this.windowSizeXStr);
            this.windowSizeY = Integer.parseInt(this.windowSizeYStr);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.getCompactMode();
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getCompactMode() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        this.compactMode = absRoot.getAttributeString("compact_mode", "Right Circular Hybrid Mode");
        if (!this.compactMode.equals("Right Circular Hybrid Mode") && !this.compactMode.equals("Left Circular Hybrid Mode")) {
            throw new OperatorException("Right/Left Circular Hybrid Mode is expected.");
        }
        this.useRCMConvention = PolBandUtils.useRCMConvention();
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() throws OperatorException {
        String[] targetBandNames = this.getTargetBandNames();
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Band[] targetBands = OperatorUtils.addBands((Product)this.targetProduct, (String[])targetBandNames, (String)bandList.suffix);
            bandList.addTargetBands(targetBands);
        }
    }

    private String[] getTargetBandNames() {
        ArrayList<String> targetBandNameList = new ArrayList<String>(13);
        if (this.outputStokesVector) {
            targetBandNameList.add("g0");
            targetBandNameList.add("g1");
            targetBandNameList.add("g2");
            targetBandNameList.add("g3");
        }
        if (this.outputDegreeOfPolarization) {
            targetBandNameList.add("DegreeOfPolarization");
        }
        if (this.outputDegreeOfDepolarization) {
            targetBandNameList.add("DegreeOfDepolarization");
        }
        if (this.outputDegreeOfCircularity) {
            targetBandNameList.add("DegreeOfCircularity");
        }
        if (this.outputDegreeOfEllipticity) {
            targetBandNameList.add("DegreeOfEllipticity");
        }
        if (this.outputCPR) {
            targetBandNameList.add("CPR");
        }
        if (this.outputLPR) {
            targetBandNameList.add("LPR");
        }
        if (this.outputRelativePhase) {
            targetBandNameList.add("RelativePhase");
        }
        if (this.outputAlphas) {
            targetBandNameList.add("Alphas");
        }
        if (this.outputConformity) {
            targetBandNameList.add("ConformityCoefficient");
        }
        if (this.outputPhasePhi) {
            targetBandNameList.add("PhasePhi");
        }
        return targetBandNameList.toArray(new String[targetBandNameList.size()]);
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absRoot.setAttributeInt("polsar_data", 1);
        PolBandUtils.saveNewBandNames((Product)this.targetProduct, (PolBandUtils.PolSourceBand[])this.srcBandList);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        double[][] Cr = new double[2][2];
        double[][] Ci = new double[2][2];
        double[] g = new double[4];
        Rectangle sourceRectangle = this.getSourceTileRectangle(x0, y0, w, h, this.windowSizeX, this.windowSizeY);
        int halfWindowSizeX = this.windowSizeX / 2;
        int halfWindowSizeY = this.windowSizeY / 2;
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            try {
                TileData[] tileDataList = new TileData[bandList.targetBands.length];
                int i = 0;
                for (Band targetBand : bandList.targetBands) {
                    Tile targetTile = targetTiles.get(targetBand);
                    tileDataList[i++] = new TileData(targetTile, targetBand.getName());
                }
                Tile[] sourceTiles = new Tile[bandList.srcBands.length];
                ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
                for (int j = 0; j < bandList.srcBands.length; ++j) {
                    sourceTiles[j] = this.getSourceTile((RasterDataNode)bandList.srcBands[j], sourceRectangle);
                    dataBuffers[j] = sourceTiles[j].getDataBuffer();
                }
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        int idx = trgIndex.getIndex(x);
                        this.getMeanCovarianceMatrixC2(x, y, halfWindowSizeX, halfWindowSizeY, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                        StokesParameters.computeCompactPolStokesVector(Cr, Ci, g);
                        StokesParameters sp = StokesParameters.computeStokesParameters(g, this.compactMode, this.useRCMConvention);
                        for (TileData tileData : tileDataList) {
                            if (this.outputStokesVector && tileData.bandName.startsWith("g0")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)g[0]);
                            }
                            if (this.outputStokesVector && tileData.bandName.startsWith("g1")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)g[1]);
                            }
                            if (this.outputStokesVector && tileData.bandName.startsWith("g2")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)g[2]);
                            }
                            if (this.outputStokesVector && tileData.bandName.startsWith("g3")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)g[3]);
                            }
                            if (this.outputDegreeOfPolarization && tileData.bandName.startsWith("DegreeOfPolarization")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)sp.DegreeOfPolarization);
                            }
                            if (this.outputDegreeOfDepolarization && tileData.bandName.startsWith("DegreeOfDepolarization")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)sp.DegreeOfDepolarization);
                            }
                            if (this.outputDegreeOfCircularity && tileData.bandName.startsWith("DegreeOfCircularity")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)sp.DegreeOfCircularity);
                            }
                            if (this.outputDegreeOfEllipticity && tileData.bandName.startsWith("DegreeOfEllipticity")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)sp.DegreeOfEllipticity);
                            }
                            if (this.outputCPR && tileData.bandName.startsWith("CPR")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)sp.circularPolarizationRatio);
                            }
                            if (this.outputLPR && tileData.bandName.startsWith("LPR")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)sp.linearPolarizationRatio);
                            }
                            if (this.outputRelativePhase && tileData.bandName.startsWith("RelativePhase")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)sp.RelativePhase);
                            }
                            if (this.outputAlphas && tileData.bandName.startsWith("Alphas")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)sp.Alphas);
                            }
                            if (this.outputPhasePhi && tileData.bandName.startsWith("PhasePhi")) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)sp.PhasePhi);
                            }
                            if (!this.outputConformity || !tileData.bandName.startsWith("ConformityCoefficient")) continue;
                            tileData.dataBuffer.setElemFloatAt(idx, (float)sp.Conformity);
                        }
                    }
                }
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            }
        }
    }

    private Rectangle getSourceTileRectangle(int x0, int y0, int w, int h, int windowSizeX, int windowSizeY) {
        int sx0 = x0;
        int sy0 = y0;
        int sw = w;
        int sh = h;
        int halfWindowSizeX = windowSizeX / 2;
        int halfWindowSizeY = windowSizeY / 2;
        if (x0 >= halfWindowSizeX) {
            sx0 -= halfWindowSizeX;
            sw += halfWindowSizeX;
        }
        if (y0 >= halfWindowSizeY) {
            sy0 -= halfWindowSizeY;
            sh += halfWindowSizeY;
        }
        if (x0 + w + halfWindowSizeX <= this.sourceImageWidth) {
            sw += halfWindowSizeX;
        }
        if (y0 + h + halfWindowSizeY <= this.sourceImageHeight) {
            sh += halfWindowSizeY;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CompactPolStokesParametersOp.class);
        }
    }

    private static class TileData {
        final Tile tile;
        final ProductData dataBuffer;
        final String bandName;

        public TileData(Tile tile, String bandName) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            this.bandName = bandName;
        }
    }
}

