/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions_cp.CP_HAlpha;
import org.csa.rstb.polarimetric.gpf.decompositions_cp.CP_MChi;
import org.csa.rstb.polarimetric.gpf.decompositions_cp.CP_MDelta;
import org.csa.rstb.polarimetric.gpf.decompositions_cp.CP_RVOG;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="CP-Decomposition", category="Radar/Polarimetric/Compact Polarimetry", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2018 SkyWatch Space Applications Inc.", description="Perform Compact Polarimetric decomposition of a given product")
public final class CompactPolDecompositionOp
extends Operator {
    public static final String M_CHI_DECOMPOSITION = "M-Chi Decomposition";
    public static final String M_DELTA_DECOMPOSITION = "M-Delta Decomposition";
    public static final String H_ALPHA_DECOMPOSITION = "H-Alpha Decomposition";
    public static final String RVOG_DECOMPOSITION = "2 Layer RVOG Model Based Decomposition";
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"M-Chi Decomposition", "M-Delta Decomposition", "H-Alpha Decomposition", "2 Layer RVOG Model Based Decomposition"}, defaultValue="M-Chi Decomposition", label="Decomposition")
    private String decomposition = "M-Chi Decomposition";
    @Parameter(valueSet={"3", "5", "7", "9", "11", "13", "15", "17", "19"}, defaultValue="5", label="Window Size X")
    private String windowSizeXStr = "5";
    @Parameter(valueSet={"3", "5", "7", "9", "11", "13", "15", "17", "19"}, defaultValue="5", label="Window Size Y")
    private String windowSizeYStr = "5";
    @Parameter(description="Compute alpha by coherency matrix T3", defaultValue="true", label="Compute Alpha By T3")
    private boolean computeAlphaByT3 = true;
    @Parameter(description="Output RVOG parameters mv, ms, alphaS and phi", defaultValue="true", label="Output mv, ms, alphaS, phi")
    private boolean outputRVOG = true;
    private int windowSizeX = 0;
    private int windowSizeY = 0;
    private PolBandUtils.PolSourceBand[] srcBandList;
    private PolBandUtils.MATRIX sourceProductType = null;
    private Decomposition polDecomp;
    private String compactMode = null;

    protected void SetDecomposition(String s) {
        if (!(s.equals(M_CHI_DECOMPOSITION) || s.equals(M_DELTA_DECOMPOSITION) || s.equals(H_ALPHA_DECOMPOSITION) || s.equals(RVOG_DECOMPOSITION))) {
            throw new OperatorException(s + " is an invalid decomposition name.");
        }
        this.decomposition = s;
    }

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSLC();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            if (this.sourceProductType != PolBandUtils.MATRIX.LCHCP && this.sourceProductType != PolBandUtils.MATRIX.RCHCP && this.sourceProductType != PolBandUtils.MATRIX.C2) {
                throw new OperatorException("Compact pol source product or C2 covariance matrix product is expected.");
            }
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.getCompactPolMode();
            this.windowSizeX = Integer.parseInt(this.windowSizeXStr);
            this.windowSizeY = Integer.parseInt(this.windowSizeYStr);
            this.polDecomp = this.createDecomposition();
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getCompactPolMode() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        this.compactMode = absRoot.getAttributeString("compact_mode", "Right Circular Hybrid Mode");
        if (!this.compactMode.equals("Right Circular Hybrid Mode") && !this.compactMode.equals("Left Circular Hybrid Mode")) {
            throw new OperatorException("Right/Left Circular Hybrid Mode is expected.");
        }
    }

    private Decomposition createDecomposition() throws OperatorException {
        int sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        int sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        if (this.sourceProductType == null) {
            throw new OperatorException("Source product type is unknown");
        }
        if (sourceImageWidth == 0 || sourceImageHeight == 0) {
            throw new OperatorException("Source image dimensions unknown");
        }
        switch (this.decomposition) {
            case "M-Chi Decomposition": {
                return new CP_MChi(this.srcBandList, this.sourceProductType, this.compactMode, this.windowSizeX, this.windowSizeY, sourceImageWidth, sourceImageHeight);
            }
            case "M-Delta Decomposition": {
                return new CP_MDelta(this.srcBandList, this.sourceProductType, this.compactMode, this.windowSizeX, this.windowSizeY, sourceImageWidth, sourceImageHeight);
            }
            case "H-Alpha Decomposition": {
                return new CP_HAlpha(this.srcBandList, this.sourceProductType, this.compactMode, this.windowSizeX, this.windowSizeY, this.computeAlphaByT3, sourceImageWidth, sourceImageHeight);
            }
            case "2 Layer RVOG Model Based Decomposition": {
                return new CP_RVOG(this.srcBandList, this.sourceProductType, this.compactMode, this.windowSizeX, this.windowSizeY, this.outputRVOG, sourceImageWidth, sourceImageHeight);
            }
        }
        return null;
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + this.polDecomp.getSuffix(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absRoot.setAttributeInt("polsar_data", 1);
        absRoot.setAttributeString("compact_mode", this.compactMode);
        PolBandUtils.saveNewBandNames((Product)this.targetProduct, (PolBandUtils.PolSourceBand[])this.srcBandList);
    }

    private void addSelectedBands() throws OperatorException {
        String[] targetBandNames = this.polDecomp.getTargetBandNames();
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Band[] targetBands = new Band[targetBandNames.length];
            int i = 0;
            for (String targetBandName : targetBandNames) {
                Band targetBand = new Band(targetBandName + bandList.suffix, 30, this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
                this.polDecomp.setBandUnit(targetBandName + bandList.suffix, targetBand);
                this.targetProduct.addBand(targetBand);
                targetBands[i++] = targetBand;
            }
            bandList.addTargetBands(targetBands);
        }
    }

    private String getCompactMode() {
        return this.compactMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            this.polDecomp.computeTile(targetTiles, targetRectangle, this);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CompactPolDecompositionOp.class);
        }
    }
}

