/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.math3.util.FastMath;
import org.csa.rstb.polarimetric.gpf.CompactPolProcessor;
import org.csa.rstb.polarimetric.gpf.QuadPolProcessor;
import org.esa.s1tbx.commons.polsar.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.eo.Constants;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="CP-Simulation", category="Radar/Polarimetric/Compact Polarimetry", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2018 SkyWatch Space Applications Inc.", description="Simulation of Compact Pol data from Quad Pol data")
public final class CompactPolDataSimulationOp
extends Operator
implements QuadPolProcessor,
CompactPolProcessor {
    public static final String C2 = "Covariance Matrix C2";
    public static final String S2 = "Scatter Vector S2";
    private final Map<Band, MatrixElem> matrixBandMap = new HashMap<Band, MatrixElem>(8);
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"Right Circular Hybrid Mode", "Left Circular Hybrid Mode"}, description="The compact mode", defaultValue="Right Circular Hybrid Mode", label="Compact Mode")
    private String compactMode = "Right Circular Hybrid Mode";
    @Parameter(valueSet={"Covariance Matrix C2", "Scatter Vector S2"}, description="The output simulated compact pol data format", defaultValue="Covariance Matrix C2", label="Output Format")
    private String outputFormat = "Covariance Matrix C2";
    @Parameter(description="The noise power", interval="(-35, -15)", defaultValue="-25", label="Noise Power (dB)")
    private double noisePower = -25.0;
    @Parameter(description="Simulate noise floor", defaultValue="false", label="Simulate noise floor")
    private Boolean simulateNoiseFloor = false;
    private PolBandUtils.PolSourceBand[] srcBandList;
    private PolBandUtils.MATRIX sourceProductType = null;
    private double sigma = 0.0;
    private Random random = new Random();
    private boolean useRCMConvention = false;
    private static final String quarterPi = "PI/4 Mode";
    private static final String dcp = "Dual Circular Polarimetric Mode";
    private static final String dualHHHV = "Dual HH/HV";
    private static final String dualVVVH = "Dual VV/VH";

    public void SetCompactMode(String m) {
        if (!(m.equals(quarterPi) || m.equals("Right Circular Hybrid Mode") || m.equals("Left Circular Hybrid Mode") || m.equals(dcp) || m.equals(dualHHHV) || m.equals(dualVVVH))) {
            throw new OperatorException(m + " is an invalid compact mode.");
        }
        this.compactMode = m;
    }

    public void SetOutputFormat(String f) {
        if (!f.equals(C2) && !f.equals(S2)) {
            throw new OperatorException(f + " is an invalid output format.");
        }
        this.outputFormat = f;
    }

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSLC();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.useRCMConvention = PolBandUtils.useRCMConvention();
            if (this.simulateNoiseFloor.booleanValue()) {
                this.sigma = Math.sqrt(FastMath.pow((double)10.0, (double)(this.noisePower / 10.0)) / 2.0);
            }
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() throws OperatorException {
        if (this.sourceProductType != PolBandUtils.MATRIX.FULL) {
            throw new OperatorException("Full polarimetric product is expected.");
        }
        String[] bandNames = null;
        if (this.outputFormat.equals(C2)) {
            bandNames = PolBandUtils.getC2BandNames();
            this.addBands(bandNames);
            this.mapMatrixElemToBandsC2();
        } else {
            bandNames = this.compactMode.equals("Left Circular Hybrid Mode") ? PolBandUtils.getLCHModeS2BandNames() : PolBandUtils.getRCHModeS2BandNames();
            this.addBands(bandNames);
            this.mapMatrixElemToBandsS2();
        }
    }

    private void addBands(String[] bandNames) {
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            ArrayList<Band> tgtBandList = new ArrayList<Band>(bandNames.length);
            for (String targetBandName : bandNames) {
                Band targetBand = new Band(targetBandName + bandList.suffix, 30, this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
                if (targetBandName.startsWith("i_") || targetBandName.contains("_real")) {
                    targetBand.setUnit("real");
                } else if (targetBandName.startsWith("q_") || targetBandName.contains("_imag")) {
                    targetBand.setUnit("imaginary");
                } else {
                    targetBand.setUnit("intensity");
                }
                tgtBandList.add(targetBand);
                this.targetProduct.addBand(targetBand);
            }
            Band[] targetBands = tgtBandList.toArray(new Band[tgtBandList.size()]);
            bandList.addTargetBands(targetBands);
        }
    }

    private void mapMatrixElemToBandsC2() {
        Band[] bands;
        for (Band band : bands = this.targetProduct.getBands()) {
            String targetBandName = band.getName();
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"11")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 0, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_real")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 1, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 1, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_real")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 2, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 2, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"14_real")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 3, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"14_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 3, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"22")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 1, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_real")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 2, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 2, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"24_real")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 3, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"24_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 3, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"33")) {
                this.matrixBandMap.put(band, new MatrixElem(2, 2, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"34_real")) {
                this.matrixBandMap.put(band, new MatrixElem(2, 3, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"34_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(2, 3, true));
                continue;
            }
            if (!PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"44")) continue;
            this.matrixBandMap.put(band, new MatrixElem(3, 3, false));
        }
    }

    private void mapMatrixElemToBandsS2() {
        Band[] bands;
        for (Band band : bands = this.targetProduct.getBands()) {
            String targetBandName = band.getName();
            if (targetBandName.contains("i_45H") || targetBandName.contains("i_RH") || targetBandName.contains("i_RCH") || targetBandName.contains("i_LH") || targetBandName.contains("i_RR") || targetBandName.contains("i_LCH") || targetBandName.contains("i_HH") || targetBandName.contains("i_VH")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 0, false));
                continue;
            }
            if (targetBandName.contains("q_45H") || targetBandName.contains("q_RH") || targetBandName.contains("q_RCH") || targetBandName.contains("q_LH") || targetBandName.contains("q_RR") || targetBandName.contains("q_LCH") || targetBandName.contains("q_HH") || targetBandName.contains("q_VH")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 0, true));
                continue;
            }
            if (targetBandName.contains("i_45V") || targetBandName.contains("i_RV") || targetBandName.contains("i_RCV") || targetBandName.contains("i_LV") || targetBandName.contains("i_RL") || targetBandName.contains("i_LCV") || targetBandName.contains("i_HV") || targetBandName.contains("i_VV")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 0, false));
                continue;
            }
            if (!targetBandName.contains("q_45V") && !targetBandName.contains("q_RV") && !targetBandName.contains("q_RCV") && !targetBandName.contains("q_LV") && !targetBandName.contains("q_RL") && !targetBandName.contains("q_LCV") && !targetBandName.contains("q_HV") && !targetBandName.contains("q_VV")) continue;
            this.matrixBandMap.put(band, new MatrixElem(1, 0, true));
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absRoot.setAttributeInt("polsar_data", 1);
        absRoot.setAttributeString("compact_mode", this.compactMode);
        PolBandUtils.saveNewBandNames((Product)this.targetProduct, (PolBandUtils.PolSourceBand[])this.srcBandList);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        if (this.outputFormat.equals(C2)) {
            this.computeTileStackC2(targetTiles, targetRectangle, pm);
        } else {
            this.computeTileStackS2(targetTiles, targetRectangle, pm);
        }
    }

    private void computeTileStackC2(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        double[][] Sr = new double[2][2];
        double[][] Si = new double[2][2];
        double[][] Cr = new double[2][2];
        double[][] Ci = new double[2][2];
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            try {
                TileData[] tileDataList = new TileData[bandList.targetBands.length];
                int i = 0;
                for (Band targetBand : bandList.targetBands) {
                    Tile targetTile = targetTiles.get(targetBand);
                    MatrixElem elem = this.matrixBandMap.get(targetBand);
                    tileDataList[i++] = new TileData(targetTile, elem);
                }
                Tile[] sourceTiles = new Tile[bandList.srcBands.length];
                ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
                for (int j = 0; j < bandList.srcBands.length; ++j) {
                    sourceTiles[j] = this.getSourceTile((RasterDataNode)bandList.srcBands[j], targetRectangle);
                    dataBuffers[j] = sourceTiles[j].getDataBuffer();
                }
                TileIndex srcIndex = new TileIndex(sourceTiles[0]);
                TileIndex tgtIndex = new TileIndex(tileDataList[0].tile);
                int y = y0;
                int yy = 0;
                while (y < maxY) {
                    srcIndex.calculateStride(y);
                    tgtIndex.calculateStride(y);
                    int x = x0;
                    int xx = 0;
                    while (x < maxX) {
                        int srcIdx = srcIndex.getIndex(x);
                        int tgtIdx = tgtIndex.getIndex(x);
                        this.getComplexScatterMatrix(srcIdx, dataBuffers, Sr, Si);
                        if (this.simulateNoiseFloor.booleanValue()) {
                            double[] dArray = Sr[0];
                            dArray[0] = dArray[0] + this.getGaussianRandom();
                            double[] dArray2 = Si[0];
                            dArray2[0] = dArray2[0] + this.getGaussianRandom();
                            Sr[0][1] = 0.5 * (Sr[0][1] + Sr[1][0]) + this.getGaussianRandom();
                            Sr[1][0] = Sr[0][1];
                            Si[0][1] = 0.5 * (Si[0][1] + Si[1][0]) + this.getGaussianRandom();
                            Si[1][0] = Si[0][1];
                            double[] dArray3 = Sr[1];
                            dArray3[1] = dArray3[1] + this.getGaussianRandom();
                            double[] dArray4 = Si[1];
                            dArray4[1] = dArray4[1] + this.getGaussianRandom();
                        } else {
                            Sr[0][1] = 0.5 * (Sr[0][1] + Sr[1][0]);
                            Sr[1][0] = Sr[0][1];
                            Si[0][1] = 0.5 * (Si[0][1] + Si[1][0]);
                            Si[1][0] = Si[0][1];
                        }
                        this.computeCompactPolCovarianceMatrixC2(Sr, Si, Cr, Ci);
                        for (TileData tileData : tileDataList) {
                            if (tileData.elem.isImaginary) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)Ci[tileData.elem.i][tileData.elem.j]);
                                continue;
                            }
                            tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)Cr[tileData.elem.i][tileData.elem.j]);
                        }
                        ++x;
                        ++xx;
                    }
                    ++y;
                    ++yy;
                }
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            }
        }
    }

    private double getGaussianRandom() {
        return this.random.nextGaussian() * this.sigma;
    }

    private void computeTileStackS2(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        double[][] Sr = new double[2][2];
        double[][] Si = new double[2][2];
        double[] kr = new double[2];
        double[] ki = new double[2];
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            try {
                TileData[] tileDataList = new TileData[bandList.targetBands.length];
                int i = 0;
                for (Band targetBand : bandList.targetBands) {
                    Tile targetTile = targetTiles.get(targetBand);
                    MatrixElem elem = this.matrixBandMap.get(targetBand);
                    tileDataList[i++] = new TileData(targetTile, elem);
                }
                Tile[] sourceTiles = new Tile[bandList.srcBands.length];
                ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
                for (int j = 0; j < bandList.srcBands.length; ++j) {
                    sourceTiles[j] = this.getSourceTile((RasterDataNode)bandList.srcBands[j], targetRectangle);
                    dataBuffers[j] = sourceTiles[j].getDataBuffer();
                }
                TileIndex srcIndex = new TileIndex(sourceTiles[0]);
                TileIndex tgtIndex = new TileIndex(tileDataList[0].tile);
                int y = y0;
                int yy = 0;
                while (y < maxY) {
                    srcIndex.calculateStride(y);
                    tgtIndex.calculateStride(y);
                    int x = x0;
                    int xx = 0;
                    while (x < maxX) {
                        int srcIdx = srcIndex.getIndex(x);
                        int tgtIdx = tgtIndex.getIndex(x);
                        this.getComplexScatterMatrix(srcIdx, dataBuffers, Sr, Si);
                        if (this.simulateNoiseFloor.booleanValue()) {
                            double[] dArray = Sr[0];
                            dArray[0] = dArray[0] + this.getGaussianRandom();
                            double[] dArray2 = Si[0];
                            dArray2[0] = dArray2[0] + this.getGaussianRandom();
                            Sr[0][1] = 0.5 * (Sr[0][1] + Sr[1][0]) + this.getGaussianRandom();
                            Sr[1][0] = Sr[0][1];
                            Si[0][1] = 0.5 * (Si[0][1] + Si[1][0]) + this.getGaussianRandom();
                            Si[1][0] = Si[0][1];
                            double[] dArray3 = Sr[1];
                            dArray3[1] = dArray3[1] + this.getGaussianRandom();
                            double[] dArray4 = Si[1];
                            dArray4[1] = dArray4[1] + this.getGaussianRandom();
                        } else {
                            Sr[0][1] = 0.5 * (Sr[0][1] + Sr[1][0]);
                            Sr[1][0] = Sr[0][1];
                            Si[0][1] = 0.5 * (Si[0][1] + Si[1][0]);
                            Si[1][0] = Si[0][1];
                        }
                        CompactPolDataSimulationOp.computeCompactPolScatteringVector(this.compactMode, this.useRCMConvention, Sr, Si, kr, ki);
                        for (TileData tileData : tileDataList) {
                            if (tileData.elem.isImaginary) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)ki[tileData.elem.i]);
                                continue;
                            }
                            tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)kr[tileData.elem.i]);
                        }
                        ++x;
                        ++xx;
                    }
                    ++y;
                    ++yy;
                }
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            }
        }
    }

    private void computeCompactPolCovarianceMatrixC2(double[][] scatterRe, double[][] scatterIm, double[][] Cr, double[][] Ci) {
        double[] kr = new double[2];
        double[] ki = new double[2];
        CompactPolDataSimulationOp.computeCompactPolScatteringVector(this.compactMode, this.useRCMConvention, scatterRe, scatterIm, kr, ki);
        this.computeCovarianceMatrixC2(kr, ki, Cr, Ci);
    }

    public static void computeCompactPolScatteringVector(String compactMode, boolean useRCMConvention, double[][] scatterRe, double[][] scatterIm, double[] kr, double[] ki) {
        double sHHr = scatterRe[0][0];
        double sHHi = scatterIm[0][0];
        double sHVr = scatterRe[0][1];
        double sHVi = scatterIm[0][1];
        double sVHr = scatterRe[1][0];
        double sVHi = scatterIm[1][0];
        double sVVr = scatterRe[1][1];
        double sVVi = scatterIm[1][1];
        if (compactMode.equals(quarterPi)) {
            kr[0] = (sHHr + sHVr) / Constants.sqrt2;
            ki[0] = (sHHi + sHVi) / Constants.sqrt2;
            kr[1] = (sVVr + sVHr) / Constants.sqrt2;
            ki[1] = (sVVi + sVHi) / Constants.sqrt2;
        } else if (compactMode.equals("Right Circular Hybrid Mode") && !useRCMConvention || compactMode.equals("Left Circular Hybrid Mode") && useRCMConvention) {
            kr[0] = (sHHr + sHVi) / Constants.sqrt2;
            ki[0] = (sHHi - sHVr) / Constants.sqrt2;
            kr[1] = (sVHr + sVVi) / Constants.sqrt2;
            ki[1] = (sVHi - sVVr) / Constants.sqrt2;
        } else if (compactMode.equals("Left Circular Hybrid Mode") && !useRCMConvention || compactMode.equals("Right Circular Hybrid Mode") && useRCMConvention) {
            kr[0] = (sHHr - sHVi) / Constants.sqrt2;
            ki[0] = (sHHi + sHVr) / Constants.sqrt2;
            kr[1] = (sVHr - sVVi) / Constants.sqrt2;
            ki[1] = (sVHi + sVVr) / Constants.sqrt2;
        } else if (compactMode.equals(dcp)) {
            kr[0] = (sHHr - sVVr + sHVi + sVHi) / 2.0;
            ki[0] = (sHHi - sVVi - sHVr - sVHr) / 2.0;
            kr[1] = (-sHHi - sVVi + sHVr - sVHr) / 2.0;
            ki[1] = (sHHr + sHHi + sHVi - sVHi) / 2.0;
        } else if (compactMode.equals(dualHHHV)) {
            kr[0] = sHHr;
            ki[0] = sHHi;
            kr[1] = sHVr;
            ki[1] = sHVi;
        } else if (compactMode.equals(dualVVVH)) {
            kr[0] = sVHr;
            ki[0] = sVHi;
            kr[1] = sVVr;
            ki[1] = sVVi;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CompactPolDataSimulationOp.class);
        }
    }

    private static class TileData {
        final Tile tile;
        final MatrixElem elem;
        final ProductData dataBuffer;

        public TileData(Tile tile, MatrixElem elem) {
            this.tile = tile;
            this.elem = elem;
            this.dataBuffer = tile.getDataBuffer();
        }
    }

    private static class MatrixElem {
        public final int i;
        public final int j;
        public final boolean isImaginary;

        MatrixElem(int i, int j, boolean isImaginary) {
            this.i = i;
            this.j = j;
            this.isImaginary = isImaginary;
        }
    }
}

