/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.symbols;

import com.google.bc.common.collect.Lists;
import com.google.bc.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Handle;
import org.renjin.gcc.codegen.FunctionGenerator;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.call.FunctionCallGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.gimple.CallingConvention;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleParameter;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleFunctionRef;
import org.renjin.gcc.gimple.expr.GimpleSymbolRef;
import org.renjin.gcc.gimple.type.GimpleType;
import org.renjin.gcc.symbols.GlobalSymbolTable;
import org.renjin.gcc.symbols.SymbolTable;

public class UnitSymbolTable
implements SymbolTable {
    private final GlobalSymbolTable globalSymbolTable;
    private String className;
    private final Map<Integer, Expr> variableMap = Maps.newHashMap();
    private final Map<String, List<FunctionGenerator>> functions = Maps.newHashMap();

    public UnitSymbolTable(GlobalSymbolTable globalSymbolTable, String className) {
        this.globalSymbolTable = globalSymbolTable;
        this.className = className;
    }

    @Override
    public Expr getVariable(GimpleSymbolRef ref) {
        Expr expr = this.variableMap.get(ref.getId());
        if (expr != null) {
            return expr;
        }
        return this.globalSymbolTable.getVariable(ref);
    }

    public Expr getGlobalVariable(GimpleVarDecl decl) {
        Expr expr = this.variableMap.get(decl.getId());
        if (expr == null) {
            throw new IllegalArgumentException("decl: " + decl);
        }
        return expr;
    }

    public void addGlobalVariable(GimpleVarDecl decl, Expr globalVar) {
        this.variableMap.put(decl.getId(), globalVar);
        if (decl.isExtern()) {
            this.globalSymbolTable.addVariable(decl.getName(), globalVar);
        }
    }

    public void addFunction(String className, GimpleFunction function, FunctionGenerator generator) {
        String fName = function.getName();
        if (!this.functions.containsKey(fName)) {
            this.functions.put(fName, new ArrayList());
        }
        this.functions.get(fName).add(generator);
        if (function.isExtern()) {
            this.globalSymbolTable.addFunction(className, generator);
        }
    }

    public Collection<FunctionGenerator> getFunctions() {
        ArrayList list = Lists.newArrayList();
        for (List<FunctionGenerator> fs : this.functions.values()) {
            list.addAll(fs);
        }
        return list;
    }

    @Override
    public Handle findHandle(GimpleFunctionRef functionRef, CallingConvention callingConvention) {
        if (this.functions.containsKey(functionRef.getName())) {
            return this.functions.get(functionRef.getName()).get(0).getMethodHandle();
        }
        return this.globalSymbolTable.findHandle(functionRef, callingConvention);
    }

    @Override
    public CallGenerator findCallGenerator(GimpleFunctionRef ref, List<GimpleExpr> operands, CallingConvention callingConvention) {
        if (this.functions.containsKey(ref.getName())) {
            for (FunctionGenerator functionGenerator : this.functions.get(ref.getName())) {
                if (functionGenerator.getFunction().getParameters().size() != operands.size()) continue;
                boolean matches = true;
                Iterator<GimpleParameter> it1 = functionGenerator.getFunction().getParameters().iterator();
                Iterator<GimpleExpr> it2 = operands.iterator();
                while (matches && it1.hasNext() && it2.hasNext()) {
                    GimpleType param = it1.next().getType();
                    GimpleType operand = it2.next().getType();
                    matches = matches && param.equals(operand);
                }
                if (!matches) continue;
                return new FunctionCallGenerator(functionGenerator);
            }
        }
        return this.globalSymbolTable.findCallGenerator(ref, operands, callingConvention);
    }
}

