/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.symbols;

import com.google.bc.common.base.Preconditions;
import com.google.bc.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Handle;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.gimple.CallingConvention;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleFunctionRef;
import org.renjin.gcc.gimple.expr.GimpleSymbolRef;
import org.renjin.gcc.symbols.SymbolTable;
import org.renjin.gcc.symbols.UnitSymbolTable;

public class LocalVariableTable
implements SymbolTable {
    private final UnitSymbolTable parent;
    private Map<Integer, Expr> variableMap = Maps.newHashMap();

    public LocalVariableTable(UnitSymbolTable parent) {
        this.parent = parent;
    }

    public void addVariable(Integer gimpleId, Expr variable) {
        Preconditions.checkNotNull((Object)variable);
        Preconditions.checkState((!this.variableMap.containsKey(gimpleId) ? 1 : 0) != 0, (Object)("variable already registered with id " + gimpleId));
        this.variableMap.put(gimpleId, variable);
    }

    @Override
    public Expr getVariable(GimpleSymbolRef ref) {
        Expr variable = this.variableMap.get(ref.getId());
        if (variable == null) {
            if (this.parent == null) {
                throw new IllegalStateException("No variable with " + ref.getName() + " [id=" + ref.getId() + "]");
            }
            return this.parent.getVariable(ref);
        }
        return variable;
    }

    public Expr getVariable(GimpleVarDecl decl) {
        Expr varGenerator = this.variableMap.get(decl.getId());
        if (varGenerator == null) {
            throw new IllegalStateException("No variable named " + decl.getName() + " [id=" + decl.getId() + "]");
        }
        return varGenerator;
    }

    @Override
    public Handle findHandle(GimpleFunctionRef functionRef, CallingConvention callingConvention) {
        return this.parent.findHandle(functionRef, callingConvention);
    }

    @Override
    public CallGenerator findCallGenerator(GimpleFunctionRef ref, List<GimpleExpr> operands, CallingConvention callingConvention) {
        return this.parent.findCallGenerator(ref, operands, callingConvention);
    }
}

