/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.symbols;

import com.google.bc.common.base.Preconditions;
import com.google.bc.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Handle;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.FunctionGenerator;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.call.FreeCallGenerator;
import org.renjin.gcc.codegen.call.FunctionCallGenerator;
import org.renjin.gcc.codegen.call.MallocCallGenerator;
import org.renjin.gcc.codegen.call.MemCmpCallGenerator;
import org.renjin.gcc.codegen.call.MemCopyCallGenerator;
import org.renjin.gcc.codegen.call.MemSetGenerator;
import org.renjin.gcc.codegen.call.ReallocCallGenerator;
import org.renjin.gcc.codegen.call.StaticMethodStrategy;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.lib.SymbolFunction;
import org.renjin.gcc.codegen.lib.SymbolLibrary;
import org.renjin.gcc.codegen.lib.SymbolMethod;
import org.renjin.gcc.codegen.type.TypeOracle;
import org.renjin.gcc.gimple.CallingConvention;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleFunctionRef;
import org.renjin.gcc.gimple.expr.GimpleSymbolRef;
import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.gcc.symbols.SymbolTable;

public class GlobalSymbolTable
implements SymbolTable {
    private TypeOracle typeOracle;
    private Map<String, CallGenerator> functions = Maps.newHashMap();
    private Map<String, Expr> globalVariables = Maps.newHashMap();

    public GlobalSymbolTable(TypeOracle typeOracle) {
        this.typeOracle = typeOracle;
    }

    @Override
    public CallGenerator findCallGenerator(GimpleFunctionRef ref, List<GimpleExpr> operands, CallingConvention callingConvention) {
        String mangledName = callingConvention.mangleFunctionName(ref.getName());
        CallGenerator generator = this.functions.get(mangledName);
        if (generator == null) {
            throw new UnsupportedOperationException("Could not find function '" + mangledName + "'");
        }
        return generator;
    }

    @Override
    public Handle findHandle(GimpleFunctionRef ref, CallingConvention callingConvention) {
        CallGenerator callGenerator = this.findCallGenerator(ref, null, callingConvention);
        if (callGenerator instanceof FunctionCallGenerator) {
            return ((FunctionCallGenerator)callGenerator).getStrategy().getMethodHandle();
        }
        throw new UnsupportedOperationException("callGenerator: " + callGenerator);
    }

    public void addDefaults() {
        this.addFunction("malloc", new MallocCallGenerator(this.typeOracle));
        this.addFunction("free", new FreeCallGenerator());
        this.addFunction("realloc", new ReallocCallGenerator(this.typeOracle));
        this.addFunction("__builtin_malloc__", new MallocCallGenerator(this.typeOracle));
        this.addFunction("__builtin_free__", new MallocCallGenerator(this.typeOracle));
        this.addFunction("__builtin_memcpy", new MemCopyCallGenerator(this.typeOracle));
        this.addFunction("__builtin_memcpy__", new MemCopyCallGenerator(this.typeOracle));
        this.addFunction("__builtin_memset__", new MemSetGenerator(this.typeOracle));
        this.addMethod("__builtin_log10__", Math.class, "log10");
        this.addFunction("memcpy", new MemCopyCallGenerator(this.typeOracle));
        this.addFunction("memcmp", new MemCmpCallGenerator(this.typeOracle));
        this.addFunction("memset", new MemSetGenerator(this.typeOracle));
        this.addMethods(Builtins.class);
        this.addMethods(Stdlib.class);
        this.addMethods(Mathlib.class);
    }

    public void addLibrary(SymbolLibrary lib) {
        for (SymbolFunction f : lib.getFunctions(this.typeOracle)) {
            this.addFunction(f.getAlias(), f.getCall());
        }
        for (SymbolMethod m : lib.getMethods()) {
            this.addMethod(m.getAlias(), m.getTargetClass(), m.getMethodName());
        }
    }

    public void addMethod(String functionName, Class<?> declaringClass) {
        this.addFunction(functionName, this.findMethod(declaringClass, functionName));
    }

    public void addMethod(String functionName, Class<?> declaringClass, String methodName) {
        this.addFunction(functionName, this.findMethod(declaringClass, methodName));
    }

    public void addFunction(String name, CallGenerator callGenerator) {
        this.functions.put(name, callGenerator);
    }

    public void addFunction(String className, FunctionGenerator function) {
        this.functions.put(function.getMangledName(), new FunctionCallGenerator(function));
    }

    public void addFunction(String functionName, Method method) {
        Preconditions.checkArgument((boolean)Modifier.isStatic(method.getModifiers()), (String)"Method '%s' must be static", (Object[])new Object[]{method});
        this.functions.put(functionName, new FunctionCallGenerator(new StaticMethodStrategy(this.typeOracle, method)));
    }

    public void addMethods(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getAnnotation(Deprecated.class) != null) continue;
            this.addFunction(method.getName(), method);
        }
    }

    private Method findMethod(Class<?> declaringClass, String methodName) {
        for (Method method : declaringClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new IllegalArgumentException(String.format("No method named '%s' in %s", methodName, declaringClass.getName()));
    }

    @Override
    public Expr getVariable(GimpleSymbolRef ref) {
        if (ref.getName() == null) {
            return null;
        }
        Expr expr = this.globalVariables.get(ref.getName());
        if (expr == null) {
            throw new InternalCompilerException("No such variable: " + ref);
        }
        return expr;
    }

    public void addVariable(String name, Expr expr) {
        this.globalVariables.put(name, expr);
    }

    public Set<Map.Entry<String, CallGenerator>> getFunctions() {
        return this.functions.entrySet();
    }
}

