/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.peephole;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;
import org.renjin.gcc.peephole.NodeIt;
import org.renjin.gcc.peephole.Pattern;
import org.renjin.gcc.peephole.PeepholeOptimization;

public class StoreLoad
implements PeepholeOptimization {
    @Override
    public boolean apply(NodeIt it) {
        if (it.matches(Pattern.STORE, Pattern.LOAD)) {
            VarInsnNode store = (VarInsnNode)it.get(0);
            VarInsnNode load = (VarInsnNode)it.get(1);
            if (store.var == load.var && this.countLoads(it.getList(), store.var) == 1) {
                it.remove(2);
                return true;
            }
        }
        return false;
    }

    private int countLoads(InsnList list, int var) {
        int count = 0;
        for (AbstractInsnNode node : list) {
            if (Pattern.LOAD.match(node)) {
                VarInsnNode load = (VarInsnNode)node;
                if (load.var != var) continue;
                ++count;
                continue;
            }
            if (node.getOpcode() != 132) continue;
            IincInsnNode inc = (IincInsnNode)node;
            if (inc.var != var) continue;
            ++count;
        }
        return count;
    }
}

