/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.peephole;

import com.google.bc.common.collect.Lists;
import com.google.bc.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.renjin.gcc.peephole.ConstantMath;
import org.renjin.gcc.peephole.IntegerIncrement;
import org.renjin.gcc.peephole.LoadLoad;
import org.renjin.gcc.peephole.NodeIt;
import org.renjin.gcc.peephole.PeepholeOptimization;
import org.renjin.gcc.peephole.StoreLoad;

public class PeepholeOptimizer {
    public static PeepholeOptimizer INSTANCE = new PeepholeOptimizer();
    private List<PeepholeOptimization> optimizations = Lists.newArrayList();

    public PeepholeOptimizer() {
        this.optimizations.add(new StoreLoad());
        this.optimizations.add(new LoadLoad());
        this.optimizations.add(new IntegerIncrement());
        this.optimizations.add(new ConstantMath());
    }

    public void optimize(MethodNode methodNode) {
        boolean changing;
        methodNode.accept((MethodVisitor)new TraceMethodVisitor((Printer)new Textifier()));
        NodeIt it = new NodeIt(methodNode.instructions, this.findJumpTargets(methodNode));
        do {
            changing = false;
            for (PeepholeOptimization optimization : this.optimizations) {
                if (!optimization.apply(it)) continue;
                changing = true;
            }
        } while (changing || it.next());
    }

    private Set<Label> findJumpTargets(MethodNode methodNode) {
        HashSet targets = Sets.newHashSet();
        for (AbstractInsnNode node : methodNode.instructions) {
            if (!(node instanceof JumpInsnNode)) continue;
            JumpInsnNode jumpNode = (JumpInsnNode)node;
            targets.add(jumpNode.label.getLabel());
        }
        return targets;
    }
}

