/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.peephole;

import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.renjin.gcc.peephole.Pattern;

public class NodeIt {
    private InsnList list;
    private Set<Label> jumpTargets;
    private AbstractInsnNode current;

    public NodeIt(InsnList list, Set<Label> jumpTargets) {
        this.list = list;
        this.jumpTargets = jumpTargets;
        this.current = list.getFirst();
        if (this.current == null) {
            throw new IllegalStateException("Empty instruction list");
        }
    }

    public boolean matches(Pattern ... patterns) {
        AbstractInsnNode node = this.current;
        for (Pattern pattern : patterns) {
            if (node == null) {
                return false;
            }
            if (!pattern.match(node)) {
                return false;
            }
            node = this.nextIgnoringLabels(node);
        }
        return true;
    }

    public InsnList getList() {
        return this.list;
    }

    public <X extends AbstractInsnNode> X get(int offset) {
        AbstractInsnNode node = this.current;
        while (offset > 0) {
            node = this.nextIgnoringLabels(node);
            --offset;
        }
        return (X)node;
    }

    public void remove(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count: " + count);
        }
        if (count == 0) {
            return;
        }
        AbstractInsnNode deleting = this.current;
        this.current = this.current.getPrevious();
        while (count > 0) {
            AbstractInsnNode next = deleting.getNext();
            if (!this.ignored(deleting)) {
                this.list.remove(deleting);
                --count;
            }
            deleting = next;
        }
        if (this.current == null) {
            this.current = this.list.getFirst();
        }
    }

    public void replace(int offset, AbstractInsnNode node) {
        this.list.set(this.get(offset), node);
    }

    public void insert(AbstractInsnNode ... nodes) {
        InsnList newList = new InsnList();
        for (AbstractInsnNode node : nodes) {
            newList.add(node);
        }
        this.list.insert(this.current, newList);
    }

    public boolean next() {
        this.current = this.nextIgnoringLabels(this.current);
        return this.current != null;
    }

    private AbstractInsnNode nextIgnoringLabels(AbstractInsnNode node) {
        AbstractInsnNode next = node.getNext();
        if (next == null) {
            return null;
        }
        if (this.ignored(next)) {
            return this.nextIgnoringLabels(next);
        }
        return next;
    }

    private boolean ignored(AbstractInsnNode node) {
        if (node instanceof LabelNode) {
            LabelNode labelNode = (LabelNode)node;
            return !this.jumpTargets.contains(labelNode.getLabel());
        }
        return node instanceof LineNumberNode;
    }
}

