/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.peephole;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.renjin.gcc.peephole.Instructions;
import org.renjin.gcc.peephole.NodeIt;
import org.renjin.gcc.peephole.Pattern;
import org.renjin.gcc.peephole.PeepholeOptimization;

public class IntegerIncrement
implements PeepholeOptimization {
    @Override
    public boolean apply(NodeIt it) {
        if (it.matches(Pattern.ILOAD, Pattern.ICONST, Pattern.IADD, Pattern.ISTORE)) {
            VarInsnNode load = (VarInsnNode)it.get(0);
            int increment = Instructions.getInteger(it.get(1));
            VarInsnNode store = (VarInsnNode)it.get(3);
            if (load.var == store.var) {
                it.remove(4);
                if (increment != 0) {
                    it.insert(new AbstractInsnNode[]{new IincInsnNode(load.var, increment)});
                }
                return true;
            }
        }
        return false;
    }
}

