/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.peephole;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.util.Textifier;

public class Instructions {
    public static int getInteger(AbstractInsnNode node) {
        switch (node.getOpcode()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 16: 
            case 17: {
                return ((IntInsnNode)node).operand;
            }
        }
        throw new IllegalArgumentException("node: " + Textifier.OPCODES[node.getOpcode()]);
    }

    public static AbstractInsnNode constantNode(int cst) {
        if (cst >= -1 && cst <= 5) {
            return new InsnNode(3 + cst);
        }
        if (cst >= -128 && cst <= 127) {
            return new IntInsnNode(16, cst);
        }
        if (cst >= Short.MIN_VALUE && cst <= Short.MAX_VALUE) {
            return new IntInsnNode(17, cst);
        }
        return new LdcInsnNode((Object)cst);
    }
}

