/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.peephole;

import org.renjin.gcc.peephole.Instructions;
import org.renjin.gcc.peephole.NodeIt;
import org.renjin.gcc.peephole.Pattern;
import org.renjin.gcc.peephole.PeepholeOptimization;

public class ConstantMath
implements PeepholeOptimization {
    @Override
    public boolean apply(NodeIt it) {
        if (it.matches(Pattern.ICONST, Pattern.ICONST, Pattern.I_ARITHMETIC)) {
            int x = Instructions.getInteger(it.get(0));
            int y = Instructions.getInteger(it.get(1));
            int op = it.get(2).getOpcode();
            it.remove(3);
            it.insert(Instructions.constantNode(this.compute(op, x, y)));
        }
        return false;
    }

    private int compute(int op, int x, int y) {
        switch (op) {
            case 96: {
                return x + y;
            }
            case 100: {
                return x - y;
            }
            case 108: {
                return x / y;
            }
            case 104: {
                return x * y;
            }
        }
        throw new IllegalArgumentException("opcode: " + op);
    }
}

