/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.type;

import com.google.bc.common.collect.Lists;
import java.util.List;
import org.renjin.gcc.gimple.expr.GimpleFieldRef;
import org.renjin.gcc.gimple.type.GimpleField;

public class GimpleRecordTypeDef {
    private String id;
    private String name;
    private boolean union;
    private int size;
    private List<GimpleField> fields = Lists.newArrayList();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnion() {
        return this.union;
    }

    public void setUnion(boolean union) {
        this.union = union;
    }

    public List<GimpleField> getFields() {
        return this.fields;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("struct ").append(this.name).append(" {\n");
        for (GimpleField field : this.fields) {
            out.append(String.format("    %s %s\n", field.getType(), field.getName()));
        }
        out.append("}");
        return out.toString();
    }

    public GimpleField findField(GimpleFieldRef fieldRef) {
        for (GimpleField field : this.fields) {
            int fieldStart = field.getOffset();
            int fieldEnd = fieldStart + field.getType().getSize();
            if (fieldRef.getOffset() < fieldStart || fieldRef.getOffset() >= fieldEnd) continue;
            return field;
        }
        throw new IllegalArgumentException("No such field: " + fieldRef.getName());
    }
}

