/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.type;

import com.google.bc.common.base.Preconditions;
import org.objectweb.asm.Type;
import org.renjin.gcc.gimple.type.GimplePrimitiveType;

public class GimpleRealType
extends GimplePrimitiveType {
    public GimpleRealType() {
    }

    public GimpleRealType(int precision) {
        this.setSize(precision);
    }

    public int getPrecision() {
        return this.getSize();
    }

    public void setPrecision(int precision) {
        Preconditions.checkArgument((precision == 32 || precision == 64 ? 1 : 0) != 0);
        this.setSize(precision);
    }

    public String toString() {
        return "real" + this.getPrecision();
    }

    public int hashCode() {
        return this.getSize();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GimpleRealType other = (GimpleRealType)obj;
        return this.getSize() == other.getSize();
    }

    @Override
    public int localVariableSlots() {
        if (this.getPrecision() == 64) {
            return 2;
        }
        return 1;
    }

    @Override
    public Type jvmType() {
        switch (this.getPrecision()) {
            case 32: {
                return Type.FLOAT_TYPE;
            }
            case 64: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new UnsupportedOperationException("Precision: " + this.getSize());
    }

    @Override
    public int sizeOf() {
        return this.getSize() / 8;
    }
}

