/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.type;

import org.objectweb.asm.Type;
import org.renjin.gcc.gimple.type.AbstractGimpleType;
import org.renjin.gcc.gimple.type.GimpleBooleanType;
import org.renjin.gcc.gimple.type.GimpleIntegerType;
import org.renjin.gcc.gimple.type.GimpleRealType;
import org.renjin.gcc.gimple.type.GimpleType;

public abstract class GimplePrimitiveType
extends AbstractGimpleType {
    public abstract int localVariableSlots();

    public abstract Type jvmType();

    public static GimplePrimitiveType fromJvmType(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return new GimpleBooleanType();
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return new GimpleRealType(64);
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return new GimpleRealType(32);
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return new GimpleIntegerType(32);
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return new GimpleIntegerType(64);
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return GimpleIntegerType.unsigned(16);
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return new GimpleIntegerType(16);
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return new GimpleIntegerType(8);
        }
        throw new UnsupportedOperationException("type: " + type);
    }

    public static GimpleType fromJvmType(Class<?> primitiveClass) {
        return GimplePrimitiveType.fromJvmType(Type.getType(primitiveClass));
    }
}

