/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.type;

import org.objectweb.asm.Type;
import org.renjin.gcc.gimple.type.GimplePrimitiveType;

public class GimpleIntegerType
extends GimplePrimitiveType {
    private boolean unsigned;

    public GimpleIntegerType() {
    }

    public GimpleIntegerType(int precision) {
        this.setSize(precision);
    }

    public int getPrecision() {
        return this.getSize();
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(boolean unsigned) {
        this.unsigned = unsigned;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.unsigned) {
            s.append("unsigned ");
        }
        s.append("int" + this.getPrecision());
        return s.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getSize();
        result = 31 * result + (this.unsigned ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GimpleIntegerType other = (GimpleIntegerType)obj;
        if (this.getPrecision() != other.getPrecision()) {
            return false;
        }
        return this.unsigned == other.unsigned;
    }

    @Override
    public int localVariableSlots() {
        if (this.getPrecision() > 32) {
            return 2;
        }
        return 1;
    }

    @Override
    public Type jvmType() {
        if (this.getPrecision() == 64) {
            return Type.LONG_TYPE;
        }
        if (this.getPrecision() == 8) {
            return Type.BYTE_TYPE;
        }
        if (this.getPrecision() == 16) {
            if (this.unsigned) {
                return Type.CHAR_TYPE;
            }
            return Type.SHORT_TYPE;
        }
        return Type.INT_TYPE;
    }

    @Override
    public int sizeOf() {
        return Math.max(1, this.getSize() / 8);
    }

    public static GimpleIntegerType unsigned(int bits) {
        GimpleIntegerType type = new GimpleIntegerType(bits);
        type.unsigned = true;
        return type;
    }
}

