/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.type;

import com.google.bc.common.base.Preconditions;
import org.objectweb.asm.Type;
import org.renjin.gcc.gimple.type.AbstractGimpleType;
import org.renjin.gcc.gimple.type.GimpleRealType;

public class GimpleComplexType
extends AbstractGimpleType {
    public GimpleComplexType() {
    }

    public GimpleComplexType(GimpleRealType partType) {
        this.setSize(partType.getSize() * 2);
    }

    @Override
    public int sizeOf() {
        return this.getSize() / 8;
    }

    public String toString() {
        return "complex";
    }

    @Override
    public void setSize(int size) {
        Preconditions.checkArgument((size == 64 || size == 128 ? 1 : 0) != 0, (Object)("Invalid size: " + size));
        super.setSize(size);
    }

    public Type getJvmPartType() {
        return this.getPartType().jvmType();
    }

    public Type getJvmPartArrayType() {
        return Type.getType((String)("[" + this.getJvmPartType().getDescriptor()));
    }

    public GimpleRealType getPartType() {
        return new GimpleRealType(this.getSize() / 2);
    }

    public boolean hasValidSize() {
        return this.getSize() == 64 || this.getSize() == 128;
    }
}

