/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.statement;

import com.google.bc.common.base.Joiner;
import com.google.bc.common.base.Preconditions;
import com.google.bc.common.base.Predicate;
import com.google.bc.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.renjin.gcc.gimple.GimpleVisitor;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.statement.GimpleStatement;

public class GimpleSwitch
extends GimpleStatement {
    private GimpleExpr value;
    private List<Case> cases = Lists.newArrayList();
    private Case defaultCase;

    public List<Case> getCases() {
        return this.cases;
    }

    public int getCaseCount() {
        int count = 0;
        for (Case aCase : this.cases) {
            count += aCase.getRange();
        }
        return count;
    }

    public Case getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(Case defaultCase) {
        this.defaultCase = defaultCase;
    }

    public void setValue(GimpleExpr value) {
        this.value = value;
    }

    @Override
    public List<GimpleExpr> getOperands() {
        return Collections.singletonList(this.value);
    }

    @Override
    protected void findUses(Predicate<? super GimpleExpr> predicate, List<GimpleExpr> results) {
        this.value.findOrDescend(predicate, results);
    }

    @Override
    public boolean replace(Predicate<? super GimpleExpr> predicate, GimpleExpr replacement) {
        if (predicate.apply((Object)this.value)) {
            this.value = replacement;
            return true;
        }
        return this.value.replace(predicate, replacement);
    }

    @Override
    public void replaceAll(Predicate<? super GimpleExpr> predicate, GimpleExpr newExpr) {
        if (predicate.apply((Object)this.value)) {
            this.value = newExpr;
        }
    }

    @Override
    public Set<Integer> getJumpTargets() {
        HashSet<Integer> targets = new HashSet<Integer>();
        for (Case aCase : this.cases) {
            targets.add(aCase.getBasicBlockIndex());
        }
        if (this.defaultCase != null) {
            targets.add(this.defaultCase.getBasicBlockIndex());
        }
        return targets;
    }

    public GimpleExpr getValue() {
        return this.value;
    }

    @Override
    public void visit(GimpleVisitor visitor) {
        visitor.visitSwitch(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("gimple_switch<").append(this.value).append("\n");
        Joiner.on((String)"\n").appendTo(sb, this.cases);
        if (this.defaultCase != null) {
            sb.append(String.format("\nDefault: goto %d", this.defaultCase.basicBlockIndex));
        }
        return sb.toString();
    }

    public static class Case {
        private int low;
        private int high;
        private int basicBlockIndex;

        public int getLow() {
            return this.low;
        }

        public void setLow(int low) {
            this.low = low;
        }

        public int getHigh() {
            return this.high;
        }

        public void setHigh(int high) {
            this.high = high;
        }

        public int getBasicBlockIndex() {
            return this.basicBlockIndex;
        }

        public void setBasicBlockIndex(int basicBlockIndex) {
            this.basicBlockIndex = basicBlockIndex;
        }

        public String toString() {
            return String.format("[ %d, %d]: %d", this.low, this.high, this.basicBlockIndex);
        }

        public int getRange() {
            Preconditions.checkState((this.low <= this.high ? 1 : 0) != 0);
            return this.high - this.low + 1;
        }
    }
}

