/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.statement;

import org.renjin.gcc.gimple.GimpleLabel;

public class GimpleEdge {
    public static final int EDGE_FALLTHRU = 1;
    public static final int EDGE_ABNORMAL = 2;
    public static final int EDGE_ABNORMAL_CALL = 4;
    public static final int EDGE_EH = 8;
    public static final int EDGE_FAKE = 16;
    public static final int EDGE_DFS_BACK = 32;
    public static final int EDGE_CAN_FALLTHRU = 64;
    public static final int EDGE_IRREDUCIBLE_LOOP = 128;
    public static final int EDGE_SIBCALL = 256;
    public static final int EDGE_LOOP_EXIT = 512;
    public static final int EDGE_TRUE_VALUE = 1024;
    public static final int EDGE_FALSE_VALUE = 2048;
    public static final int EDGE_EXECUTABLE = 4096;
    public static final int EDGE_CROSSING = 8192;
    public static final int EDGE_ALL_FLAGS = 16383;
    public static final int EDGE_COMPLEX = 14;
    private int flags;
    private int source;
    private int target;

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public int getTarget() {
        return this.target;
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public GimpleLabel getSourceLabel() {
        return new GimpleLabel("bb" + this.source);
    }

    public GimpleLabel getTargetLabel() {
        return new GimpleLabel("bb" + this.target);
    }

    public String toString() {
        return "edge <" + this.getEdgeTypeName() + ">(" + this.getSourceLabel() + "," + this.getTargetLabel() + ")";
    }

    private String getEdgeTypeName() {
        StringBuilder sb = new StringBuilder();
        String[] names = new String[]{"EDGE_FALLTHRU", "EDGE_ABNORMAL", "EDGE_ABNORMAL_CALL", "EDGE_EH,EDGE_FAKE", "EDGE_DFS_BACK", "EDGE_CAN_FALLTHRU", "EDGE_IRREDUCIBLE_LOOP", "EDGE_SIBCALL", "EDGE_LOOP_EXIT", "EDGE_TRUE_VALUE", "EDGE_FALSE_VALUE", "EDGE_EXECUTABLE", "EDGE_CROSSING"};
        boolean needsComma = false;
        for (int i = 0; i < 15; ++i) {
            if ((this.flags & 1 << i) == 0) continue;
            if (needsComma) {
                sb.append(",");
            } else {
                needsComma = true;
            }
            sb.append(names[i]);
        }
        return sb.toString();
    }
}

