/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.statement;

import com.google.bc.common.base.Joiner;
import com.google.bc.common.base.Predicate;
import com.google.bc.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.renjin.gcc.gimple.GimpleOp;
import org.renjin.gcc.gimple.GimpleVisitor;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.statement.GimpleStatement;

public class GimpleConditional
extends GimpleStatement {
    private GimpleOp operator;
    private List<GimpleExpr> operands;
    private int trueLabel;
    private int falseLabel;

    GimpleConditional() {
    }

    void setOperator(GimpleOp op) {
        this.operator = op;
    }

    void setOperands(List<GimpleExpr> operands) {
        this.operands = operands;
    }

    public GimpleOp getOperator() {
        return this.operator;
    }

    @Override
    public List<GimpleExpr> getOperands() {
        return this.operands;
    }

    public int getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(int trueLabel) {
        this.trueLabel = trueLabel;
    }

    public int getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(int falseLabel) {
        this.falseLabel = falseLabel;
    }

    @Override
    public boolean replace(Predicate<? super GimpleExpr> predicate, GimpleExpr replacement) {
        for (int i = 0; i < this.operands.size(); ++i) {
            if (predicate.apply((Object)this.operands.get(i))) {
                this.operands.set(i, replacement);
                return true;
            }
            if (!this.operands.get(i).replace(predicate, replacement)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void findUses(Predicate<? super GimpleExpr> predicate, List<GimpleExpr> results) {
        this.findUses(this.operands, predicate, results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("gimple_cond<").append((Object)this.operator).append(",");
        Joiner.on((String)", ").appendTo(sb, this.operands);
        sb.append("> goto <").append("BB").append(this.trueLabel).append("> else goto <").append("BB").append(this.falseLabel).append(">");
        return sb.toString();
    }

    @Override
    public Set<Integer> getJumpTargets() {
        return Sets.newHashSet((Object[])new Integer[]{this.trueLabel, this.falseLabel});
    }

    @Override
    public void visit(GimpleVisitor visitor) {
        visitor.visitConditional(this);
    }

    public GimpleExpr getOperand(int index) {
        return this.operands.get(index);
    }

    @Override
    public void replaceAll(Predicate<? super GimpleExpr> predicate, GimpleExpr newExpr) {
        this.replaceAll(predicate, this.operands, newExpr);
    }
}

