/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.statement;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.bc.common.base.Joiner;
import com.google.bc.common.base.Predicate;
import com.google.bc.common.collect.Lists;
import java.util.List;
import org.renjin.gcc.gimple.GimpleVisitor;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleLValue;
import org.renjin.gcc.gimple.expr.GimpleSymbolRef;
import org.renjin.gcc.gimple.statement.GimpleStatement;

public class GimpleCall
extends GimpleStatement {
    private GimpleExpr function;
    private List<GimpleExpr> operands = Lists.newArrayList();
    private GimpleLValue lhs;

    public GimpleExpr getFunction() {
        return this.function;
    }

    @Override
    @JsonProperty(value="arguments")
    public List<GimpleExpr> getOperands() {
        return this.operands;
    }

    public GimpleExpr getOperand(int i) {
        return this.operands.get(i);
    }

    public GimpleLValue getLhs() {
        return this.lhs;
    }

    public void setFunction(GimpleExpr function) {
        this.function = function;
    }

    public void setLhs(GimpleLValue lhs) {
        this.lhs = lhs;
    }

    @Override
    public boolean replace(Predicate<? super GimpleExpr> predicate, GimpleExpr replacement) {
        if (predicate.apply((Object)this.function)) {
            this.function = replacement;
            return true;
        }
        for (int i = 0; i < this.operands.size(); ++i) {
            if (predicate.apply((Object)this.operands.get(i))) {
                this.operands.set(i, replacement);
                return true;
            }
            if (!this.operands.get(i).replace(predicate, replacement)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void findUses(Predicate<? super GimpleExpr> predicate, List<GimpleExpr> results) {
        this.function.findOrDescend(predicate, results);
        for (GimpleExpr argument : this.operands) {
            argument.findOrDescend(predicate, results);
        }
        if (this.lhs != null && !(this.lhs instanceof GimpleSymbolRef)) {
            this.lhs.find(predicate, results);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lhs);
        sb.append(" = ");
        sb.append("gimple_call <").append(this.function).append(", ");
        Joiner.on((String)", ").appendTo(sb, this.operands);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public void visit(GimpleVisitor visitor) {
        visitor.visitCall(this);
    }

    @Override
    public boolean lhsMatches(Predicate<? super GimpleLValue> predicate) {
        if (this.lhs != null) {
            return predicate.apply((Object)this.lhs);
        }
        return false;
    }

    @Override
    public void replaceAll(Predicate<? super GimpleExpr> predicate, GimpleExpr newExpr) {
        if (predicate.apply((Object)this.lhs)) {
            this.lhs = (GimpleLValue)newExpr;
        }
        this.replaceAll(predicate, this.operands, newExpr);
    }
}

