/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.statement;

import com.google.bc.common.base.Joiner;
import com.google.bc.common.base.Predicate;
import com.google.bc.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.renjin.gcc.gimple.GimpleOp;
import org.renjin.gcc.gimple.GimpleVisitor;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleLValue;
import org.renjin.gcc.gimple.expr.GimpleSymbolRef;
import org.renjin.gcc.gimple.statement.GimpleStatement;

public class GimpleAssignment
extends GimpleStatement {
    private GimpleOp operator;
    private GimpleLValue lhs;
    private List<GimpleExpr> operands = Lists.newArrayList();

    public GimpleAssignment() {
    }

    public GimpleAssignment(GimpleOp op, GimpleLValue lhs, GimpleExpr ... arguments) {
        this.operator = op;
        this.lhs = lhs;
        this.operands.addAll(Arrays.asList(arguments));
    }

    public GimpleOp getOperator() {
        return this.operator;
    }

    public void setOperator(GimpleOp op) {
        this.operator = op;
    }

    public GimpleLValue getLHS() {
        return this.lhs;
    }

    @Override
    public List<GimpleExpr> getOperands() {
        return this.operands;
    }

    public void setLhs(GimpleLValue lhs) {
        this.lhs = lhs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("gimple_assign<").append((Object)this.operator).append(", ").append(this.lhs).append(", ");
        Joiner.on((String)", ").appendTo(sb, this.operands);
        sb.append(">");
        if (this.getLineNumber() != null) {
            sb.append("  #").append(this.getLineNumber());
        }
        return sb.toString();
    }

    @Override
    public void visit(GimpleVisitor visitor) {
        visitor.visitAssignment(this);
    }

    @Override
    public boolean lhsMatches(Predicate<? super GimpleLValue> predicate) {
        return predicate.apply((Object)this.lhs);
    }

    @Override
    protected void findUses(Predicate<? super GimpleExpr> predicate, List<GimpleExpr> results) {
        this.findUses(this.operands, predicate, results);
        if (!(this.lhs instanceof GimpleSymbolRef)) {
            this.lhs.find(predicate, results);
        }
    }

    @Override
    public boolean replace(Predicate<? super GimpleExpr> predicate, GimpleExpr replacement) {
        if (predicate.apply((Object)this.lhs)) {
            this.lhs = (GimpleLValue)replacement;
            return true;
        }
        for (int i = 0; i < this.operands.size(); ++i) {
            if (predicate.apply((Object)this.operands.get(i))) {
                this.operands.set(i, replacement);
                return true;
            }
            if (!this.operands.get(i).replace(predicate, replacement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void replaceAll(Predicate<? super GimpleExpr> predicate, GimpleExpr newExpr) {
        if (predicate.apply((Object)this.lhs)) {
            this.lhs = (GimpleLValue)newExpr;
        }
        this.replaceAll(predicate, this.operands, newExpr);
    }
}

