/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple.expr;

import com.google.bc.common.base.Predicate;
import java.util.List;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleIntegerConstant;
import org.renjin.gcc.gimple.expr.GimpleLValue;
import org.renjin.gcc.gimple.type.GimpleType;

public class GimpleMemRef
extends GimpleLValue {
    private GimpleExpr pointer;
    private GimpleExpr offset;

    public GimpleMemRef() {
    }

    public GimpleMemRef(GimpleExpr pointer) {
        this.pointer = pointer;
        this.offset = new GimpleIntegerConstant();
        this.offset.setType(pointer.getType());
        this.setType((GimpleType)pointer.getType().getBaseType());
    }

    public GimpleExpr getPointer() {
        return this.pointer;
    }

    public void setPointer(GimpleExpr pointer) {
        this.pointer = pointer;
    }

    public GimpleExpr getOffset() {
        return this.offset;
    }

    public void setOffset(GimpleExpr offset) {
        this.offset = offset;
    }

    public String toString() {
        if (this.isOffsetZero()) {
            return "*" + this.pointer;
        }
        return "*(" + this.pointer + "+" + this.offset + ")";
    }

    @Override
    public void find(Predicate<? super GimpleExpr> predicate, List<GimpleExpr> results) {
        this.findOrDescend(this.pointer, predicate, results);
        this.findOrDescend(this.offset, predicate, results);
    }

    @Override
    public boolean replace(Predicate<? super GimpleExpr> predicate, GimpleExpr replacement) {
        if (predicate.apply((Object)this.pointer)) {
            this.pointer = replacement;
            return true;
        }
        if (predicate.apply((Object)this.offset)) {
            this.offset = replacement;
            return true;
        }
        return false;
    }

    public boolean isOffsetZero() {
        return this.offset instanceof GimpleIntegerConstant && ((GimpleIntegerConstant)this.offset).getNumberValue().intValue() == 0;
    }
}

