/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.bc.common.base.Charsets;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleOp;
import org.renjin.gcc.gimple.GimpleOpDeserializer;

public class GimpleParser {
    private final ObjectMapper mapper;

    public GimpleParser() {
        SimpleModule gimpleModule = new SimpleModule("Gimple", Version.unknownVersion()).addDeserializer(GimpleOp.class, (JsonDeserializer)new GimpleOpDeserializer());
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)gimpleModule);
    }

    public GimpleCompilationUnit parse(Reader reader) throws IOException {
        GimpleCompilationUnit unit = (GimpleCompilationUnit)this.mapper.readValue(reader, GimpleCompilationUnit.class);
        for (GimpleFunction function : unit.getFunctions()) {
            function.setUnit(unit);
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GimpleCompilationUnit parse(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            GimpleCompilationUnit gimpleCompilationUnit = this.parse(reader);
            return gimpleCompilationUnit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GimpleCompilationUnit parse(URL resource) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(resource.openStream(), Charsets.UTF_8);){
            GimpleCompilationUnit gimpleCompilationUnit = this.parse(reader);
            return gimpleCompilationUnit;
        }
    }
}

