/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.bc.common.base.Joiner;
import com.google.bc.common.base.Predicate;
import com.google.bc.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.gimple.CallingConvention;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleParameter;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.GimpleVisitor;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleLValue;
import org.renjin.gcc.gimple.expr.GimpleVariableRef;
import org.renjin.gcc.gimple.statement.GimpleStatement;
import org.renjin.gcc.gimple.type.GimpleType;

public class GimpleFunction {
    private int id;
    private String name;
    private CallingConvention callingConvention;
    private GimpleType returnType;
    private GimpleCompilationUnit unit;
    private List<GimpleBasicBlock> basicBlocks = Lists.newArrayList();
    private List<GimpleParameter> parameters = Lists.newArrayList();
    private List<GimpleVarDecl> variableDeclarations = Lists.newArrayList();
    private boolean extern;

    public void setCallingConvention(CallingConvention callingConvention) {
        this.callingConvention = callingConvention;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getMangledName() {
        return this.callingConvention.mangleFunctionName(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<GimpleVarDecl> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public GimpleCompilationUnit getUnit() {
        return this.unit;
    }

    public void setUnit(GimpleCompilationUnit unit) {
        this.unit = unit;
    }

    public GimpleVarDecl addVarDecl(GimpleType type) {
        int id = 1000;
        while (this.isIdInUse(id)) {
            ++id;
        }
        GimpleVarDecl decl = new GimpleVarDecl();
        decl.setId(id);
        decl.setType(type);
        this.variableDeclarations.add(decl);
        return decl;
    }

    private boolean isIdInUse(int varDeclId) {
        for (GimpleVarDecl variableDeclaration : this.variableDeclarations) {
            if (variableDeclaration.getId() != varDeclId) continue;
            return true;
        }
        for (GimpleParameter gimpleParameter : this.getParameters()) {
            if (gimpleParameter.getId() != varDeclId) continue;
            return true;
        }
        return false;
    }

    public boolean isExtern() {
        return this.extern;
    }

    public void setExtern(boolean extern) {
        this.extern = extern;
    }

    public List<GimpleParameter> getParameters() {
        return this.parameters;
    }

    @JsonSetter
    public void setBasicBlocks(List<GimpleBasicBlock> basicBlocks) {
        this.basicBlocks = basicBlocks;
    }

    public void setBasicBlocks(GimpleBasicBlock ... blocks) {
        this.setBasicBlocks(Arrays.asList(blocks));
    }

    public void setParameters(List<GimpleParameter> parameters) {
        this.parameters = parameters;
    }

    public void visitIns(GimpleVisitor visitor) {
        for (GimpleBasicBlock bb : this.basicBlocks) {
            visitor.blockStart(bb);
            for (GimpleStatement ins : bb.getStatements()) {
                ins.visit(visitor);
            }
        }
    }

    public List<GimpleBasicBlock> getBasicBlocks() {
        return this.basicBlocks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" (");
        Joiner.on((String)", ").appendTo(sb, this.parameters);
        sb.append(")\n");
        sb.append("{\n");
        for (GimpleVarDecl decl : this.variableDeclarations) {
            sb.append(decl).append("\n");
        }
        for (GimpleBasicBlock bb : this.basicBlocks) {
            sb.append(bb.toString());
        }
        sb.append("}\n");
        return sb.toString();
    }

    public CallingConvention getCallingConvention() {
        return this.callingConvention;
    }

    public GimpleType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(GimpleType returnType) {
        this.returnType = returnType;
    }

    public boolean lhsMatches(Predicate<? super GimpleLValue> predicate) {
        for (GimpleBasicBlock basicBlock : this.basicBlocks) {
            for (GimpleStatement ins : basicBlock.getStatements()) {
                if (!ins.lhsMatches(predicate)) continue;
                return true;
            }
        }
        return false;
    }

    public void replaceAll(Predicate<? super GimpleExpr> predicate, GimpleExpr newExpr) {
        for (GimpleBasicBlock basicBlock : this.basicBlocks) {
            basicBlock.replaceAll(predicate, newExpr);
        }
    }

    public void removeVariable(GimpleVariableRef ref) {
        Iterator<GimpleVarDecl> it = this.variableDeclarations.iterator();
        while (it.hasNext()) {
            if (it.next().getId() != ref.getId()) continue;
            it.remove();
            return;
        }
        throw new InternalCompilerException("No such variable: " + ref);
    }

    public GimpleBasicBlock getLastBasicBlock() {
        return this.basicBlocks.get(this.basicBlocks.size() - 1);
    }
}

