/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple;

import com.google.bc.common.base.Joiner;
import com.google.bc.common.base.Preconditions;
import com.google.bc.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.renjin.gcc.gimple.CallingConvention;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.type.GimpleRecordTypeDef;

public class GimpleCompilationUnit {
    private final List<GimpleFunction> functions = Lists.newArrayList();
    private final List<GimpleRecordTypeDef> recordTypes = Lists.newArrayList();
    private final List<GimpleVarDecl> globalVariables = Lists.newArrayList();
    private CallingConvention callingConvention;
    private File sourceFile;

    public String getName() {
        if (this.sourceFile == null) {
            throw new IllegalStateException("sourceFile property is null");
        }
        String filename = this.sourceFile.getName();
        int firstDot = filename.indexOf(46);
        if (firstDot == -1) {
            throw new IllegalStateException("Expected file name ending in .xx.gimple");
        }
        return filename.substring(0, firstDot);
    }

    public CallingConvention getCallingConvention() {
        return this.callingConvention;
    }

    public void setCallingConvention(CallingConvention callingConvention) {
        this.callingConvention = callingConvention;
    }

    public String getSourceName() {
        Preconditions.checkState((boolean)this.sourceFile.getName().endsWith(".gimple"), (Object)"Source file must end in .gimple");
        return this.sourceFile.getName().substring(0, this.sourceFile.getName().length() - ".gimple".length());
    }

    public List<GimpleFunction> getFunctions() {
        return this.functions;
    }

    public List<GimpleRecordTypeDef> getRecordTypes() {
        return this.recordTypes;
    }

    public List<GimpleVarDecl> getGlobalVariables() {
        return this.globalVariables;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String toString() {
        return Joiner.on((String)"\n").join(this.functions);
    }
}

