/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.gimple;

import com.google.bc.common.base.Predicate;
import com.google.bc.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.statement.GimpleConditional;
import org.renjin.gcc.gimple.statement.GimpleEdge;
import org.renjin.gcc.gimple.statement.GimpleGoto;
import org.renjin.gcc.gimple.statement.GimpleReturn;
import org.renjin.gcc.gimple.statement.GimpleStatement;

public class GimpleBasicBlock {
    private int index;
    private List<GimpleStatement> statements = Lists.newArrayList();
    private List<GimpleEdge> edges = Lists.newArrayList();

    public GimpleBasicBlock() {
    }

    public GimpleBasicBlock(GimpleStatement ... statements) {
        this.statements.addAll(Arrays.asList(statements));
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getName() {
        return "" + this.index;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.index).append(">:\n");
        for (GimpleStatement ins : this.statements) {
            sb.append("  ").append(ins).append("\n");
        }
        return sb.toString();
    }

    public List<GimpleStatement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<GimpleStatement> statements) {
        this.statements = statements;
    }

    public List<GimpleEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<GimpleEdge> edges) {
        this.edges = edges;
    }

    public void replaceAll(Predicate<? super GimpleExpr> predicate, GimpleExpr newExpr) {
        for (GimpleStatement instruction : this.statements) {
            instruction.replaceAll(predicate, newExpr);
        }
    }

    public GimpleStatement getLast() {
        return this.statements.get(this.statements.size() - 1);
    }

    public boolean isReturning() {
        if (this.statements.isEmpty()) {
            return false;
        }
        return this.getLast() instanceof GimpleReturn;
    }

    public List<GimpleEdge> getJumps() {
        if (this.edges.isEmpty()) {
            return Collections.emptyList();
        }
        return this.edges;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public boolean fallsThrough() {
        if (this.statements.isEmpty()) {
            return true;
        }
        GimpleStatement lastStatement = this.statements.get(this.statements.size() - 1);
        return !(lastStatement instanceof GimpleReturn) && !(lastStatement instanceof GimpleConditional) && !(lastStatement instanceof GimpleGoto);
    }
}

