/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.var;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.var.VarAllocator;

public class ProvidedVarAllocator
extends VarAllocator {
    private final Class declaringClass;

    public ProvidedVarAllocator(Class declaringClass) {
        this.declaringClass = declaringClass;
    }

    @Override
    public SimpleLValue reserve(final String name, final Type type) {
        Field field;
        try {
            field = this.declaringClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new InternalCompilerException("The field '" + name + "' does not exist in class " + this.declaringClass.getName());
        }
        Type declaredType = Type.getType(field.getType());
        if (!declaredType.equals((Object)type)) {
            throw new InternalCompilerException(String.format("Type mismatch between provided field '%s: expected %s but found %s", name, type, declaredType));
        }
        return new SimpleLValue(){

            @Override
            @Nonnull
            public Type getType() {
                return type;
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                mv.visitFieldInsn(178, Type.getInternalName((Class)ProvidedVarAllocator.this.declaringClass), name, type.getDescriptor());
            }

            @Override
            public void store(MethodGenerator mv, SimpleExpr value) {
                value.load(mv);
                mv.visitFieldInsn(179, Type.getInternalName((Class)ProvidedVarAllocator.this.declaringClass), name, type.getDescriptor());
            }
        };
    }

    @Override
    public SimpleLValue reserve(String name, Type type, SimpleExpr initialValue) {
        throw new UnsupportedOperationException("TO CHECK");
    }
}

