/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.var;

import com.google.bc.common.base.Optional;
import com.google.bc.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.var.VarAllocator;

public class LocalVarAllocator
extends VarAllocator {
    private int slots = 0;
    private List<LocalVar> names = Lists.newArrayList();

    @Override
    public LocalVar reserve(String name, Type type) {
        return this.reserve(name, type, (Optional<SimpleExpr>)Optional.absent());
    }

    @Override
    public LocalVar reserve(String name, Type type, SimpleExpr initialValue) {
        return this.reserve(name, type, (Optional<SimpleExpr>)Optional.of((Object)initialValue));
    }

    private LocalVar reserve(String name, Type type, Optional<SimpleExpr> initialValue) {
        int index = this.slots;
        this.slots += type.getSize();
        LocalVar var = new LocalVar(name, index, type, initialValue);
        this.names.add(var);
        return var;
    }

    public void initializeVariables(MethodGenerator mv) {
        for (LocalVar name : this.names) {
            if (!name.initialValue.isPresent()) continue;
            name.store(mv, (SimpleExpr)name.initialValue.get());
        }
    }

    public void emitDebugging(MethodGenerator mv, Label start, Label end) {
        for (LocalVar entry : this.names) {
            mv.visitLocalVariable(this.toJavaSafeName(entry.name), entry.type.getDescriptor(), null, start, end, entry.index);
        }
    }

    private String toJavaSafeName(String name) {
        return name.replace('.', '$');
    }

    public static class LocalVar
    implements SimpleLValue {
        private String name;
        private int index;
        private Type type;
        private Optional<SimpleExpr> initialValue;

        public LocalVar(String name, int index, Type type, Optional<SimpleExpr> value) {
            this.name = name;
            this.index = index;
            this.type = type;
            this.initialValue = value;
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Override
        public void load(@Nonnull MethodGenerator mv) {
            mv.visitVarInsn(this.type.getOpcode(21), this.index);
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void store(MethodGenerator mv, SimpleExpr value) {
            value.load(mv);
            mv.visitVarInsn(this.type.getOpcode(54), this.index);
        }

        public String toString() {
            return "LocalVar[" + this.name + ":" + this.type + "]";
        }
    }
}

