/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.var;

import com.google.bc.common.base.Optional;
import com.google.bc.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.var.VarAllocator;

public class GlobalVarAllocator
extends VarAllocator {
    private final Type declaringClass;
    private final List<StaticField> fields = Lists.newArrayList();

    public GlobalVarAllocator(String declaringClass) {
        this.declaringClass = Type.getType((String)declaringClass);
    }

    @Override
    public SimpleLValue reserve(String name, Type type) {
        return this.reserve(name, type, (Optional<SimpleExpr>)Optional.absent());
    }

    public SimpleLValue reserve(String name, Type type, Optional<SimpleExpr> initialValue) {
        if (name.contains(".")) {
            throw new InternalCompilerException("illegal global variable name: " + name);
        }
        StaticField field = new StaticField(name, type, initialValue);
        this.fields.add(field);
        return field;
    }

    @Override
    public SimpleLValue reserve(String name, Type type, SimpleExpr initialValue) {
        return this.reserve(name, type, (Optional<SimpleExpr>)Optional.of((Object)initialValue));
    }

    public void writeFields(ClassVisitor cv) {
        for (StaticField field : this.fields) {
            cv.visitField(9, field.name, field.type.getDescriptor(), null, null);
        }
    }

    private class StaticField
    implements SimpleLValue {
        private String name;
        private Type type;
        private Optional<SimpleExpr> initialValue;

        public StaticField(String name, Type type, Optional<SimpleExpr> initialValue) {
            this.name = name;
            this.type = type;
            this.initialValue = initialValue;
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Override
        public void load(@Nonnull MethodGenerator mv) {
            mv.visitFieldInsn(178, GlobalVarAllocator.this.declaringClass.getInternalName(), this.name, this.type.getDescriptor());
        }

        @Override
        public void store(MethodGenerator mv, SimpleExpr value) {
            value.load(mv);
            mv.visitFieldInsn(179, GlobalVarAllocator.this.declaringClass.getInternalName(), this.name, this.type.getDescriptor());
        }
    }
}

