/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.record;

import com.google.bc.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.RecordClassGenerator;
import org.renjin.gcc.codegen.array.ArrayTypeStrategy;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.ExprFactory;
import org.renjin.gcc.codegen.expr.SimpleAddressableExpr;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.fatptr.AddressableField;
import org.renjin.gcc.codegen.fatptr.FatPtrStrategy;
import org.renjin.gcc.codegen.type.FieldStrategy;
import org.renjin.gcc.codegen.type.ParamStrategy;
import org.renjin.gcc.codegen.type.PointerTypeStrategy;
import org.renjin.gcc.codegen.type.ReturnStrategy;
import org.renjin.gcc.codegen.type.SimpleParamStrategy;
import org.renjin.gcc.codegen.type.TypeOracle;
import org.renjin.gcc.codegen.type.record.RecordConstructor;
import org.renjin.gcc.codegen.type.record.RecordFieldStrategy;
import org.renjin.gcc.codegen.type.record.RecordTypeStrategy;
import org.renjin.gcc.codegen.type.record.RecordValueFunction;
import org.renjin.gcc.codegen.type.record.unit.RecordUnitPtrStrategy;
import org.renjin.gcc.codegen.var.VarAllocator;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleConstructor;
import org.renjin.gcc.gimple.expr.GimpleFieldRef;
import org.renjin.gcc.gimple.type.GimpleArrayType;
import org.renjin.gcc.gimple.type.GimpleField;
import org.renjin.gcc.gimple.type.GimpleRecordTypeDef;

public class RecordClassTypeStrategy
extends RecordTypeStrategy<SimpleExpr> {
    private Type jvmType;
    private boolean provided;
    private boolean unitPointer;
    private Map<String, FieldStrategy> fields = null;

    public RecordClassTypeStrategy(GimpleRecordTypeDef recordTypeDef) {
        super(recordTypeDef);
    }

    public Type getJvmType() {
        if (this.jvmType == null) {
            throw new IllegalStateException("Type name of record " + this.getRecordType().getName() + " has not been initialized.");
        }
        return this.jvmType;
    }

    public void setJvmType(Type jvmType) {
        this.jvmType = jvmType;
    }

    public boolean isProvided() {
        return this.provided;
    }

    public void setProvided(boolean provided) {
        this.provided = provided;
    }

    public boolean isUnitPointer() {
        return this.unitPointer;
    }

    public void setUnitPointer(boolean unitPointer) {
        this.unitPointer = unitPointer;
    }

    @Override
    public void linkFields(TypeOracle typeOracle) {
        this.fields = new HashMap<String, FieldStrategy>();
        for (GimpleField gimpleField : this.getRecordTypeDef().getFields()) {
            FieldStrategy fieldStrategy = typeOracle.forField(this.getJvmType(), gimpleField);
            this.fields.put(gimpleField.getName(), fieldStrategy);
        }
    }

    @Override
    public final ParamStrategy getParamStrategy() {
        return new SimpleParamStrategy(this.jvmType);
    }

    @Override
    public ReturnStrategy getReturnStrategy() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public SimpleExpr variable(GimpleVarDecl decl, VarAllocator allocator) {
        SimpleLValue instance = allocator.reserve(decl.getName(), this.jvmType, new RecordConstructor(this));
        if (this.isUnitPointer()) {
            return new SimpleAddressableExpr(instance, instance);
        }
        return instance;
    }

    @Override
    public FieldStrategy fieldGenerator(Type className, String fieldName) {
        return new RecordFieldStrategy(this, fieldName);
    }

    @Override
    public FieldStrategy addressableFieldGenerator(Type className, String fieldName) {
        return new AddressableField(this.getJvmType(), fieldName, new RecordValueFunction(this));
    }

    public Expr voidCast(Expr voidPtr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleExpr constructorExpr(ExprFactory exprFactory, GimpleConstructor value) {
        HashMap fields = Maps.newHashMap();
        for (GimpleConstructor.Element element : value.getElements()) {
            Expr fieldValue = exprFactory.findGenerator(element.getValue());
            fields.put((GimpleFieldRef)element.getField(), fieldValue);
        }
        return new RecordConstructor(this, fields);
    }

    @Override
    public void writeClassFiles(File outputDirectory) throws IOException {
        if (this.isProvided()) {
            return;
        }
        RecordClassGenerator classGenerator = new RecordClassGenerator(this.jvmType, this.fields.values());
        classGenerator.writeClassFile(outputDirectory);
    }

    @Override
    public Expr memberOf(SimpleExpr instance, GimpleFieldRef fieldRef) {
        if (this.fields == null) {
            throw new IllegalStateException("Fields map is not yet initialized.");
        }
        FieldStrategy fieldStrategy = this.fields.get(fieldRef.getName());
        if (fieldStrategy == null) {
            throw new InternalCompilerException(String.format("No field named '%s' in record type '%s'", fieldRef.getName(), this.jvmType));
        }
        return fieldStrategy.memberExprGenerator(instance);
    }

    @Override
    public ArrayTypeStrategy arrayOf(GimpleArrayType arrayType) {
        return new ArrayTypeStrategy(arrayType, new RecordValueFunction(this));
    }

    @Override
    public PointerTypeStrategy pointerTo() {
        if (this.unitPointer) {
            return new RecordUnitPtrStrategy(this);
        }
        return new FatPtrStrategy(new RecordValueFunction(this));
    }

    public RecordUnitPtrStrategy pointerToUnit() {
        return new RecordUnitPtrStrategy(this);
    }
}

