/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive.op;

import javax.annotation.Nonnull;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;

public class UnorderedExpr
implements SimpleExpr {
    private SimpleExpr x;
    private SimpleExpr y;

    public UnorderedExpr(SimpleExpr x, SimpleExpr y) {
        this.x = x;
        this.y = y;
    }

    @Override
    @Nonnull
    public Type getType() {
        return Type.BOOLEAN_TYPE;
    }

    @Override
    public void load(@Nonnull MethodGenerator mv) {
        Label unordered = new Label();
        Label exit = new Label();
        this.emitIsNaN(mv, this.x);
        mv.ifne(unordered);
        this.emitIsNaN(mv, this.y);
        mv.ifne(unordered);
        mv.iconst(0);
        mv.goTo(exit);
        mv.mark(unordered);
        mv.iconst(1);
        mv.mark(exit);
    }

    private void emitIsNaN(MethodGenerator mv, SimpleExpr value) {
        value.load(mv);
        switch (value.getType().getSort()) {
            case 8: {
                mv.invokestatic(Double.class, "isNaN", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.DOUBLE_TYPE}));
                break;
            }
            case 6: {
                mv.invokestatic(Double.class, "isNaN", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.FLOAT_TYPE}));
                break;
            }
            default: {
                throw new IllegalStateException("type: " + value.getType());
            }
        }
    }
}

